/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LESNMP;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEConfirmClient;
import com.lucent.ra.nms.ui.LEConfirmDialog;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LETextArea;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LECommandPanel
extends Panel
implements LEConfirmClient,
ActionListener,
ItemListener {
    static final String BROWSE = "Browse...";
    static final String REBOOT = "reb";
    static final String SUCCESS = "Command succeded";
    static final String FAILURE = "Command failed";
    static final String DEFAULT_SYSNAME = "Command";
    static final String SEPARATOR = "> ";
    static final String SHOW_COMMAND = "sh";
    static final String SET_SYSNAME_1 = "se sysn";
    static final String SET_SYSNAME_2 = "set sysn";
    static final String SET_VIEW_1 = "se vi";
    static final String SET_VIEW_2 = "set vi";
    static final String SHOW_VIEW = "show view";
    static final String CURRENT_VIEW = "Current view set to";
    static final String MGR_VIEW = " 4";
    static final char CR = '\r';
    static final char REPLACEMENT = ' ';
    static String[] s_invalidCmds = null;
    LETextArea m_screen;
    Checkbox m_ignore;
    Checkbox m_echo;
    TextField m_path;
    Button m_browse;
    LEPortMaster m_pm;
    String m_prompt;
    File m_file;
    PrintWriter m_prw;
    boolean m_ignoring;

    static void initInvalidCmds() {
        s_invalidCmds = new String[11];
        LECommandPanel.s_invalidCmds[0] = new String("at");
        LECommandPanel.s_invalidCmds[1] = new String("tr");
        LECommandPanel.s_invalidCmds[2] = new String("pi");
        LECommandPanel.s_invalidCmds[3] = new String("te");
        LECommandPanel.s_invalidCmds[4] = new String("rl");
        LECommandPanel.s_invalidCmds[5] = new String("pm");
        LECommandPanel.s_invalidCmds[6] = new String("pt");
        LECommandPanel.s_invalidCmds[7] = new String("set deb");
        LECommandPanel.s_invalidCmds[8] = new String("se deb");
        LECommandPanel.s_invalidCmds[9] = new String("di");
        LECommandPanel.s_invalidCmds[10] = new String("tf");
    }

    static boolean validCommand(String string) {
        boolean bl = true;
        int n = s_invalidCmds.length;
        int n2 = 0;
        while (bl && n2 < n) {
            String string2;
            if (string.length() >= s_invalidCmds[n2].length() && (string2 = string.substring(0, s_invalidCmds[n2].length())).equalsIgnoreCase(s_invalidCmds[n2])) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public LECommandPanel(LEPortMaster lEPortMaster) {
        if (s_invalidCmds == null) {
            LECommandPanel.initInvalidCmds();
        }
        this.m_pm = lEPortMaster;
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 1));
        Label label = new Label(this.m_pm.getDescription(), 1);
        label.setFont(LEFont.getBoldFont());
        panel.add(label);
        this.m_ignore = new Checkbox("Ignore Commands", null, false);
        panel.add(this.m_ignore);
        this.m_ignore.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(0, 0));
        this.m_echo = new Checkbox("Echo to file:", null, false);
        this.m_echo.addItemListener(this);
        panel2.add("West", this.m_echo);
        this.m_path = new TextField();
        ((Component)this.m_path).setBackground(LEColor.getTextBackground());
        this.m_path.addActionListener(this);
        panel2.add("Center", this.m_path);
        this.m_browse = new Button(BROWSE);
        this.m_browse.addActionListener(this);
        panel2.add("East", this.m_browse);
        panel.add(panel2);
        this.add("North", panel);
        this.m_screen = new LETextArea(24, 80);
        this.add("Center", this.m_screen);
        this.m_screen.setEditable(false);
        this.m_screen.setFont(LEFont.getFixedFont());
        this.setPrompt();
        this.m_screen.append(this.m_prompt);
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_ignore) {
            this.m_ignoring = this.m_ignore.getState();
            return;
        }
        if (object == this.m_echo && this.m_echo.getState()) {
            this.confirmEchoFile();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(BROWSE)) {
            this.browseFile();
            return;
        }
        if (this.m_echo.getState()) {
            this.confirmEchoFile();
        }
    }

    public void processCommand(String string) {
        if (this.m_ignore.getState()) {
            return;
        }
        this.m_screen.append(string);
        this.m_screen.append("\n");
        if (this.m_echo.getState() && this.m_prw != null) {
            this.m_prw.print(this.m_prompt);
            this.m_prw.println(string);
        }
        if (LEAppInfo.DemoMode() && !string.startsWith(SHOW_COMMAND)) {
            this.m_screen.append("Only show commands are allowed in DEMO mode");
            this.m_screen.append("\n");
            if (this.m_echo.getState() && this.m_prw != null) {
                this.m_prw.println("Only show commands are allowed in DEMO mode");
            }
            this.m_screen.append(this.m_prompt);
            String string2 = this.m_screen.getText();
            this.m_screen.select(string2.length(), string2.length());
            return;
        }
        if (LEPMCommand.IsReboot(string)) {
            new LERebootThread(this.m_pm);
            return;
        }
        if (LECommandPanel.validCommand(string)) {
            String string3;
            LEPMCommand lEPMCommand = this.m_pm.execute(string);
            if (lEPMCommand != null) {
                string3 = lEPMCommand.getResult();
                string3 = string3 != null && string3.length() > 0 ? string3.replace('\r', ' ') : (lEPMCommand.getStatus() ? SUCCESS : FAILURE);
                this.m_screen.append(string3);
                this.m_screen.append("\n");
                if (this.m_echo.getState() && this.m_prw != null) {
                    this.m_prw.println(string3);
                }
                if (lEPMCommand.getStatus()) {
                    this.checkPrompt(string);
                }
            }
            this.m_screen.append(this.m_prompt);
            string3 = this.m_screen.getText();
            this.m_screen.select(string3.length(), string3.length());
            return;
        }
        String string4 = "This command cannot be executed from within " + LEAppInfo.getAppName();
        this.m_screen.append(string4);
        this.m_screen.append("\n");
        if (this.m_echo.getState() && this.m_prw != null) {
            this.m_prw.println(string4);
        }
        this.m_screen.append(this.m_prompt);
        String string5 = this.m_screen.getText();
        this.m_screen.select(string5.length(), string5.length());
    }

    public void cleanup() {
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        this.m_prw = null;
        this.m_file = null;
        this.m_pm = null;
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setEchoFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_file = null;
        this.m_prw = null;
        ((TextComponent)this.m_path).setText(null);
    }

    public void setPrompt() {
        String string;
        String string2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_pm.isConnected()) {
            object = (LESNMP)this.m_pm.get("1376256");
            if (object != null) {
                ((LEConfig)object).refresh();
                string2 = (String)((LEConfig)object).get("sysname");
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            }
            this.m_ignore.setEnabled(true);
            this.m_ignore.setState(this.m_ignoring);
        } else {
            this.m_ignore.setState(true);
            this.m_ignore.setEnabled(false);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(DEFAULT_SYSNAME);
        }
        if (this.m_pm.getHardwareType().equals("PM-4") && (object = this.m_pm.execute(SHOW_VIEW)) != null && ((LEPMCommand)object).getStatus() && (string2 = ((LEPMCommand)object).getResult()).startsWith(CURRENT_VIEW) && !(string = string2.substring(19, string2.length() - 3)).equals(MGR_VIEW)) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SEPARATOR);
        this.m_prompt = new String(stringBuffer);
    }

    void checkPrompt(String string) {
        if (string.startsWith(SET_SYSNAME_1) || string.startsWith(SET_SYSNAME_2) || string.startsWith(SET_VIEW_1) || string.startsWith(SET_VIEW_2)) {
            this.setPrompt();
        }
    }

    void browseFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.getFrame(this), "Command Echo File", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setVisible(true);
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            ((TextComponent)this.m_path).setText(string3);
            LEAppInfo.setLastDirectory(string);
            if (this.m_echo.getState()) {
                this.confirmEchoFile();
            }
        }
    }

    void confirmEchoFile() {
        String string = this.m_path.getText();
        if (string.length() == 0) {
            this.m_file = null;
            this.m_prw = null;
            return;
        }
        File file = new File(string);
        if (this.m_file == null || !file.getAbsolutePath().equals(this.m_file.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.getFrame(this), (LEConfirmClient)this, String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?", stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setEchoFile(file);
        }
    }

    void setEchoFile(File file) {
        this.m_file = file;
        ((TextComponent)this.m_path).setText(this.m_file.getAbsolutePath());
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_file);
            this.m_prw = new PrintWriter((Writer)fileWriter, true);
            return;
        }
        catch (IOException iOException) {
            this.m_file = null;
            this.m_prw = null;
            ((TextComponent)this.m_path).setText(null);
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
            return;
        }
    }
}

