/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;

public class LECommandView
extends Panel
implements LEPMView,
ActionListener,
ItemListener,
KeyListener {
    static final int HISTORY_LEN = 50;
    static final String REPEAT_COMMAND = "!!";
    static final char HELP_SUFFIX = '?';
    static Hashtable s_panels = new Hashtable();
    static LEVector s_hist = new LEVector();
    LETextField m_cmd;
    Choice m_history;
    Panel m_histPanel;
    Panel m_cmdEntry;
    Panel m_main;
    int m_commandIndex;
    LEVector m_panels = new LEVector();

    public static synchronized void removePM(String string) {
        LECommandPanel lECommandPanel = (LECommandPanel)s_panels.remove(string);
        if (lECommandPanel != null) {
            lECommandPanel.cleanup();
        }
    }

    public LECommandView() {
        this.setLayout(new BorderLayout(0, 10));
        this.m_cmdEntry = this.commandEntry();
        this.m_cmdEntry.setVisible(false);
        this.m_main = new Panel();
        this.add("Center", this.m_main);
        this.add("South", this.m_cmdEntry);
        this.m_commandIndex = 0;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_cmd.setText((String)itemEvent.getItem());
        this.m_cmd.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LEUiUtils.setBusy(this);
        String string = actionEvent.getActionCommand();
        if (this.updateHistory(string)) {
            string = s_hist.elementAt(this.m_commandIndex).toString();
            int n = this.m_panels.size();
            int n2 = 0;
            while (n2 < n) {
                LECommandPanel lECommandPanel = (LECommandPanel)this.m_panels.elementAt(n2);
                lECommandPanel.processCommand(string);
                ++n2;
            }
            this.m_cmd.select(0, string.length());
        } else {
            this.m_cmd.setText("");
        }
        LEUiUtils.setIdle(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            if (s_hist.size() > 0 && this.m_commandIndex < s_hist.size() - 1) {
                ++this.m_commandIndex;
                String string = (String)s_hist.elementAt(this.m_commandIndex);
                this.m_cmd.setText(string);
                this.m_history.select(this.m_commandIndex);
                return;
            }
        } else if (keyEvent.getKeyCode() == 40 && s_hist.size() > 0 && this.m_commandIndex > 0) {
            --this.m_commandIndex;
            String string = (String)s_hist.elementAt(this.m_commandIndex);
            this.m_cmd.setText(string);
            this.m_history.select(this.m_commandIndex);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_main.removeAll();
        this.m_panels.removeAllElements();
        this.m_main.setLayout(new GridLayout(1, lEPortMasterArray.length, 5, 5));
        int n = 0;
        while (n < lEPortMasterArray.length) {
            String string = lEPortMasterArray[n].getResourceID();
            LECommandPanel lECommandPanel = (LECommandPanel)s_panels.get(string);
            if (lECommandPanel == null) {
                lECommandPanel = new LECommandPanel(lEPortMasterArray[n]);
                s_panels.put(string, lECommandPanel);
            } else {
                lECommandPanel.setPrompt();
            }
            this.m_main.add(lECommandPanel);
            this.m_panels.addElement(lECommandPanel);
            ++n;
        }
        if (lEPortMasterArray.length > 0) {
            this.m_cmdEntry.setVisible(true);
        } else {
            this.m_cmdEntry.setVisible(false);
        }
        this.invalidate();
        this.validate();
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        return null;
    }

    public void going() {
    }

    public void gone() {
        this.m_main.removeAll();
        this.m_panels.removeAllElements();
    }

    public void addListener(LEViewListener lEViewListener) {
    }

    public void deleteListener(LEViewListener lEViewListener) {
    }

    boolean updateHistory(String string) {
        boolean bl;
        if (string.startsWith(REPEAT_COMMAND)) {
            string = s_hist.size() == 0 ? null : this.getBangCommand(string);
        }
        if (string != null) {
            String string2 = null;
            if (s_hist.size() > 0) {
                string2 = (String)s_hist.elementAt(this.m_commandIndex);
            }
            if (string2 == null || !string.equals(string2)) {
                this.m_histPanel.remove(this.m_history);
                this.m_history = new Choice();
                this.m_history.addItemListener(this);
                this.m_commandIndex = 0;
                s_hist.insertElementAt(string, this.m_commandIndex);
                int n = s_hist.size();
                if (n > 50) {
                    s_hist.removeElementAt(50);
                    n = 50;
                }
                int n2 = 0;
                while (n2 < n) {
                    this.m_history.addItem((String)s_hist.elementAt(n2));
                    ++n2;
                }
                this.m_histPanel.add("South", this.m_history);
                this.m_cmdEntry.invalidate();
                this.m_cmdEntry.validate();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    String getBangCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)s_hist.elementAt(0);
        if (string.length() > REPEAT_COMMAND.length()) {
            int n = string2.lastIndexOf(63);
            if (n > -1) {
                if (Character.isWhitespace(string2.charAt(n - 1))) {
                    int n2 = n + 1;
                    int n3 = string2.length();
                    while (n2 < n3 && n > -1) {
                        if (Character.isWhitespace(string2.charAt(n2++))) continue;
                        n = -1;
                    }
                } else {
                    n = -1;
                }
            }
            if (n > -1) {
                stringBuffer.append(string2.substring(0, n));
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string.substring(REPEAT_COMMAND.length(), string.length()));
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    Panel commandEntry() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        panel2.add(new Label("Command: "));
        panel.add("West", panel2);
        this.m_histPanel = new Panel();
        this.m_histPanel.setLayout(new BorderLayout(0, 0));
        this.m_cmd = new LETextField();
        this.m_cmd.addActionListener(this);
        this.m_cmd.addKeyListener(this);
        this.m_histPanel.add("North", this.m_cmd);
        ((Component)this.m_cmd).setBackground(LEColor.getTextBackground());
        this.m_history = new Choice();
        this.m_history.addItemListener(this);
        this.m_histPanel.add("South", this.m_history);
        int n = s_hist.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_history.addItem((String)s_hist.elementAt(n2));
            ++n2;
        }
        panel.add("Center", this.m_histPanel);
        return panel;
    }
}

