/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_R;
import com.lucent.ra.nms.backend.LEConnectionManager_R;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LESimpleCM_RI;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.backend.LETemplateDSSFlatFile;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;
import java.rmi.RemoteException;

public class LEConnectionManager {
    public static final String LOCAL = "local";
    LEConnectionManager_R m_cm;
    String m_id;
    String m_descr;
    static LEConnectionManager s_cm = null;

    public static LEConnectionManager Initialize() {
        if (s_cm == null) {
            s_cm = new LEConnectionManager();
        }
        return s_cm;
    }

    public static LEConnectionManager GetDefault() {
        return s_cm;
    }

    public LEConnectionManager() {
        try {
            this.m_cm = new LESimpleCM_RI();
            this.m_descr = this.m_id = LOCAL;
        }
        catch (RemoteException remoteException) {}
    }

    public LEConnectionManager(String id, String description, LEConnectionManager_R cm) {
        this.m_cm = cm;
        this.m_id = id;
        this.m_descr = description;
    }

    public String getDescription() {
        return this.m_descr;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public LEConnectionManager_R getConnectionManager() {
        return this.m_cm;
    }

    public boolean isConnected() {
        return this.m_cm != null;
    }

    public LEAMRouter_R getAMRouter() {
        LEAMRouter_R router = null;
        try {
            if (this.m_cm != null) {
                router = this.m_cm.getAMRouter();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return router;
    }

    public LEDSSPortMaster connectToPM(String host, String user, String pw) throws IOException, LEDSSException {
        if (this.m_cm == null) {
            throw new LEDSSException("No connection to server");
        }
        String id = LEResourceID.CreatePM_ID(host, user);
        LEAMManager_RI.GetManager().addID(this.getAMRouter(), id);
        LEDSSPortMaster dss = null;
        try {
            dss = new LEDSSPortMaster(this.m_id, id, this.m_cm.connectToPM(host, user, pw), host, user, pw);
        }
        catch (RemoteException e) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), id);
            this.handleRemoteException(e);
            throw new IOException("Lost connection to server");
        }
        catch (IOException e) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), id);
            throw e;
        }
        catch (LEDSSException e) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), id);
            throw e;
        }
        return dss;
    }

    public LEDSSFlatFile connectToFile(String fullpath, int mode) throws LEDSSException {
        if (this.m_cm == null) {
            throw new LEDSSException("No connection to server");
        }
        String id = LEResourceID.CreateFile_ID(fullpath);
        LEAMManager_RI.GetManager().addID(this.getAMRouter(), id);
        LEDSSFlatFile dss = null;
        try {
            if (this.m_cm != null) {
                dss = new LEDSSFlatFile(this.m_cm.connectToFile(fullpath, mode));
            }
        }
        catch (RemoteException e) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), id);
            this.handleRemoteException(e);
        }
        return dss;
    }

    public LETemplateDSSFlatFile connectToTemplateFile(String fullpath, int mode, LEVector templates) throws LEDSSException {
        if (this.m_cm == null) {
            throw new LEDSSException("No connection to server");
        }
        String id = LEResourceID.CreateFile_ID(fullpath);
        LEAMManager_RI.GetManager().addID(this.getAMRouter(), id);
        LETemplateDSSFlatFile dss = null;
        try {
            if (this.m_cm != null) {
                dss = new LETemplateDSSFlatFile(this.m_cm.connectToTemplateFile(fullpath, mode, templates));
            }
        }
        catch (RemoteException e) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), id);
            this.handleRemoteException(e);
        }
        return dss;
    }

    public void disconnectFrom(LEDSS dss) {
        String id = dss.getResourceID();
        LEStatusMessage stat = new LEStatusMessage(2);
        LEAMManager_RI.Process(id, "STATUS", stat);
        LEAMManager_RI.GetManager().removeID(this.getAMRouter(), id);
        try {
            if (this.m_cm.shouldDisconnect(id)) {
                dss.disconnect();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    void handleRemoteException(RemoteException e) {
        LEDebug.getLog().logln(20, e);
        LEStatusMessage msg = new LEStatusMessage(2);
        LEAMManager_RI.Process(this.m_id, "STATUS", msg);
        this.m_cm = null;
    }
}

