/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.io.Serializable;

public class LEISDNSummaryMessage
extends LEEntityMessage
implements Serializable {
    String m_dno;
    String m_ports;
    String m_l1_state;
    String m_l2_state;
    int m_time;
    String m_ftime;
    String m_isdn_init;
    String m_isdn_up;
    String m_isdn_down;

    public LEISDNSummaryMessage(String id, int request, String name) {
        super(id, request, name);
        this.m_messageType = "MONITOR";
    }

    public String getDNumber() {
        return this.m_dno;
    }

    public String getPorts() {
        return this.m_ports;
    }

    public String getL1State() {
        return this.m_l1_state;
    }

    public String getL2State() {
        return this.m_l2_state;
    }

    public int getTime() {
        return this.m_time;
    }

    public String getISDNInit() {
        return this.m_isdn_init;
    }

    public String getISDNUp() {
        return this.m_isdn_up;
    }

    public String getISDNDown() {
        return this.m_isdn_down;
    }

    public String getFormatedTime() {
        if (this.m_ftime == null) {
            this.m_ftime = LEUpTimeCompare.FormatTime(this.m_time);
        }
        return this.m_ftime;
    }

    public void setAttribute(int attribute, String value) {
        try {
            switch (attribute) {
                case 416: {
                    this.m_dno = value;
                    break;
                }
                case 275: {
                    this.setBoard(value);
                    break;
                }
                case 132: {
                    this.m_ports = value;
                    break;
                }
                case 67: {
                    this.m_time = Integer.parseInt(value);
                    break;
                }
                case 96: {
                    this.m_l1_state = value;
                    break;
                }
                case 127: {
                    this.m_l2_state = value;
                    break;
                }
                case 126: {
                    this.m_isdn_init = value;
                    break;
                }
                case 124: {
                    this.m_isdn_up = value;
                    break;
                }
                case 125: {
                    this.m_isdn_down = value;
                    break;
                }
                default: {
                    LEDebug.getLog().logln(30, "Bad ISDN Summary Attribute: " + attribute + ", " + value);
                    break;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

