/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPSecProfileForm
extends LETableForm {
    private static final int MAX_RULES = 20;
    int m_numRules;
    String m_pfilter;
    String m_sa;

    void addEntry(String string, LETable lETable, String string2) {
        if (lETable instanceof LEIPSecProfile) {
            this.m_numRules = lETable.size();
        }
        super.addEntry(string, lETable, string2);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("Rule Number:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPSec Profile Rule Number", panel);
        if (lEAddDialog.okay()) {
            if (!Integer.toString(this.m_numRules + 1).equals(((LEFormLine)((Object)component)).getValue())) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Rule number must be 1 + current rule count");
                return false;
            }
            if (this.m_numRules >= 20) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Rule no. must be less than " + Integer.toString(20));
                return false;
            }
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LEIPSecProfile lEIPSecProfile = (LEIPSecProfile)this.getTable(lEPortMaster);
        if (!this.getFilterAndSA(lEPortMaster, lEIPSecProfile)) {
            return null;
        }
        LEVector lEVector = lEIPSecProfile.add(this.m_pfilter, this.m_sa);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            this.refresh();
        } else {
            String string = Integer.toString(lEIPSecProfile.size());
            this.addEntry(lEPortMaster.getDescription(), lEIPSecProfile, string);
            lENewEntry = new LENewEntry(lEPortMaster, lEIPSecProfile, string);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEIPSecProfile)) {
            return;
        }
        LEIPSecProfile lEIPSecProfile = (LEIPSecProfile)lETable;
        try {
            int n = Integer.parseInt(string);
            LEVector lEVector = lEIPSecProfile.delete(n);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
        }
    }

    boolean getFilterAndSA(LEPortMaster lEPortMaster, LEIPSecProfile lEIPSecProfile) {
        LEDataSpec lEDataSpec = lEIPSecProfile.getSpecFor("entry");
        LEDataSpec lEDataSpec2 = lEDataSpec.getSpecFor("505");
        Component[][] componentArray = new Component[2][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec2.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(lEPortMaster, null, null, lEDataSpec2);
        lEDataSpec2 = lEDataSpec.getSpecFor("506");
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec2.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(lEPortMaster, null, null, lEDataSpec2);
        Panel panel = new Panel();
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Select Policy Filter and/or SA for " + lEPortMaster.getDescription(), panel);
        if (lEAddDialog.okay()) {
            this.m_pfilter = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_sa = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            if (this.m_pfilter.length() > 0 || this.m_sa.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A filter or Static SA must be specified");
        }
        return false;
    }
}

