/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEDebugFactory;
import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.backend.LEPMDebug;
import com.lucent.ra.nms.backend.LEPMEntity;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEConfirmClient;
import com.lucent.ra.nms.ui.LEConfirmDialog;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LETextArea;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternCompiler;
import com.oroinc.text.regex.PatternMatcher;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

class LEDebugPanel
extends Panel
implements LEAMObserver,
LEConfirmClient,
ActionListener,
ItemListener {
    static final String EOL = "\n";
    static PatternCompiler s_compiler;
    static PatternMatcher s_matcher;
    LEDebugOptions m_dialog;
    Label m_title;
    Checkbox m_debug;
    Checkbox m_useFilter;
    Checkbox m_echo;
    Label m_state;
    TextField m_filter;
    TextField m_path;
    Button m_select;
    Button m_browse;
    LETextArea m_screen;
    LEPortMaster m_pm;
    File m_file;
    PrintWriter m_prw;
    Pattern m_pattern;
    int[] m_entities;
    int[] m_debugs;

    public LEDebugPanel(LEPortMaster lEPortMaster) {
        if (s_compiler == null) {
            s_compiler = new Perl5Compiler();
            s_matcher = new Perl5Matcher();
        }
        this.m_pm = lEPortMaster;
        LEDebugFactory.GetFactory().addObserver(lEPortMaster.getResourceID(), this);
        LEStatusFactory.GetFactory().addObserver(lEPortMaster.getResourceID(), this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.m_title = new Label(lEPortMaster.getDescription(), 1);
        Component component = this.m_title;
        component.setFont(LEFont.getBoldFont());
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_debug = new Checkbox("Debug:", null, false);
        component = this.m_debug;
        this.m_debug.addItemListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_useFilter = new Checkbox("Filter:", null, false);
        component = this.m_useFilter;
        this.m_useFilter.addItemListener(this);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_echo = new Checkbox("Echo to File:", null, false);
        component = this.m_echo;
        this.m_echo.addItemListener(this);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_state = new Label("Nothing selected");
        component = this.m_state;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_filter = new TextField();
        component = this.m_filter;
        this.m_filter.addActionListener(this);
        component.setBackground(LEColor.getTextBackground());
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_path = new TextField();
        component = this.m_path;
        this.m_path.addActionListener(this);
        component.setBackground(LEColor.getTextBackground());
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_select = new Button("Select...");
        component = this.m_select;
        this.m_select.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_browse = new Button("Browse...");
        component = this.m_browse;
        this.m_browse.addActionListener(this);
        gridBagConstraints.gridy += 2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.m_screen = new LETextArea();
        component = this.m_screen;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        this.checkState();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_dialog != null) {
            this.m_dialog.dispose();
            this.m_dialog = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_select) {
            this.m_dialog = new LEDebugOptions(LEUiUtils.getFrame(this), this.m_title.getText(), this, this.m_pm.getPlatformKey());
            if (this.m_entities != null) {
                this.m_dialog.setOptions(this.m_entities, this.m_debugs);
                return;
            }
        } else {
            if (object == this.m_browse) {
                this.browseFile();
                return;
            }
            if (object == this.m_path) {
                if (this.m_echo.getState()) {
                    this.confirmEchoFile();
                    return;
                }
            } else if (object == this.m_filter) {
                this.checkFilter();
            }
        }
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_echo) {
            if (this.m_echo.getState()) {
                this.confirmEchoFile();
                return;
            }
        } else {
            if (object == this.m_debug) {
                if (this.m_debug.getState()) {
                    this.startDebugging(this.m_entities, this.m_debugs);
                    return;
                }
                this.stopDebugging(this.m_entities, this.m_debugs);
                return;
            }
            if (object == this.m_useFilter) {
                this.checkFilter();
            }
        }
    }

    public synchronized void setOptions(int[] nArray, int[] nArray2) {
        if (this.m_debug.getState()) {
            this.startDebugging(nArray, nArray2);
            this.stopDebugging(this.m_entities, this.m_debugs);
        }
        this.m_entities = nArray;
        this.m_debugs = nArray2;
        this.setStateLabel();
        this.m_dialog = null;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDebugMessage) {
            if (!this.m_debug.getState()) {
                return;
            }
            LEDebugMessage lEDebugMessage = (LEDebugMessage)object;
            String string2 = lEDebugMessage.getData();
            if (this.m_useFilter.getState() && this.m_pattern != null && !s_matcher.contains(string2, this.m_pattern)) {
                string2 = null;
            }
            if (string2 != null) {
                if (string2.charAt(string2.length() - 1) == '\n') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (this.m_echo.getState() && this.m_prw != null) {
                    this.m_prw.println(string2);
                }
                this.m_screen.append(string2);
                this.m_screen.append(EOL);
                string2 = this.m_screen.getText();
                this.m_screen.select(string2.length(), string2.length());
                return;
            }
        } else if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            switch (lEStatusMessage.getStatus()) {
                case 1: {
                    this.checkState();
                    return;
                }
                case 2: 
                case 4: {
                    this.checkState();
                    return;
                }
            }
        }
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setEchoFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_file = null;
        this.m_prw = null;
        ((TextComponent)this.m_path).setText(null);
    }

    synchronized void startDebugging(int[] nArray, int[] nArray2) {
        if (!this.m_pm.isConnected() || nArray == null) {
            return;
        }
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        int n = 0;
        while (n < nArray.length) {
            lEPMConnectionFacade.startDebug(nArray[n], nArray2[n], -1);
            ++n;
        }
    }

    synchronized void stopDebugging(int[] nArray, int[] nArray2) {
        if (!this.m_pm.isConnected() || nArray == null) {
            return;
        }
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        int n = 0;
        while (n < nArray.length) {
            lEPMConnectionFacade.stopDebug(nArray[n], nArray2[n], -1);
            ++n;
        }
    }

    void checkState() {
        boolean bl = this.m_pm.getConnectionFacade().supportsEntities();
        if (!this.m_pm.isConnected() || !bl) {
            this.m_debug.setState(false);
            this.m_debug.setEnabled(false);
            if (!bl) {
                this.m_screen.append("Debugging requires ComOS 3.8 or later");
            }
            this.stopDebugging(this.m_entities, this.m_debugs);
            return;
        }
        if (!this.m_debug.isEnabled()) {
            this.m_debug.setEnabled(true);
            if (this.m_debug.getState()) {
                this.startDebugging(this.m_entities, this.m_debugs);
            }
        }
    }

    void checkFilter() {
        if (this.m_useFilter.getState()) {
            String string = this.m_filter.getText();
            if (string.length() > 0) {
                try {
                    this.m_pattern = s_compiler.compile(string);
                    return;
                }
                catch (MalformedPatternException malformedPatternException) {
                    new LEErrorDialog(LEUiUtils.getFrame(this), "The filter: \"" + string + "\" is not a valid Perl5 regular expression");
                    ((TextComponent)this.m_filter).setText(null);
                    this.m_pattern = null;
                    return;
                }
            }
            this.m_pattern = null;
        }
    }

    void browseFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.getFrame(this), "Command Echo File", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        fileDialog.show();
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            ((TextComponent)this.m_path).setText(string3);
            LEAppInfo.setLastDirectory(string);
            if (this.m_echo.getState()) {
                this.confirmEchoFile();
            }
        }
    }

    void confirmEchoFile() {
        String string = this.m_path.getText();
        if (string.length() == 0) {
            this.m_file = null;
            this.m_prw = null;
            return;
        }
        File file = new File(string);
        if (this.m_file == null || !file.getAbsolutePath().equals(this.m_file.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                String string2 = String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?";
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.getFrame(this), (LEConfirmClient)this, string2, stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setEchoFile(file);
        }
    }

    void setEchoFile(File file) {
        this.m_file = file;
        ((TextComponent)this.m_path).setText(this.m_file.getAbsolutePath());
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_file);
            this.m_prw = new PrintWriter((Writer)fileWriter, true);
            return;
        }
        catch (IOException iOException) {
            this.m_file = null;
            this.m_prw = null;
            ((TextComponent)this.m_path).setText(null);
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
            return;
        }
    }

    void setStateLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_entities.length) {
            String string;
            if (this.m_entities[n2] != n) {
                if (n > -1) {
                    stringBuffer.append("; ");
                }
                if ((n = this.m_entities[n2]) == 393216) {
                    stringBuffer.append("Hex Command");
                } else if (n == 131072) {
                    stringBuffer.append(LEPMEntity.GetEntityString(0x190000));
                } else {
                    stringBuffer.append(LEPMEntity.GetEntityString(n));
                }
                string = ": ";
            } else {
                string = ", ";
            }
            if (n != 0x170000 && n != 0x230000 && n != 0x3A0000 && n != 458752) {
                stringBuffer.append(string);
                if (n == 393216) {
                    stringBuffer.append("0x");
                    stringBuffer.append(Integer.toHexString(this.m_debugs[n2]));
                } else if (n == 0x350000) {
                    stringBuffer.append(LEPMDebug.GetL2TPDebugString(this.m_debugs[n2]));
                } else {
                    stringBuffer.append(LEPMDebug.GetDebugString(this.m_debugs[n2]));
                }
            }
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Nothing selected");
        }
        this.m_state.setText(new String(stringBuffer));
    }
}

