/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEMonEthersMessage;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.graph.LEFilledGraph;
import com.lucent.ra.nms.graph.LEGraphData;
import com.lucent.ra.nms.graph.LEGraphPanel;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class LEEtherGraph
extends Frame
implements WindowListener,
LEAMObserver,
Runnable {
    static SimpleDateFormat s_simple = null;
    static DateFormat s_format = null;
    static final int ETHER = 0;
    static final int TIME = 1;
    static final int IN_PKTS = 2;
    static final int OUT_PKTS = 3;
    static final int IN_BYTES = 4;
    static final int OUT_BYTES = 5;
    LEPortMaster m_pm;
    LEGraphPanel m_panel;
    LEFilledGraph m_graph;
    LEGraphData m_timeD;
    LEGraphData m_bandwidthD;
    LEGraphData m_inPktsD;
    LEGraphData m_outPktsD;
    LEGraphData m_inBytesD;
    LEGraphData m_outBytesD;
    Hashtable m_data = new Hashtable();
    Thread m_thread;
    int m_time;
    String m_log;
    PrintWriter m_prw;

    public LEEtherGraph(LEPortMaster lEPortMaster, String string, int n) {
        super(String.valueOf(lEPortMaster.getDescription()) + " Ethernet Usage");
        this.m_pm = lEPortMaster;
        this.m_log = string;
        this.addWindowListener(this);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.m_graph = new LEFilledGraph();
        this.m_graph.setYLabel("Bandwidth (Mbps)");
        this.m_timeD = new LEGraphData("Time", Color.black);
        this.m_inPktsD = new LEGraphData("In Packets", Color.black);
        this.m_outPktsD = new LEGraphData("Out Packets", Color.black);
        this.m_inBytesD = new LEGraphData("In Bytes", Color.black);
        this.m_outBytesD = new LEGraphData("Out Bytes", Color.black);
        this.m_bandwidthD = new LEGraphData("Bandwidth", Color.green);
        this.m_graph.addGraphData(this.m_bandwidthD);
        String[][] stringArray = new String[4][2];
        stringArray[0][0] = "Device";
        stringArray[0][1] = this.m_pm.getDescription();
        stringArray[1][0] = "Update Interval";
        stringArray[1][1] = String.valueOf(Integer.toString(n)) + " minutes";
        stringArray[2][0] = "Log";
        stringArray[2][1] = string;
        stringArray[3][0] = "Log Format";
        stringArray[3][1] = "YYYYMMDDHHMMSS,Ethernet,Bandwidth,In Bytes,Out Bytes,In Packets,Out Packets";
        this.m_time = n * 60000;
        if (s_simple == null) {
            s_simple = new SimpleDateFormat("yyyyMMddhhmmss", Locale.getDefault());
            s_simple.setTimeZone(TimeZone.getDefault());
            s_format = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
            s_format.setTimeZone(TimeZone.getDefault());
        }
        this.m_panel = new LEGraphPanel(this.m_graph, stringArray, "graph_ethers_");
        this.add("Center", this.m_panel);
        this.pack();
        ((Component)this).setVisible(true);
        String string2 = this.m_pm.getResourceID();
        LEMonitorFactory.GetFactory().addObserver(string2, this);
    }

    public void addNotify() {
        super.addNotify();
        try {
            if (this.m_log != null && this.m_log.length() > 0) {
                FileWriter fileWriter = new FileWriter(this.m_log);
                this.m_prw = new PrintWriter(fileWriter);
                this.m_prw.println("YYYYMMDDHHMMSS,Ethernet,Bandwidth,In Bytes,Out Bytes,In Packets,Out Packets");
            }
            this.startMonitoring();
            return;
        }
        catch (Exception exception) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), exception.getMessage());
            return;
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEMonEthersMessage) {
            this.updateEthernets((LEMonEthersMessage)object);
            if (this.m_thread == null) {
                String string2 = this.m_pm.getDescription();
                this.m_thread = new Thread((Runnable)this, String.valueOf(string2) + " Ethernet Usage Graph");
                this.m_thread.start();
            }
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        while (true) {
            try {
                while (true) {
                    this.updateGraphData();
                    Thread.currentThread();
                    Thread.sleep(this.m_time);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                continue;
            }
            break;
        }
    }

    public void goodbye() {
        String string = this.m_pm.getResourceID();
        LEStatusFactory.GetFactory().deleteObserver(string, this);
        LEMonitorFactory.GetFactory().deleteObserver(string, this);
        this.stopMonitoring();
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        this.m_prw = null;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.goodbye();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void updateEthernets(LEMonEthersMessage lEMonEthersMessage) {
        String string = lEMonEthersMessage.getBoard();
        if (!string.equals("") && !string.equals("10")) {
            return;
        }
        double[][] dArray = (double[][])this.m_data.get(string);
        if (dArray == null) {
            dArray = new double[2][6];
            dArray[0][0] = 0.0;
            dArray[0][1] = 0.0;
            dArray[0][2] = 0.0;
            dArray[0][3] = 0.0;
            dArray[0][4] = 0.0;
            dArray[0][5] = 0.0;
            this.m_data.put(string, dArray);
        }
        String string2 = lEMonEthersMessage.getName();
        int n = 0;
        String string3 = string2.substring(5);
        if (string3 != null) {
            n = Integer.parseInt(string3);
        }
        dArray[1][0] = n;
        dArray[1][1] = lEMonEthersMessage.getCurTime();
        dArray[1][2] = lEMonEthersMessage.getInPackets();
        dArray[1][3] = lEMonEthersMessage.getOutPackets();
        dArray[1][4] = lEMonEthersMessage.getInBytes();
        dArray[1][5] = lEMonEthersMessage.getOutBytes();
    }

    void updateGraphData() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        Date date = new Date();
        Enumeration enumeration = this.m_data.elements();
        while (enumeration.hasMoreElements()) {
            double[][] dArray = (double[][])enumeration.nextElement();
            if (dArray[0][1] > 0.0) {
                d2 = Math.abs(dArray[1][4] - dArray[0][4]);
                d3 = Math.abs(dArray[1][5] - dArray[1][5]);
                d = (dArray[1][1] - dArray[0][1]) / 1090.0;
                d4 = Math.abs(dArray[1][2] - dArray[0][2]);
                d5 = Math.abs(dArray[1][3] - dArray[0][3]);
                d6 = (d2 + d3) * 8.0;
                d7 = d6 / (d * 1048576.0);
                this.m_timeD.addData(d);
                this.m_inPktsD.addData(d4);
                this.m_outPktsD.addData(d5);
                this.m_inBytesD.addData(d2);
                this.m_outBytesD.addData(d3);
                this.m_bandwidthD.addData(d7);
                if (this.m_prw != null) {
                    this.m_prw.print(s_simple.format(date));
                    this.m_prw.print(",");
                    this.m_prw.print((long)dArray[1][0]);
                    this.m_prw.print(",");
                    this.m_prw.print(d7);
                    this.m_prw.print(",");
                    this.m_prw.print(d2);
                    this.m_prw.print(",");
                    this.m_prw.print(d3);
                    this.m_prw.print(",");
                    this.m_prw.print(d4);
                    this.m_prw.print(",");
                    this.m_prw.println(d5);
                }
            }
            dArray[0][1] = dArray[1][1];
            dArray[0][2] = dArray[1][2];
            dArray[0][3] = dArray[1][3];
            dArray[0][4] = dArray[1][4];
            dArray[0][5] = dArray[1][5];
        }
        this.m_graph.setMaxValue(100.0);
        this.m_graph.setXLabel(s_format.format(date));
        this.m_graph.redraw();
    }

    void startMonitoring() {
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (lEConnectionFacade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            lEPMConnectionFacade.startMonitor(720896, -1, LEPMConnectionFacade.NO_GROUP, this.m_time);
        }
    }

    void stopMonitoring() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
        this.m_data.clear();
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (lEConnectionFacade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            lEPMConnectionFacade.stopMonitor(720896, -1, LEPMConnectionFacade.NO_GROUP, this.m_time);
        }
    }
}

