/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEMonDHCPBindingMessage;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class LEMonDHCPBindingView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Button m_dynamic;
    Button m_static;

    public LEMonDHCPBindingView() {
        this.initialize(1, 2, 4);
        this.m_dynamic = new Button("Delete Dynamic");
        this.m_buttons.add((Component)this.m_dynamic, 0);
        this.m_static = new Button("Delete Static");
        this.m_buttons.add((Component)this.m_static, 1);
        this.m_buttons.remove(this.m_reset);
        this.m_buttons.remove(this.m_restore);
        this.m_dynamic.addActionListener(this);
        this.m_static.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_dynamic) {
            String string = "delete dhcp bindings dynamic";
            int n = this.getNumRows();
            int n2 = 0;
            while (n2 < this.m_pms.length) {
                LEPMCommand lEPMCommand;
                LEConnectionFacade lEConnectionFacade;
                LEPortMaster lEPortMaster = this.m_pms[n2];
                if (lEPortMaster != null && (lEConnectionFacade = lEPortMaster.getConnectionFacade()) instanceof LEPMConnectionFacade && !(lEPMCommand = lEConnectionFacade.execute(string)).getStatus()) {
                    LEVector lEVector = new LEVector();
                    lEVector.add(lEPMCommand);
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEConnectionFacade, lEVector);
                }
                ++n2;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                String string2 = this.getCellString(n4, 4);
                if (!string2.equals("Static")) {
                    this.deleteRow(n4 - n3);
                    ++n3;
                }
                ++n4;
            }
            return;
        }
        if (actionEvent.getSource() == this.m_static) {
            String string = "delete dhcp bindings static";
            int n = this.getNumRows();
            int n5 = 0;
            while (n5 < this.m_pms.length) {
                LEPMCommand lEPMCommand;
                LEConnectionFacade lEConnectionFacade;
                LEPortMaster lEPortMaster = this.m_pms[n5];
                if (lEPortMaster != null && (lEConnectionFacade = lEPortMaster.getConnectionFacade()) instanceof LEPMConnectionFacade && !(lEPMCommand = lEConnectionFacade.execute(string)).getStatus()) {
                    LEVector lEVector = new LEVector();
                    lEVector.add(lEPMCommand);
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEConnectionFacade, lEVector);
                }
                ++n5;
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                String string3 = this.getCellString(n7, 4);
                if (string3 != null && string3.equals("Static")) {
                    this.deleteRow(n7 - n6);
                    ++n6;
                }
                ++n7;
            }
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonDHCPBindingMessage) {
            LEMonDHCPBindingMessage lEMonDHCPBindingMessage = (LEMonDHCPBindingMessage)object;
            String string2 = lEMonDHCPBindingMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lEMonDHCPBindingMessage);
            } else {
                this.updateRow(n, lEMonDHCPBindingMessage);
            }
            this.repaint();
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("IP Address");
        objectArray[n2++] = new String("MAC Address");
        objectArray[n2++] = new String("Status");
        objectArray[n2++] = new String("Static");
        objectArray[n2++] = new String("Lease");
    }

    void createRow(String string, String string2, LEMonDHCPBindingMessage lEMonDHCPBindingMessage) {
        String[] stringArray = new String[this.getNumColumns()];
        int n = 0;
        stringArray[n++] = this.getPM(string).getDescription();
        stringArray[n++] = lEMonDHCPBindingMessage.getName();
        stringArray[n++] = lEMonDHCPBindingMessage.getMACAddress();
        stringArray[n++] = lEMonDHCPBindingMessage.getStatus();
        stringArray[n++] = lEMonDHCPBindingMessage.getBound();
        String string3 = lEMonDHCPBindingMessage.getLease();
        if (!string3.equals("Infinity")) {
            int n2 = Integer.parseInt(lEMonDHCPBindingMessage.getLease());
            string3 = LEUpTimeCompare.FormatTime(n2);
        }
        stringArray[n++] = string3;
        this.addRow(string, string2, stringArray);
    }

    void updateRow(int n, LEMonDHCPBindingMessage lEMonDHCPBindingMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellString(n, n2++, lEMonDHCPBindingMessage.getMACAddress());
        this.setCellString(n, n2++, lEMonDHCPBindingMessage.getStatus());
        this.setCellString(n, n2++, lEMonDHCPBindingMessage.getBound());
        String string = lEMonDHCPBindingMessage.getLease();
        if (!string.equals("Infinity")) {
            int n3 = Integer.parseInt(lEMonDHCPBindingMessage.getLease());
            string = LEUpTimeCompare.FormatTime(n3);
        }
        this.setCellString(n, n2++, string);
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonDHCPBindingView.s_monitors[0] = 3670048;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor DHCP Bindings";
    }
}

