/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPRange;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEIPRanges
extends LETable {
    String m_pool;

    public LEIPRanges(LEConnectionFacade lEConnectionFacade, String string) {
        super(lEConnectionFacade);
        this.m_pool = string;
    }

    public Object clone() {
        LEIPRanges lEIPRanges = new LEIPRanges(this.m_facade, this.m_pool);
        lEIPRanges.copy(this);
        return lEIPRanges;
    }

    public String getPool() {
        return this.m_pool;
    }

    public LEVector add(String string, String string2, String string3) {
        LEPMCommand lEPMCommand;
        LEVector lEVector = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("set ippool ");
        stringBuffer.append(this.m_pool);
        stringBuffer.append(" address-range ");
        stringBuffer.append(string);
        stringBuffer.append("/");
        stringBuffer.append(string2);
        if (!string3.equals("")) {
            stringBuffer.append(" ");
            stringBuffer.append(string3);
        }
        if ((lEPMCommand = this.m_facade.execute(stringBuffer.toString())).getStatus()) {
            lEPMCommand = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!lEPMCommand.getStatus()) {
            lEVector = new LEVector();
            lEVector.addElement(lEPMCommand);
        }
        return lEVector;
    }

    public LEVector delete(String string) {
        LEVector lEVector = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete ippool ");
        stringBuffer.append(this.m_pool);
        stringBuffer.append(" address-range ");
        stringBuffer.append(string);
        LEPMCommand lEPMCommand = this.m_facade.execute(stringBuffer.toString());
        if (lEPMCommand.getStatus()) {
            this.remove(string);
            lEPMCommand = this.m_facade.execute("save all");
            if (!lEPMCommand.getStatus()) {
                this.refresh();
            }
        }
        if (!lEPMCommand.getStatus()) {
            lEVector = new LEVector();
            lEVector.addElement(lEPMCommand);
        }
        return lEVector;
    }

    public void clear() {
        this.m_fields.clear();
        this.setChanged();
        this.notifyObservers();
    }

    boolean getChangedCommands(LEVector lEVector) {
        int n = lEVector.size();
        boolean bl = super.getChangedCommands(lEVector);
        if (bl) {
            this.removeResets(lEVector, n);
        }
        return bl;
    }

    boolean getAllCommands(LEVector lEVector) {
        int n = lEVector.size();
        boolean bl = super.getAllCommands(lEVector);
        if (bl) {
            this.removeResets(lEVector, n);
        }
        return bl;
    }

    void removeResets(LEVector lEVector, int n) {
        int n2 = lEVector.size();
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            String string = (String)lEVector.elementAt(n4);
            if (string.equals("reset ippool")) {
                if (n3 > 0) {
                    lEVector.removeElementAt(n3);
                    --n2;
                }
                n3 = --n4;
            }
            ++n4;
        }
    }

    LEConfig createConfig(String string) {
        return new LEIPRange(this.m_facade, this.m_pool, string);
    }
}

