/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEAsyncPorts;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEISDNPorts;
import com.lucent.ra.nms.model.LEParallelPorts;
import com.lucent.ra.nms.model.LEPort;
import com.lucent.ra.nms.model.LESyncPorts;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEPorts
extends LEConfig {
    public static final String ASYNC_PORTS = "AsyncPort";
    public static final String SYNC_PORTS = "SyncPort";
    public static final String ISDN_PORTS = "ISDNPort";
    public static final String PARALLEL_PORTS = "ParallelPort";
    public static final int KEY_COUNT = 4;
    public static final String PPP = "ppp";
    public static final String FRAME_RELAY = "frame";
    public static final String SLIP = "slip";
    public static final String VJ = "vj";
    public static final String STAC = "stac";
    public static final String SECONDS = "seconds";
    public static final String MINUTES = "minutes";
    static final String SET_LOGIN = "set all login network twoway";
    static final String SET_SER_DEV = "set all service_device PortMaster";
    static final String SET_DIR = "set all directory ";
    static final String SET_GROUP = "set all group 0";
    static final String SET_HANGUP = "set all hangup on";
    static final String SET_HOST_1 = "set all host 1 0.0.0.0";
    static final String SET_HOST_2 = "set all host 2 0.0.0.0";
    static final String SET_HOST_3 = "set all host 3 0.0.0.0";
    static final String SET_HOST_4 = "set all host 4 0.0.0.0";
    static final String SET_IDLE = "set all idletime 0 minutes";
    static final String SET_IFILTER = "set all ifilter ";
    static final String SET_SER_LOG = "set all service_login PortMaster";
    static final String SET_MESSAGE = "set all message ";
    static final String SET_MTU = "set all mtu 1500";
    static final String SET_OFILTER = "set all ofilter ";
    static final String SET_PROMPT = "set all prompt $hostname login:";
    static final String SET_SECUR = "set all security on";
    static final String SET_SPEED_1 = "set all speed 9600";
    static final String SET_SPEED_2 = "set all speed 2 9600";
    static final String SET_SPEED_3 = "set all speed 3 9600";
    static final String SET_SPID = "set all spid ";
    static final String SET_TERM = "set all termtyp ";
    static final String SET_USER = "set all username ";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            LEPorts.s_keys[0] = ASYNC_PORTS;
            LEPorts.s_keys[1] = SYNC_PORTS;
            LEPorts.s_keys[2] = ISDN_PORTS;
            LEPorts.s_keys[3] = PARALLEL_PORTS;
        }
        return s_keys;
    }

    public LEPorts(LEConnectionFacade lEConnectionFacade, String string, String string2) {
        super(lEConnectionFacade, string, string2);
    }

    public LEPorts(LEConnectionFacade lEConnectionFacade) {
        super(lEConnectionFacade);
    }

    public LEPort getPort(String string) {
        LETable lETable;
        if (!this.m_fetched) {
            this.fetch();
        }
        LEPort lEPort = null;
        LEAsyncPorts lEAsyncPorts = (LEAsyncPorts)this.get(ASYNC_PORTS);
        if (lEAsyncPorts != null) {
            lEPort = (LEPort)lEAsyncPorts.get(string);
        }
        if (lEPort == null && (lETable = (LESyncPorts)this.get(SYNC_PORTS)) != null) {
            lEPort = (LEPort)lETable.get(string);
        }
        if (lEPort == null && (lETable = (LEISDNPorts)this.get(ISDN_PORTS)) != null) {
            lEPort = (LEPort)lETable.get(string);
        }
        if (lEPort == null && (lETable = (LEParallelPorts)this.get(PARALLEL_PORTS)) != null) {
            lEPort = (LEPort)lETable.get(string);
        }
        return lEPort;
    }

    public Object clone() {
        LEPorts lEPorts = new LEPorts(this.m_facade, this.m_board, this.m_fetchKey);
        lEPorts.copy(this);
        return lEPorts;
    }

    boolean getAllCommands(LEVector lEVector) {
        boolean bl = false;
        if (this.m_board != null && !LEBoard.IsManager(this.m_board)) {
            bl = true;
            this.addCommandDefaults(lEVector);
        }
        return bl |= super.getAllCommands(lEVector);
    }

    LEConfig createConfig(String string) {
        LEConfig lEConfig = string.equals(ASYNC_PORTS) ? new LEAsyncPorts(this.m_facade, this.m_board) : (string.equals(SYNC_PORTS) ? new LESyncPorts(this.m_facade, this.m_board) : (string.equals(ISDN_PORTS) ? new LEISDNPorts(this.m_facade, this.m_board) : (string.equals(PARALLEL_PORTS) ? new LEParallelPorts(this.m_facade, this.m_board) : new LEConfig(this.m_facade))));
        return lEConfig;
    }

    void addCommandDefaults(LEVector lEVector) {
        lEVector.addElement(SET_LOGIN);
        lEVector.addElement(SET_SER_DEV);
        lEVector.addElement(SET_DIR);
        lEVector.addElement(SET_GROUP);
        lEVector.addElement(SET_HANGUP);
        lEVector.addElement(SET_HOST_1);
        lEVector.addElement(SET_HOST_2);
        lEVector.addElement(SET_HOST_3);
        lEVector.addElement(SET_HOST_4);
        lEVector.addElement(SET_IDLE);
        lEVector.addElement(SET_IFILTER);
        lEVector.addElement(SET_SER_LOG);
        lEVector.addElement(SET_MESSAGE);
        lEVector.addElement(SET_MTU);
        lEVector.addElement(SET_OFILTER);
        lEVector.addElement(SET_PROMPT);
        lEVector.addElement(SET_SECUR);
        lEVector.addElement(SET_SPEED_1);
        lEVector.addElement(SET_SPEED_2);
        lEVector.addElement(SET_SPEED_3);
        lEVector.addElement(SET_SPID);
        lEVector.addElement(SET_TERM);
        lEVector.addElement(SET_USER);
    }
}

