/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEScrollable;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class LEDBCanvas
extends Canvas
implements LEScrollable {
    protected LEScrollPanel m_panel;
    protected Image m_buf;
    protected boolean m_recalc = true;
    protected boolean m_redraw = true;
    protected int m_fullWidth;
    protected int m_fullHeight;
    protected int m_x;
    protected int m_y;

    public void calculateLayout(Graphics graphics) {
    }

    public void draw(Graphics graphics) {
    }

    public void recalculate() {
        this.m_recalc = true;
    }

    public void redraw() {
        this.m_redraw = true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.m_recalc = true;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.m_recalc = true;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.m_recalc = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.m_recalc) {
            if (this.m_buf != null) {
                this.m_buf.flush();
                this.m_buf = null;
            }
            this.calculateLayout(graphics);
            if (this.m_panel != null) {
                this.m_panel.updateScrollbars(this.m_fullWidth, this.m_fullHeight);
            }
            object = this.getSize();
            int n = Math.max(this.m_fullWidth, ((Dimension)object).width);
            int n2 = Math.max(this.m_fullHeight, ((Dimension)object).height);
            if (n > 0 && n2 > 0) {
                this.m_buf = this.createImage(n, n2);
                this.m_redraw = true;
            }
            this.m_recalc = false;
        }
        if (this.m_redraw && this.m_buf != null) {
            object = this.m_buf.getGraphics();
            this.draw((Graphics)object);
            ((Graphics)object).dispose();
            this.m_redraw = false;
        }
        if (this.m_buf != null) {
            graphics.drawImage(this.m_buf, this.m_x, this.m_y, null);
        }
    }

    public void setScrollPanel(LEScrollPanel lEScrollPanel) {
        this.m_panel = lEScrollPanel;
    }

    public void setOrigin(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void scrollTo(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        this.repaint();
    }

    public void startScroll() {
    }

    public void endScroll() {
    }

    public Dimension totalArea() {
        if (this.m_buf == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.m_fullWidth, this.m_fullHeight);
    }
}

