/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEThreadStatus;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;

public class LEProgressBar
extends Canvas
implements Runnable,
LEObserver {
    int m_height = 18;
    int m_width = 100;
    int m_border = 2;
    int m_percent;
    boolean m_threeD = true;
    Thread m_thread;

    public LEProgressBar(LEObservable lEObservable) {
        this.m_thread = new Thread((Runnable)this, "ProgressBar");
        this.m_thread.start();
        if (lEObservable != null) {
            lEObservable.addObserver(this);
        }
    }

    public LEProgressBar(int n, LEObservable lEObservable) {
        this.m_percent = n;
        this.m_thread = new Thread(this);
        this.m_thread.start();
        if (lEObservable != null) {
            lEObservable.addObserver(this);
        }
    }

    public void updatePercent(int n) {
        if (this.m_percent != n && n >= 0 && n <= 100) {
            this.m_percent = n;
            this.m_thread.resume();
        }
    }

    public void setBorder(int n) {
        this.m_border = n;
    }

    public void setHeight(int n) {
        this.m_height = n;
    }

    public void setWidth(int n) {
        this.m_width = n;
    }

    public synchronized Dimension getMinimumSize() {
        int n = this.m_height + this.m_border * 2;
        int n2 = this.m_width + this.m_border * 2;
        return new Dimension(n2, n);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void stop() {
        this.m_thread.stop();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = (int)((float)dimension.width * (float)((double)this.m_percent / 100.0));
        graphics.setColor(LEColor.getForeground());
        if (this.m_percent > 0) {
            if (this.m_threeD) {
                graphics.fill3DRect(this.m_border, this.m_border, n, this.m_height, false);
                graphics.setColor(LEColor.getBackground());
                graphics.fillRect(n, this.m_border, dimension.width, this.m_height);
                return;
            }
            graphics.fillRect(this.m_border, this.m_border, n, this.m_height);
            graphics.setColor(LEColor.getBackground());
            graphics.fillRect(n, this.m_border, dimension.width, this.m_height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.m_thread.suspend();
                    this.repaint();
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                continue;
            }
            break;
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        LEThreadStatus lEThreadStatus = (LEThreadStatus)object;
        int n = lEThreadStatus.getPercent();
        if (n == 101) {
            this.updatePercent(100);
            return;
        }
        this.updatePercent(n);
    }
}

