/*
 * Decompiled with CFR 0.152.
 */
package com.acme.crypto;

import com.acme.crypto.CryptoUtils;

public abstract class Hash
extends CryptoUtils {
    protected int hashSize;
    protected byte[] hashBytes;

    public Hash(int n) {
        this.hashSize = n;
        this.hashBytes = new byte[n];
    }

    public int hashSize() {
        return this.hashSize;
    }

    public abstract void reset();

    public abstract void add(byte var1);

    public void add(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.add(byArray[n3]);
            ++n3;
        }
    }

    protected void prepare() {
    }

    public byte[] get() {
        this.prepare();
        byte[] byArray = new byte[this.hashSize];
        System.arraycopy(this.hashBytes, 0, byArray, 0, this.hashSize);
        return byArray;
    }

    public void add(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            this.add(cArray[n2]);
            ++n2;
        }
    }

    public void addASCII(String string) {
        int n = string.length();
        byte[] byArray = string.getBytes();
        this.add(byArray, 0, n);
    }

    public void add(byte[] byArray) {
        this.add(byArray, 0, byArray.length);
    }

    public void add(boolean bl) {
        if (bl) {
            this.add((byte)1);
            return;
        }
        this.add((byte)0);
    }

    public void add(char c) {
        this.add((byte)(c >>> 8));
        this.add((byte)c);
    }

    public void add(short s) {
        this.add((byte)(s >>> 8));
        this.add((byte)s);
    }

    public void add(int n) {
        this.add((byte)(n >>> 24));
        this.add((byte)(n >>> 16));
        this.add((byte)(n >>> 8));
        this.add((byte)n);
    }

    public void add(long l) {
        this.add((byte)(l >>> 56));
        this.add((byte)(l >>> 48));
        this.add((byte)(l >>> 40));
        this.add((byte)(l >>> 32));
        this.add((byte)(l >>> 24));
        this.add((byte)(l >>> 16));
        this.add((byte)(l >>> 8));
        this.add((byte)l);
    }

    public void add(float f) {
        this.add(Float.floatToIntBits(f));
    }

    public void add(double d) {
        this.add(Double.doubleToLongBits(d));
    }

    public void add(Object object) {
        this.add(object.toString());
    }

    public static byte[] hashStr(String string, Hash hash) {
        hash.add(string);
        return hash.get();
    }

    public boolean equals(Hash hash) {
        if (hash.hashSize != this.hashSize) {
            return false;
        }
        hash.prepare();
        this.prepare();
        int n = 0;
        while (n < this.hashSize) {
            if (hash.hashBytes[n] != this.hashBytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        this.prepare();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.hashSize) {
            n ^= this.hashBytes[n3] << n2;
            n2 = (n2 + 8) % 32;
            ++n3;
        }
        return n;
    }

    public String toString() {
        this.prepare();
        return CryptoUtils.toStringBlock(this.hashBytes, 0, this.hashSize);
    }
}

