/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.forms.LEMalformedAddressSpecException;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEIPPanel;
import com.lucent.ra.nms.ui.LENetmaskPanel;
import com.lucent.ra.nms.ui.LETextArea;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class LEAddressSpecFormLine
extends Panel
implements LEFormLine,
ActionListener {
    private static final String EDIT_EVENT = "-edit-";
    private static final String OK_EVENT = "-ok-";
    private static final String CANCEL_EVENT = "-cancel-";
    private static final String ADD_ADDRESS_EVENT = "-add-address-";
    private static final String ADD_RANGE_EVENT = "-add-range-";
    private static final String ADD_SUBNET_EVENT = "-add-subnet-";
    private static final String ADD_PORT_EVENT = "-add-port-";
    private static final String DELETE_EVENT = "-delete-";
    private static final String STR_OK = "OK";
    private static final String STR_CANCEL = "Cancel";
    public static final char ECHO_CHAR = '*';
    LEFormLineListener m_listener;
    String m_valid;
    char m_echoChar;
    boolean allowAddress = true;
    boolean allowSubnet = true;
    boolean allowPort = true;
    boolean allowRange = true;
    Specification m_portSpec;
    LETextArea m_stringForm;
    Button m_editButton;
    static String NUMBER = "-number-";

    public void setAllowAddress(boolean bl) {
        this.allowAddress = bl;
    }

    public void setAllowSubnet(boolean bl) {
        this.allowSubnet = bl;
    }

    public void setAllowPort(boolean bl) {
        this.allowPort = bl;
    }

    public void setAllowRange(boolean bl) {
        this.allowRange = bl;
    }

    public LEAddressSpecFormLine() {
        this.setLayout(new FlowLayout(0, 0, 10));
        this.m_echoChar = '\u0000';
        this.m_stringForm = new LETextArea(3, 40);
        this.m_stringForm.setEditable(false);
        this.m_editButton = new Button("Edit...");
        this.m_editButton.setActionCommand(EDIT_EVENT);
        this.m_editButton.addActionListener(this);
        this.m_portSpec = null;
        this.add(this.m_stringForm);
        this.add(this.m_editButton);
    }

    private boolean doAllowReset(boolean bl) {
        if (!bl) {
            this.setAllowAddress(false);
            this.setAllowSubnet(false);
            this.setAllowRange(false);
            this.setAllowPort(false);
        }
        return true;
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        if (lEDataSpec != null) {
            boolean bl = false;
            if (lEDataSpec.getAttribute(LEAttributes.ADDRESS) != null) {
                bl = this.doAllowReset(bl);
                this.setAllowAddress(true);
            }
            if (lEDataSpec.getAttribute(LEAttributes.SUBNET) != null) {
                bl = this.doAllowReset(bl);
                this.setAllowSubnet(true);
            }
            if (lEDataSpec.getAttribute(LEAttributes.PORT) != null) {
                bl = this.doAllowReset(bl);
                this.setAllowPort(true);
            }
            if (lEDataSpec.getAttribute(LEAttributes.RANGE) != null) {
                bl = this.doAllowReset(bl);
                this.setAllowRange(true);
            }
        }
    }

    public void setEchoChar(char c) {
        this.m_echoChar = c;
    }

    public void setValue(Object object) {
        this.m_stringForm.setText((String)object);
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    void invokeChangedEvent() {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }

    public String getValue() {
        return this.m_stringForm.getText();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Address specifications in the form of ");
            if (this.allowAddress) {
                stringBuffer.append("1.2.3.4");
                ++n;
            }
            if (this.allowRange) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("1.2.3.4-1.2.3.9");
                ++n;
            }
            if (this.allowSubnet) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("1.2.3.15/20");
                ++n;
            }
            if (this.allowPort) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("1.2.3.4:port");
                ++n;
            }
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            return string2.equals(string);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(EDIT_EVENT)) {
            Container container = this.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            if (container != null) {
                SpecEditor specEditor = new SpecEditor((Frame)container, "Edit Address Specification");
                try {
                    specEditor.setAddressSpecification(this.getValue());
                }
                catch (LEMalformedAddressSpecException lEMalformedAddressSpecException) {
                    LEErrorDialog lEErrorDialog = new LEErrorDialog((Frame)container, lEMalformedAddressSpecException.getMessage());
                    lEErrorDialog.show();
                    lEErrorDialog = null;
                }
                LEUiUtils.CenterDialog(specEditor);
                specEditor.show();
                this.setValue(specEditor.toString());
                this.invokeChangedEvent();
                if (this.m_listener != null) {
                    LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
                    this.m_listener.formLineValueChanged(lEFormLineEvent);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class Specification {
        final int SPEC_SINGLE = 1;
        final int SPEC_RANGE = 2;
        final int SPEC_SUBNET = 3;
        final int SPEC_PORT = 4;
        private final String TELNET = "telnet";
        private final String FTP = "ftp";
        private final String HTTP = "http";
        int m_typeOfSpec;
        String m_address;
        String m_portId;
        String m_address2;
        String m_netmask;
        int m_lastIndex;

        Specification(String string, int n) throws LEMalformedAddressSpecException {
            LEAddressSpecFormLine.this = LEAddressSpecFormLine.this;
            int n2 = string.length();
            int n3 = n;
            if (n3 < n2) {
                char c = string.charAt(n3);
                while ((c <= ' ' || c == ',') && n3 < n2) {
                    c = string.charAt(n3++);
                }
                if (n3 > 0) {
                    --n3;
                }
                if (n3 < n2) {
                    this.m_address = this.slurpQuad(string, n3);
                    n3 = this.m_lastIndex;
                    if (n3 < n2) {
                        c = string.charAt(n3);
                        if (c == ',' || n3 + 1 >= n2) {
                            this.m_typeOfSpec = 1;
                            return;
                        }
                        if (c == ':') {
                            this.m_typeOfSpec = 4;
                            this.m_portId = this.slurpPort(string, ++n3);
                            return;
                        }
                        if (c == '/') {
                            this.m_typeOfSpec = 3;
                            c = string.charAt(++n3);
                            StringBuffer stringBuffer = new StringBuffer();
                            while (n3 < n2 && c >= '0' && c <= '9') {
                                stringBuffer.append(c);
                                if (++n3 >= n2) break;
                                c = string.charAt(n3);
                            }
                            this.m_netmask = stringBuffer.toString();
                            this.m_lastIndex = n3;
                            return;
                        }
                        if (c == '-') {
                            this.m_typeOfSpec = 2;
                            this.m_address2 = this.slurpQuad(string, ++n3);
                            n3 = this.m_lastIndex;
                            return;
                        }
                    }
                }
            }
            if (this.m_address.length() <= 0) {
                throw new LEMalformedAddressSpecException("Unrecognized specification form : " + string.substring(n3));
            }
            this.m_typeOfSpec = 1;
            this.m_lastIndex = n3;
        }

        private String slurpQuad(String string, int n) throws LEMalformedAddressSpecException {
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = n;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if ((c < '0' || c > '9') && c != '.') {
                    this.m_lastIndex = n3;
                    return stringBuffer.toString();
                }
                stringBuffer.append(c);
                ++n3;
            }
            this.m_lastIndex = n3;
            return stringBuffer.toString();
        }

        private void match(String string, int n, String string2) throws LEMalformedAddressSpecException {
            int n2 = string.length();
            string2.length();
            char c = string.charAt(n);
            int n3 = n;
            int n4 = n;
            while (c >= 'a' && c <= 'z' && n4 < n2) {
                if (++n4 >= n2) continue;
                c = string.charAt(n4);
            }
            String string3 = string.substring(n3, n4);
            if (!string3.equals(string2)) {
                throw new LEMalformedAddressSpecException("Illegal PREDEFINED port specifier : " + string3);
            }
            this.m_lastIndex = n4;
        }

        private String slurpPort(String string, int n) throws LEMalformedAddressSpecException {
            int n2 = string.length();
            int n3 = n;
            char c = string.charAt(n3);
            if (c >= '0' && c <= '9') {
                StringBuffer stringBuffer = new StringBuffer();
                while (n3 < n2 && c >= '0' && c <= '9') {
                    c = string.charAt(n3++);
                    stringBuffer.append(c);
                }
                this.m_lastIndex = n3;
                return stringBuffer.toString();
            }
            if (c == 't' || c == 'T') {
                this.match(string, n, "telnet");
                return "telnet";
            }
            if (c == 'f' || c == 'F') {
                this.match(string, n, "ftp");
                return "ftp";
            }
            if (c == 'h' || c == 'H') {
                this.match(string, n, "http");
                return "http";
            }
            throw new LEMalformedAddressSpecException("Illegal port specifier");
        }

        public String toString() {
            switch (this.m_typeOfSpec) {
                case 1: {
                    return this.m_address;
                }
                case 2: {
                    return String.valueOf(this.m_address) + "-" + this.m_address2;
                }
                case 3: {
                    return String.valueOf(this.m_address) + "/" + this.m_netmask;
                }
                case 4: {
                    return String.valueOf(this.m_address) + ":" + this.m_portId;
                }
            }
            return null;
        }
    }

    class AddAddress
    extends Dialog
    implements ActionListener {
        Button m_ok;
        Button m_cancel;
        LEIPPanel m_ipPanel;
        boolean m_wasCanceled;
        Specification m_specification;

        AddAddress(Frame frame, String string) {
            super(frame, string, true);
            LEAddressSpecFormLine.this = LEAddressSpecFormLine.this;
            this.setLayout(new BorderLayout());
            this.m_wasCanceled = false;
            this.m_specification = null;
            this.m_ok = new Button(STR_OK);
            this.m_ok.setActionCommand(OK_EVENT);
            this.m_ok.addActionListener(this);
            this.m_cancel = new Button(STR_CANCEL);
            this.m_cancel.setActionCommand(CANCEL_EVENT);
            this.m_cancel.addActionListener(this);
            Component[][] componentArray = new Component[2][1];
            Panel panel = new Panel(new FlowLayout(1));
            panel.add(this.m_ok);
            panel.add(this.m_cancel);
            componentArray[0][0] = new Label("New address:");
            this.m_ipPanel = new LEIPPanel();
            componentArray[1][0] = this.m_ipPanel;
            this.add((Component)new LECompGrid(componentArray, 5), "Center");
            this.add((Component)panel, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(OK_EVENT)) {
                this.dispose();
                String string2 = this.m_ipPanel.getAddress();
                try {
                    this.m_specification = new Specification(string2, 0);
                    return;
                }
                catch (LEMalformedAddressSpecException lEMalformedAddressSpecException) {
                    this.m_wasCanceled = true;
                    return;
                }
            }
            if (string.equals(CANCEL_EVENT)) {
                this.m_wasCanceled = true;
                this.dispose();
            }
        }

        boolean wasCanceled() {
            return this.m_wasCanceled;
        }

        Specification getSpecification() {
            return this.m_specification;
        }
    }

    class AddRange
    extends Dialog
    implements ActionListener {
        Button m_ok;
        Button m_cancel;
        LEIPPanel m_ipPanel;
        LEIPPanel m_ipPanel2;
        boolean m_wasCanceled;
        Specification m_specification;

        AddRange(Frame frame, String string) {
            super(frame, string, true);
            LEAddressSpecFormLine.this = LEAddressSpecFormLine.this;
            this.setLayout(new BorderLayout());
            this.m_wasCanceled = false;
            this.m_specification = null;
            this.m_ok = new Button(STR_OK);
            this.m_ok.setActionCommand(OK_EVENT);
            this.m_ok.addActionListener(this);
            this.m_cancel = new Button(STR_CANCEL);
            this.m_cancel.setActionCommand(CANCEL_EVENT);
            this.m_cancel.addActionListener(this);
            Component[][] componentArray = new Component[4][1];
            Panel panel = new Panel(new FlowLayout(1));
            panel.add(this.m_ok);
            panel.add(this.m_cancel);
            componentArray[0][0] = new Label("New address range:");
            this.m_ipPanel = new LEIPPanel();
            componentArray[1][0] = this.m_ipPanel;
            componentArray[2][0] = new Label("  to  ");
            this.m_ipPanel2 = new LEIPPanel();
            componentArray[3][0] = this.m_ipPanel2;
            this.add((Component)new LECompGrid(componentArray, 5), "Center");
            this.add((Component)panel, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(OK_EVENT)) {
                this.dispose();
                String string2 = String.valueOf(this.m_ipPanel.getAddress()) + "-" + this.m_ipPanel2.getAddress();
                try {
                    this.m_specification = new Specification(string2, 0);
                    return;
                }
                catch (LEMalformedAddressSpecException lEMalformedAddressSpecException) {
                    this.m_wasCanceled = true;
                    return;
                }
            }
            if (string.equals(CANCEL_EVENT)) {
                this.m_wasCanceled = true;
                this.dispose();
            }
        }

        boolean wasCanceled() {
            return this.m_wasCanceled;
        }

        Specification getSpecification() {
            return this.m_specification;
        }
    }

    class AddPort
    extends Dialog
    implements ActionListener,
    ItemListener {
        Button m_ok = new Button(LEAddressSpecFormLine.access$0());
        Button m_cancel;
        LEIPPanel m_ipPanel;
        Choice m_port;
        LETextField m_portNumber;
        boolean m_wasCanceled = false;
        Specification m_specification = null;

        AddPort(Frame frame, String string) {
            super(frame, string, true);
            LEAddressSpecFormLine.this = LEAddressSpecFormLine.this;
            this.m_ok.setActionCommand(OK_EVENT);
            this.m_ok.addActionListener(this);
            this.m_cancel = new Button(STR_CANCEL);
            this.m_cancel.setActionCommand(CANCEL_EVENT);
            this.m_cancel.addActionListener(this);
            Component[][] componentArray = new Component[3][1];
            Panel panel = new Panel(new FlowLayout(1));
            panel.add(this.m_ok);
            panel.add(this.m_cancel);
            Panel panel2 = new Panel();
            Component[][] componentArray2 = new Component[1][3];
            componentArray2[0][0] = new Label("Port: ");
            this.m_port = new Choice();
            componentArray2[0][1] = this.m_port;
            this.m_portNumber = new LETextField(4);
            componentArray2[0][2] = this.m_portNumber;
            this.m_port.addItem("ftp");
            this.m_port.addItem("http");
            this.m_port.addItem("telnet");
            this.m_port.addItem(NUMBER);
            this.m_port.addItemListener(this);
            this.m_portNumber.setEnabled(false);
            this.m_portNumber.setText("23");
            componentArray[0][0] = new Label("New port address :");
            this.m_ipPanel = new LEIPPanel();
            componentArray[1][0] = this.m_ipPanel;
            componentArray[2][0] = panel2;
            panel2.add(new LECompGrid(componentArray2, 0));
            this.add((Component)new LECompGrid(componentArray, 5), "Center");
            this.add((Component)panel, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(OK_EVENT)) {
                this.dispose();
                String string2 = this.m_port.getSelectedItem();
                String string3 = string2.equals(NUMBER) ? String.valueOf(this.m_ipPanel.getAddress()) + ":" + this.m_portNumber.getText() : String.valueOf(this.m_ipPanel.getAddress()) + ":" + this.m_port.getSelectedItem();
                try {
                    this.m_specification = new Specification(string3, 0);
                    return;
                }
                catch (LEMalformedAddressSpecException lEMalformedAddressSpecException) {
                    this.m_wasCanceled = true;
                    return;
                }
            }
            if (string.equals(CANCEL_EVENT)) {
                this.m_wasCanceled = true;
                this.dispose();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            String string = (String)itemEvent.getItem();
            this.m_portNumber.setEnabled(string.equals(NUMBER));
        }

        boolean wasCanceled() {
            return this.m_wasCanceled;
        }

        Specification getSpecification() {
            return this.m_specification;
        }
    }

    class AddSubnet
    extends Dialog
    implements ActionListener {
        Button m_ok;
        Button m_cancel;
        LEIPPanel m_ipPanel;
        LENetmaskPanel m_netmask;
        boolean m_wasCanceled;
        Specification m_specification;

        AddSubnet(Frame frame, String string) {
            super(frame, string, true);
            LEAddressSpecFormLine.this = LEAddressSpecFormLine.this;
            this.setLayout(new BorderLayout());
            this.m_wasCanceled = false;
            this.m_specification = null;
            this.m_ok = new Button(STR_OK);
            this.m_ok.setActionCommand(OK_EVENT);
            this.m_ok.addActionListener(this);
            this.m_cancel = new Button(STR_CANCEL);
            this.m_cancel.setActionCommand(CANCEL_EVENT);
            this.m_cancel.addActionListener(this);
            Component[][] componentArray = new Component[3][1];
            Panel panel = new Panel(new FlowLayout(1));
            panel.add(this.m_ok);
            panel.add(this.m_cancel);
            Panel panel2 = new Panel();
            panel2.add(new Label("Subnet range : "));
            this.m_netmask = new LENetmaskPanel();
            panel2.add(this.m_netmask);
            this.m_netmask.setCIDRRange(8, 32);
            componentArray[0][0] = new Label("New subnet :");
            this.m_ipPanel = new LEIPPanel();
            componentArray[1][0] = this.m_ipPanel;
            componentArray[2][0] = panel2;
            this.add((Component)new LECompGrid(componentArray, 5), "Center");
            this.add((Component)panel, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(OK_EVENT)) {
                this.dispose();
                String string2 = String.valueOf(this.m_ipPanel.getAddress()) + "/" + this.m_netmask.getCIDR();
                try {
                    this.m_specification = new Specification(string2, 0);
                    return;
                }
                catch (LEMalformedAddressSpecException lEMalformedAddressSpecException) {
                    this.m_wasCanceled = true;
                    return;
                }
            }
            if (string.equals(CANCEL_EVENT)) {
                this.m_wasCanceled = true;
                this.dispose();
            }
        }

        boolean wasCanceled() {
            return this.m_wasCanceled;
        }

        Specification getSpecification() {
            return this.m_specification;
        }
    }

    class SpecEditor
    extends Dialog
    implements ActionListener {
        Button m_ok;
        Button m_cancel;
        List m_specList;
        LEVector m_specVector;
        boolean m_wasCanceled = false;
        String m_origSpec;

        SpecEditor(Frame frame, String string) {
            super(frame, string, true);
            LEAddressSpecFormLine.this = LEAddressSpecFormLine.this;
            Panel panel = new Panel();
            Button button = null;
            if (LEAddressSpecFormLine.this.allowAddress) {
                button = new Button("Add address");
                button.setActionCommand(ADD_ADDRESS_EVENT);
                button.addActionListener(this);
            }
            Button button2 = null;
            if (LEAddressSpecFormLine.this.allowRange) {
                button2 = new Button("Add range");
                button2.setActionCommand(ADD_RANGE_EVENT);
                button2.addActionListener(this);
            }
            Button button3 = null;
            if (LEAddressSpecFormLine.this.allowSubnet) {
                button3 = new Button("Add subnet");
                button3.setActionCommand(ADD_SUBNET_EVENT);
                button3.addActionListener(this);
            }
            Button button4 = null;
            if (LEAddressSpecFormLine.this.allowPort) {
                button4 = new Button("Add port");
                button4.setActionCommand(ADD_PORT_EVENT);
                button4.addActionListener(this);
            }
            Button button5 = new Button("Delete");
            button5.setActionCommand(DELETE_EVENT);
            button5.addActionListener(this);
            panel.setLayout(new GridLayout(5, 1, 1, 5));
            if (LEAddressSpecFormLine.this.allowAddress) {
                panel.add(button);
            }
            if (LEAddressSpecFormLine.this.allowRange) {
                panel.add(button2);
            }
            if (LEAddressSpecFormLine.this.allowSubnet) {
                panel.add(button3);
            }
            if (LEAddressSpecFormLine.this.allowPort) {
                panel.add(button4);
            }
            panel.add(button5);
            Panel panel2 = new Panel();
            this.m_specList = new List();
            GridBagLayout gridBagLayout = new GridBagLayout();
            panel2.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            panel2.add(this.m_specList);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.m_specList, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            panel2.add(panel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(panel, gridBagConstraints2);
            this.m_ok = new Button(STR_OK);
            this.m_ok.setActionCommand(OK_EVENT);
            this.m_ok.addActionListener(this);
            this.m_cancel = new Button(STR_CANCEL);
            this.m_cancel.setActionCommand(CANCEL_EVENT);
            this.m_cancel.addActionListener(this);
            Panel panel3 = new Panel(new FlowLayout(1));
            panel3.add(this.m_ok);
            panel3.add(this.m_cancel);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            this.setLayout(gridBagLayout2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.ipady = 5;
            gridBagConstraints3.fill = 1;
            this.add(panel2);
            gridBagLayout2.setConstraints(panel2, gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 15;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            this.add(panel3);
            gridBagLayout2.setConstraints(panel3, gridBagConstraints4);
            this.pack();
        }

        void setAddressSpecification(String string) throws LEMalformedAddressSpecException {
            Object object;
            int n = string.length();
            int n2 = 0;
            String string2 = string.toLowerCase();
            this.m_origSpec = string;
            this.m_specVector = new LEVector();
            while (n2 < n) {
                object = new Specification(string2, n2);
                n2 = ((Specification)object).m_lastIndex;
                this.m_specVector.add(object);
                if (((Specification)object).m_typeOfSpec != 4) continue;
                LEAddressSpecFormLine.this.m_portSpec = object;
            }
            if (this.m_specVector != null) {
                object = this.m_specVector.elements();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    this.m_specList.add(e.toString());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Container container = this.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            String string = actionEvent.getActionCommand();
            if (string.equals(OK_EVENT)) {
                this.dispose();
                return;
            }
            if (string.equals(CANCEL_EVENT)) {
                this.m_wasCanceled = true;
                this.dispose();
                return;
            }
            if (string.equals(ADD_ADDRESS_EVENT)) {
                AddAddress addAddress = new AddAddress((Frame)container, "Add");
                LEUiUtils.CenterDialog(addAddress);
                addAddress.show();
                if (!addAddress.wasCanceled()) {
                    this.m_specList.add(addAddress.getSpecification().toString());
                    this.m_specVector.add(addAddress.getSpecification());
                    return;
                }
            } else if (string.equals(ADD_SUBNET_EVENT)) {
                AddSubnet addSubnet = new AddSubnet((Frame)container, "Add");
                LEUiUtils.CenterDialog(addSubnet);
                addSubnet.show();
                if (!addSubnet.wasCanceled()) {
                    this.m_specList.add(addSubnet.getSpecification().toString());
                    this.m_specVector.add(addSubnet.getSpecification());
                    return;
                }
            } else if (string.equals(ADD_RANGE_EVENT)) {
                AddRange addRange = new AddRange((Frame)container, "Add");
                LEUiUtils.CenterDialog(addRange);
                addRange.show();
                if (!addRange.wasCanceled()) {
                    this.m_specList.add(addRange.getSpecification().toString());
                    this.m_specVector.add(addRange.getSpecification());
                    return;
                }
            } else if (string.equals(ADD_PORT_EVENT)) {
                AddPort addPort = new AddPort((Frame)container, "Add");
                LEUiUtils.CenterDialog(addPort);
                addPort.show();
                if (!addPort.wasCanceled()) {
                    Specification specification = addPort.getSpecification();
                    if (LEAddressSpecFormLine.this.m_portSpec != null) {
                        int n2 = this.m_specVector.indexOf(LEAddressSpecFormLine.this.m_portSpec);
                        this.m_specList.remove(n2);
                        this.m_specVector.removeElementAt(n2);
                    }
                    this.m_specList.add(specification.toString());
                    this.m_specVector.add(specification);
                    LEAddressSpecFormLine.this.m_portSpec = specification;
                    return;
                }
            } else if (string.equals(DELETE_EVENT) && (n = this.m_specList.getSelectedIndex()) >= 0) {
                this.m_specList.delItem(n);
                this.m_specVector.removeElementAt(n);
            }
        }

        public String toString() {
            if (this.m_wasCanceled) {
                return this.m_origSpec;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.m_specVector.elements();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                if (n > 1) {
                    stringBuffer.append(", ");
                }
                Specification specification = (Specification)enumeration.nextElement();
                stringBuffer.append(specification.toString());
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

