/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;

public class LEGlobal
extends LEConfig {
    public static final String ALT_SYSNAME = "221";
    public static final String ASSIGNED_ADDR = "164";
    public static final String ASSIGNED_POOL = "165";
    public static final String BGP = "197";
    public static final String BOARD_ID = "275";
    public static final String BRI_SWITCH = "144";
    public static final String CALL_CHECK = "185";
    public static final String CALL_CHECK_PASS = "callcheck-password";
    public static final String CHAP = "170";
    public static final String CHAP_NAME = "220";
    public static final String CHASSIS_TYPE = "280";
    public static final String DEF_BROADCAST = "154";
    public static final String DEF_LISTEN = "155";
    public static final String DOMAIN = "159";
    public static final String HARDWARE_VER = "146";
    public static final String HOST_1 = "173";
    public static final String HOST_2 = "174";
    public static final String HOST_3 = "175";
    public static final String HOST_4 = "176";
    public static final String IP_GATEWAY = "75";
    public static final String IP_METRIC = "151";
    public static final String IPX = "183";
    public static final String IPX_GATEWAY = "152";
    public static final String IPX_METRIC = "153";
    public static final String ISDN_MSN = "171";
    public static final String ISDN_NUM_AUTO = "179";
    public static final String LOCAL_IP = "177";
    public static final String LOGHOST = "162";
    public static final String MAC_ADDRESS = "195";
    public static final String MAX_PMC = "161";
    public static final String MCPPP_ENDPOINT = "57";
    public static final String MGR_TYPE = "530";
    public static final String NAME_SERVICE = "156";
    public static final String NAME_SERVER_ALT = "158";
    public static final String NAME_SERVER_PRI = "157";
    public static final String NETBIOS = "184";
    public static final String NETBIOS_NS_ALT = "168";
    public static final String NETBIOS_NS_PRI = "167";
    public static final String NUM_ETHERS = "150";
    public static final String NUM_LINES = "149";
    public static final String NUM_PORTS = "148";
    public static final String OSPF = "181";
    public static final String PAP = "169";
    public static final String PASSWORD = "password";
    public static final String PEER_ADDR = "529";
    public static final String PRI_SWITCH = "143";
    public static final String PROXY_ARP = "178";
    public static final String REPORTED_IP = "166";
    public static final String RIP_PASSWORD = "rip-password";
    public static final String SERIAL_ADMIN = "163";
    public static final String SHUTDOWN_TEMP = "281";
    public static final String SOFTWARE_VER = "145";
    public static final String SNMP = "182";
    public static final String SYSNAME = "87";
    public static final String TELNET_PORT = "160";
    public static final String UP_TIME = "36";
    public static final String USER_NETMASK = "180";
    public static final int KEY_COUNT = 57;
    public static final String SW_1TR6 = "1tr6";
    public static final String SW_ATT_4ESS = "att-4ess";
    public static final String SW_ATT_5ESS = "att-5ess";
    public static final String SW_ATT_5ESS_PTP = "att-5ess-ptp";
    public static final String SW_CCITT = "ccitt";
    public static final String SW_DMS_100 = "dms-100";
    public static final String SW_KDD = "kdd";
    public static final String SW_NET3 = "net3";
    public static final String SW_NET3_SWISS = "net3-swiss";
    public static final String SW_NET5 = "net5";
    public static final String SW_NET5_SWISS = "net5-swiss";
    public static final String SW_NI_1 = "ni-1";
    public static final String SW_NI_2 = "ni-2";
    public static final String SW_NTT = "ntt";
    public static final String SW_VN2 = "vn2";
    public static final String SW_VN3 = "vn3";
    public static final String SW_VN4 = "vn4";
    public static final String SW_VNP = "vnP";
    public static final int SWITCH_COUNT = 18;
    public static final String DNS = "dns";
    public static final String NIS = "nis";
    public static final String PM4_CHASSIS = "pm4";
    public static final String RAC_CHASSIS = "msm-rac";
    static String[] s_keys = null;
    static String[] s_switches = null;
    boolean m_reboot;
    boolean m_ripFetched = false;
    boolean m_callFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[57];
            int n = 0;
            LEGlobal.s_keys[n++] = ALT_SYSNAME;
            LEGlobal.s_keys[n++] = ASSIGNED_ADDR;
            LEGlobal.s_keys[n++] = ASSIGNED_POOL;
            LEGlobal.s_keys[n++] = BGP;
            LEGlobal.s_keys[n++] = BOARD_ID;
            LEGlobal.s_keys[n++] = BRI_SWITCH;
            LEGlobal.s_keys[n++] = CALL_CHECK;
            LEGlobal.s_keys[n++] = CALL_CHECK_PASS;
            LEGlobal.s_keys[n++] = CHAP;
            LEGlobal.s_keys[n++] = CHAP_NAME;
            LEGlobal.s_keys[n++] = CHASSIS_TYPE;
            LEGlobal.s_keys[n++] = DEF_BROADCAST;
            LEGlobal.s_keys[n++] = DEF_LISTEN;
            LEGlobal.s_keys[n++] = DOMAIN;
            LEGlobal.s_keys[n++] = HARDWARE_VER;
            LEGlobal.s_keys[n++] = HOST_1;
            LEGlobal.s_keys[n++] = HOST_2;
            LEGlobal.s_keys[n++] = HOST_3;
            LEGlobal.s_keys[n++] = HOST_4;
            LEGlobal.s_keys[n++] = IP_GATEWAY;
            LEGlobal.s_keys[n++] = IP_METRIC;
            LEGlobal.s_keys[n++] = IPX;
            LEGlobal.s_keys[n++] = IPX_GATEWAY;
            LEGlobal.s_keys[n++] = IPX_METRIC;
            LEGlobal.s_keys[n++] = ISDN_MSN;
            LEGlobal.s_keys[n++] = ISDN_NUM_AUTO;
            LEGlobal.s_keys[n++] = LOCAL_IP;
            LEGlobal.s_keys[n++] = LOGHOST;
            LEGlobal.s_keys[n++] = MAC_ADDRESS;
            LEGlobal.s_keys[n++] = MAX_PMC;
            LEGlobal.s_keys[n++] = MCPPP_ENDPOINT;
            LEGlobal.s_keys[n++] = MGR_TYPE;
            LEGlobal.s_keys[n++] = NAME_SERVICE;
            LEGlobal.s_keys[n++] = NAME_SERVER_ALT;
            LEGlobal.s_keys[n++] = NAME_SERVER_PRI;
            LEGlobal.s_keys[n++] = NETBIOS;
            LEGlobal.s_keys[n++] = NETBIOS_NS_ALT;
            LEGlobal.s_keys[n++] = NETBIOS_NS_PRI;
            LEGlobal.s_keys[n++] = NUM_ETHERS;
            LEGlobal.s_keys[n++] = NUM_LINES;
            LEGlobal.s_keys[n++] = NUM_PORTS;
            LEGlobal.s_keys[n++] = OSPF;
            LEGlobal.s_keys[n++] = PAP;
            LEGlobal.s_keys[n++] = PASSWORD;
            LEGlobal.s_keys[n++] = PEER_ADDR;
            LEGlobal.s_keys[n++] = PRI_SWITCH;
            LEGlobal.s_keys[n++] = PROXY_ARP;
            LEGlobal.s_keys[n++] = REPORTED_IP;
            LEGlobal.s_keys[n++] = RIP_PASSWORD;
            LEGlobal.s_keys[n++] = SERIAL_ADMIN;
            LEGlobal.s_keys[n++] = SHUTDOWN_TEMP;
            LEGlobal.s_keys[n++] = SOFTWARE_VER;
            LEGlobal.s_keys[n++] = SNMP;
            LEGlobal.s_keys[n++] = SYSNAME;
            LEGlobal.s_keys[n++] = TELNET_PORT;
            LEGlobal.s_keys[n++] = UP_TIME;
            LEGlobal.s_keys[n++] = USER_NETMASK;
        }
        return s_keys;
    }

    public static String[] GetSwitches() {
        if (s_switches == null) {
            s_switches = new String[18];
            LEGlobal.s_switches[0] = SW_1TR6;
            LEGlobal.s_switches[1] = SW_ATT_4ESS;
            LEGlobal.s_switches[2] = SW_ATT_5ESS;
            LEGlobal.s_switches[3] = SW_ATT_5ESS_PTP;
            LEGlobal.s_switches[4] = SW_CCITT;
            LEGlobal.s_switches[5] = SW_DMS_100;
            LEGlobal.s_switches[6] = SW_KDD;
            LEGlobal.s_switches[7] = SW_NET3;
            LEGlobal.s_switches[8] = SW_NET3_SWISS;
            LEGlobal.s_switches[9] = SW_NET5;
            LEGlobal.s_switches[10] = SW_NET5_SWISS;
            LEGlobal.s_switches[11] = SW_NI_1;
            LEGlobal.s_switches[12] = SW_NI_2;
            LEGlobal.s_switches[13] = SW_NTT;
            LEGlobal.s_switches[14] = SW_VN2;
            LEGlobal.s_switches[15] = SW_VN3;
            LEGlobal.s_switches[16] = SW_VN4;
            LEGlobal.s_switches[17] = SW_VNP;
        }
        return s_switches;
    }

    public LEGlobal(LEConnectionFacade lEConnectionFacade, String string) {
        super(lEConnectionFacade, string);
    }

    public LEGlobal(LEConnectionFacade lEConnectionFacade) {
        super(lEConnectionFacade);
    }

    public Object clone() {
        LEGlobal lEGlobal = new LEGlobal(this.m_facade, this.m_board);
        lEGlobal.copy(this);
        return lEGlobal;
    }

    public void set(String string, Object object) {
        String string2;
        if (string.equals(ASSIGNED_POOL) && (string2 = (String)this.get(ASSIGNED_POOL)) != null) {
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(object.toString());
                if (n2 < n) {
                    this.m_reboot = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        super.set(string, object);
    }

    public boolean requiresReboot(String string) {
        if (string.equals(ASSIGNED_POOL)) {
            return this.m_reboot;
        }
        return string.equals(BGP) || string.equals(OSPF) || string.equals(SNMP) || string.equals(MCPPP_ENDPOINT) || string.equals(BRI_SWITCH) || string.equals(PRI_SWITCH) || string.equals(ALT_SYSNAME);
    }

    void setRIPPassword(String string) {
        this.m_ripFetched = true;
        this.setField(RIP_PASSWORD, string);
    }

    void setCallCheckPassword(String string) {
        this.m_callFetched = true;
        this.setField(CALL_CHECK_PASS, string);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        String string;
        StringBuffer stringBuffer;
        String string2;
        int n = lEVector2.size();
        boolean bl = lEVector == null;
        boolean bl2 = false;
        if (bl || lEVector.contains(ALT_SYSNAME)) {
            this.makeSetCommand(lEVector2, null, ALT_SYSNAME, "altname");
        }
        if (bl || lEVector.contains(ASSIGNED_ADDR)) {
            this.makeSetCommand(lEVector2, null, ASSIGNED_ADDR, "assigned_address");
        }
        if ((bl || lEVector.contains(ASSIGNED_POOL)) && this.makeSetCommand(lEVector2, null, ASSIGNED_POOL, "pool") && !bl) {
            if (this.m_reboot) {
                bl2 = true;
            }
            this.m_reboot = false;
        }
        if ((bl || lEVector.contains(BGP)) && this.makeSetCommand(lEVector2, null, BGP, "bgp")) {
            bl2 = true;
        }
        if ((bl || lEVector.contains(BRI_SWITCH) || lEVector.contains(PRI_SWITCH)) && (this.makeSetCommand(lEVector2, null, BRI_SWITCH, "isdn-switch") || this.makeSetCommand(lEVector2, null, PRI_SWITCH, "isdn-switch"))) {
            bl2 = true;
        }
        if (bl || lEVector.contains(CALL_CHECK)) {
            this.makeSetCommand(lEVector2, null, CALL_CHECK, "call-check");
        }
        if (bl || lEVector.contains(CHAP)) {
            this.makeSetCommand(lEVector2, null, CHAP, "chap");
        }
        if (bl || lEVector.contains(CHAP_NAME)) {
            this.makeSetCommand(lEVector2, null, CHAP_NAME, "chapname");
        }
        if ((bl || lEVector.contains(CHASSIS_TYPE)) && (string2 = (String)this.get(CHASSIS_TYPE)) != null && string2.equals(RAC_CHASSIS)) {
            this.makeSetCommand(lEVector2, null, CHASSIS_TYPE, "chassis");
        }
        if (bl || lEVector.contains(DEF_BROADCAST) || lEVector.contains(DEF_LISTEN)) {
            this.makeRIPCommand(lEVector2, null, "default", (String)this.get(DEF_BROADCAST), (String)this.get(DEF_LISTEN));
        }
        if (bl || lEVector.contains(DOMAIN)) {
            this.makeSetCommand(lEVector2, null, DOMAIN, "domain");
        }
        if (bl || lEVector.contains(HOST_1)) {
            this.makeSetCommand(lEVector2, null, HOST_1, "host 1");
        }
        if (bl || lEVector.contains(HOST_2)) {
            this.makeSetCommand(lEVector2, null, HOST_2, "host 2");
        }
        if (bl || lEVector.contains(HOST_3)) {
            this.makeSetCommand(lEVector2, null, HOST_3, "host 3");
        }
        if (bl || lEVector.contains(HOST_4)) {
            this.makeSetCommand(lEVector2, null, HOST_4, "host 4");
        }
        if ((bl || lEVector.contains(IP_GATEWAY) || lEVector.contains(IP_METRIC)) && (string2 = (String)this.get(IP_GATEWAY)) != null) {
            stringBuffer = new StringBuffer("set ");
            stringBuffer.append("gateway ");
            stringBuffer.append(string2);
            string = (String)this.get(IP_METRIC);
            if (string != null && string.length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            lEVector2.addElement(new String(stringBuffer));
        }
        if (bl || lEVector.contains(IPX)) {
            this.makeSetCommand(lEVector2, null, IPX, "ipx");
        }
        if ((bl || lEVector.contains(IPX_GATEWAY) || lEVector.contains(IPX_METRIC)) && (string2 = (String)this.get(IPX_GATEWAY)) != null) {
            stringBuffer = new StringBuffer("set ");
            stringBuffer.append("ipxgate ");
            stringBuffer.append(string2);
            string = (String)this.get(IPX_METRIC);
            if (string != null && string.length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            lEVector2.addElement(new String(stringBuffer));
        }
        if (bl || lEVector.contains(ISDN_MSN)) {
            this.makeSetCommand(lEVector2, null, ISDN_MSN, "isdn-msn");
        }
        if (bl || lEVector.contains(ISDN_NUM_AUTO)) {
            this.makeSetCommand(lEVector2, null, ISDN_NUM_AUTO, "isdn-numberauto");
        }
        if (bl || lEVector.contains(LOGHOST)) {
            this.makeSetCommand(lEVector2, null, LOGHOST, "loghost");
        }
        if (bl || lEVector.contains(MAX_PMC)) {
            this.makeSetCommand(lEVector2, null, MAX_PMC, "maximum pmconsole");
        }
        if ((bl || lEVector.contains(MCPPP_ENDPOINT)) && this.makeSetCommand(lEVector2, null, MCPPP_ENDPOINT, "endpoint")) {
            bl2 = true;
        }
        if (bl || lEVector.contains(NAME_SERVICE)) {
            this.makeSetCommand(lEVector2, null, NAME_SERVICE, "namesvc");
        }
        if (bl || lEVector.contains(NAME_SERVER_ALT)) {
            this.makeSetCommand(lEVector2, null, NAME_SERVER_ALT, "nameserver 2");
        }
        if (bl || lEVector.contains(NAME_SERVER_PRI)) {
            this.makeSetCommand(lEVector2, null, NAME_SERVER_PRI, "nameserver");
        }
        if (bl || lEVector.contains(NETBIOS)) {
            this.makeSetCommand(lEVector2, null, NETBIOS, "netbios");
        }
        if (bl || lEVector.contains(NETBIOS_NS_ALT)) {
            this.makeSetCommand(lEVector2, null, NETBIOS_NS_ALT, "nbns 2");
        }
        if (bl || lEVector.contains(NETBIOS_NS_PRI)) {
            this.makeSetCommand(lEVector2, null, NETBIOS_NS_PRI, "nbns 1");
        }
        if ((bl || lEVector.contains(OSPF)) && this.makeSetCommand(lEVector2, null, OSPF, "ospf")) {
            bl2 = true;
        }
        if (bl || lEVector.contains(PAP)) {
            this.makeSetCommand(lEVector2, null, PAP, "pap");
        }
        if (!bl && lEVector.contains(PASSWORD)) {
            this.makeSetCommand(lEVector2, null, PASSWORD, PASSWORD);
        }
        if (bl || lEVector.contains(PROXY_ARP)) {
            this.makeSetCommand(lEVector2, null, PROXY_ARP, "arp-proxy");
        }
        if (bl || lEVector.contains(REPORTED_IP)) {
            this.makeSetCommand(lEVector2, null, REPORTED_IP, "reported-ip");
        }
        if (bl || lEVector.contains(SERIAL_ADMIN)) {
            this.makeSetCommand(lEVector2, null, SERIAL_ADMIN, "serial-admin");
        }
        if (bl || lEVector.contains(SHUTDOWN_TEMP)) {
            this.makeSetCommand(lEVector2, null, SHUTDOWN_TEMP, "shutdown-temp");
        }
        if ((bl || lEVector.contains(SNMP)) && this.makeSetCommand(lEVector2, null, SNMP, "snmp")) {
            bl2 = true;
        }
        if (bl || lEVector.contains(SYSNAME)) {
            this.makeSetCommand(lEVector2, null, SYSNAME, "sysname");
        }
        if (bl || lEVector.contains(TELNET_PORT)) {
            this.makeSetCommand(lEVector2, null, TELNET_PORT, "telnet");
        }
        if (bl || lEVector.contains(USER_NETMASK)) {
            this.makeSetCommand(lEVector2, null, USER_NETMASK, "user-netmask");
        }
        if (bl && this.m_ripFetched) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("set rip-password \"");
            stringBuffer.append((String)this.get(RIP_PASSWORD));
            stringBuffer.append("\"");
            lEVector2.addElement(stringBuffer.toString());
        } else if (!bl && lEVector.contains(RIP_PASSWORD)) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("set rip-password \"");
            stringBuffer.append((String)this.get(RIP_PASSWORD));
            stringBuffer.append("\"");
            lEVector2.addElement(stringBuffer.toString());
        }
        if (bl && this.m_callFetched) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("set call-check password ");
            stringBuffer.append((String)this.get(CALL_CHECK_PASS));
            lEVector2.addElement(stringBuffer.toString());
        } else if (!bl && lEVector.contains(CALL_CHECK_PASS)) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("set call-check password ");
            stringBuffer.append((String)this.get(CALL_CHECK_PASS));
            lEVector2.addElement(stringBuffer.toString());
        }
        if (bl2) {
            lEVector2.addElement("save all");
            lEVector2.addElement("reboot");
        }
        return lEVector2.size() > n;
    }
}

