/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEListItem;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEScrollable;
import com.lucent.ra.nms.util.LECompare;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class LEMultiList
extends Canvas
implements MouseListener,
MouseMotionListener,
LECompare,
LEScrollable {
    public static final int BORDER = 1;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static final int HORZ_BUF = 4;
    static final int VERT_BUF = 2;
    int m_cols;
    int m_numTitleCols;
    int m_numTitleRows;
    int m_titleHeight;
    int m_titleWidth;
    int m_totalWidth;
    int m_totalHeight;
    int m_minDisplayRows;
    Object[][] m_colTitles;
    int[] m_colTitleJusts;
    int[] m_rowTitleJusts;
    int[] m_colJusts;
    int[] m_widths;
    int[] m_heights;
    int[] m_fixed;
    LEVector m_rows;
    boolean m_disabled;
    boolean[] m_sortable;
    LECompare[] m_sortObj;
    int m_sortCol;
    int m_lastSort;
    boolean m_rev = false;
    Font m_bold;
    Font m_font;
    Image m_cellDB;
    Image m_colTitleDB;
    Image m_rowTitleDB;
    Image m_cornerDB;
    Color m_fore;
    Color m_back;
    Color m_titleBack;
    Color m_selFore;
    Color m_selBack;
    boolean m_changed;
    boolean m_redraw;
    boolean m_grid;
    boolean m_done;
    LEScrollPanel m_scrollPanel;
    int m_x;
    int m_y;
    Dimension m_area = new Dimension();
    int m_mouse;
    int m_height;
    int m_resizeCol;
    Graphics m_gc;
    boolean m_inside;
    LEVector m_select = new LEVector();
    boolean m_multiSelect = true;
    LEVector m_listeners = new LEVector();

    public LEMultiList() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.m_back = Color.white;
        this.m_fore = LEColor.getForeground();
        this.m_titleBack = LEColor.getBackground();
        this.m_selFore = LEColor.getSelectForeground();
        this.m_selBack = LEColor.getSelectBackground();
    }

    public LEMultiList(int n, int n2, int n3) {
        this();
        this.initialize(n, n2, n3);
    }

    public void initialize(int n, int n2, int n3) {
        this.m_cols = n2 + n3;
        this.m_numTitleCols = n2;
        this.m_numTitleRows = n;
        this.m_colTitles = new Object[this.m_numTitleRows][this.m_cols];
        this.m_colTitleJusts = new int[this.m_cols];
        this.m_colJusts = new int[this.m_cols];
        this.m_fixed = new int[this.m_cols];
        this.m_sortable = new boolean[this.m_cols];
        this.m_widths = new int[this.m_cols];
        this.m_changed = true;
    }

    public void addNotify() {
        super.addNotify();
        this.totalArea();
    }

    public void cleanUp() {
        this.m_done = true;
        if (this.m_cellDB != null) {
            this.m_cellDB.flush();
        }
        if (this.m_colTitleDB != null) {
            this.m_colTitleDB.flush();
        }
        if (this.m_rowTitleDB != null) {
            this.m_rowTitleDB.flush();
        }
        if (this.m_cornerDB != null) {
            this.m_cornerDB.flush();
        }
        if (this.m_rows != null) {
            this.m_rows.removeAllElements();
        }
        this.m_rows = null;
        this.m_colTitles = null;
        this.m_colTitleJusts = null;
        this.m_colJusts = null;
        this.m_fixed = null;
        this.m_sortable = null;
        this.m_widths = null;
    }

    public Dimension getMinimumSize() {
        return this.totalArea();
    }

    public Dimension getPreferredSize() {
        return this.totalArea();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.m_disabled = false;
            this.redraw();
            super.setEnabled(bl);
            return;
        }
        super.setEnabled(bl);
        this.m_disabled = true;
        this.redraw();
    }

    public void setTitles(int n, Object[] objectArray) {
        if (n < this.m_numTitleRows) {
            this.m_colTitles[n] = objectArray;
            this.m_changed = true;
        }
    }

    public void setMultipleSelect(boolean bl) {
        this.m_multiSelect = bl;
    }

    public void setMinDisplayRows(int n) {
        this.m_minDisplayRows = n;
    }

    public synchronized int addRow(Object[] objectArray) {
        Object[] objectArray2 = new Object[this.m_cols + 1];
        int n = Math.min(this.m_cols + 1, objectArray.length);
        int n2 = 0;
        while (n2 < n) {
            objectArray2[n2] = objectArray[n2];
            ++n2;
        }
        if (this.m_rows == null) {
            this.m_rows = new LEVector();
        }
        this.m_rows.addElement(objectArray2);
        this.m_heights = null;
        this.m_changed = true;
        return this.m_rows.size() - 1;
    }

    public void showGrid(boolean bl) {
        this.m_grid = bl;
        this.m_changed = true;
    }

    public void setColumnWidth(int n, int n2) {
        if (n < this.m_cols) {
            this.m_fixed[n] = n2;
            this.m_changed = true;
        }
    }

    public void setCellJustification(int n, int n2) {
        if (n < this.m_cols) {
            this.m_colJusts[n] = n2;
            this.m_changed = true;
        }
    }

    public void setTitleJustification(int n, int n2) {
        if (n < this.m_cols) {
            this.m_colTitleJusts[n] = n2;
            this.m_changed = true;
        }
    }

    public void setRowObject(int n, Object object) {
        if (this.m_rows == null && n >= this.m_rows.size()) {
            return;
        }
        Object[] objectArray = (Object[])this.m_rows.elementAt(n);
        objectArray[this.m_cols] = object;
    }

    public Object getRowObject(int n) {
        return this.getCellItem(n, this.m_cols);
    }

    public int getNumColumns() {
        return this.m_cols;
    }

    public int getNumRows() {
        if (this.m_rows == null) {
            return 0;
        }
        return this.m_rows.size();
    }

    public Object getCellItem(int n, int n2) {
        if (this.m_rows == null || n >= this.m_rows.size()) {
            return null;
        }
        if (n2 > this.m_cols) {
            return null;
        }
        Object[] objectArray = (Object[])this.m_rows.elementAt(n);
        return objectArray[n2];
    }

    public synchronized void setCellItem(int n, int n2, Object object) {
        if (this.m_rows == null || n >= this.m_rows.size()) {
            return;
        }
        if (n2 >= this.m_cols) {
            return;
        }
        this.drawCell(n, n2, object);
    }

    public void deleteAllRows() {
        int n = this.m_select.size();
        int n2 = this.getNumRows();
        int n3 = n2 - 1;
        while (n3 > 0) {
            this.deleteRow(n3, false);
            --n3;
        }
        this.deleteRow(0, true);
        if (n > this.m_select.size()) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void deleteRows(int[] nArray) {
        if (nArray.length > 0) {
            int n = this.m_select.size();
            int n2 = nArray.length - 1;
            while (n2 > 0) {
                this.deleteRow(nArray[n2], false);
                --n2;
            }
            this.deleteRow(nArray[0], true);
            if (n > this.m_select.size()) {
                this.notifyListeners(new LEMLEvent(this, 3));
            }
        }
    }

    public void deleteRow(int n) {
        int n2 = this.m_select.size();
        this.deleteRow(n, true);
        if (n2 > this.m_select.size()) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public boolean isRowSelected(int n) {
        Integer n2 = new Integer(n);
        return this.m_select.contains(n2);
    }

    public int getSelectSize() {
        return this.m_select.size();
    }

    public int[] getSelectedRows() {
        LEVector lEVector = new LEVector();
        lEVector.addVector(this.m_select);
        lEVector.quickSort(this);
        int n = lEVector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (Integer)lEVector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }

    public void selectRows(int[] nArray) {
        this.clearSelect(true);
        int n = this.m_rows.size();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] <= n) {
                this.select(nArray[n2], true);
            }
            ++n2;
        }
        this.notifyListeners(new LEMLEvent(this, 3));
        this.redraw();
    }

    public void swapRows(int n, int n2) {
        this.m_rows.swapElements(n, n2);
        this.m_changed = true;
    }

    public void clearSelection(boolean bl) {
        this.clearSelect(bl);
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void unselectRow(int n, boolean bl) {
        this.unselect(n, bl);
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void addListener(LEMLListener lEMLListener) {
        this.m_listeners.addElementUnique(lEMLListener);
    }

    public void deleteListener(LEMLListener lEMLListener) {
        this.m_listeners.removeElement(lEMLListener);
    }

    public void setSortable(int n, boolean bl) {
        if (n < this.m_cols) {
            this.m_sortable[n] = bl;
        }
    }

    public void setSortObject(int n, LECompare lECompare) {
        if (n < this.m_cols) {
            if (this.m_sortObj == null) {
                this.m_sortObj = new LECompare[this.m_cols];
            }
            this.m_sortObj[n] = lECompare;
        }
    }

    public void sort(int n) {
        if (this.m_rows != null && n < this.m_cols) {
            this.notifyListeners(new LEMLEvent(this, 4));
            int n2 = this.m_select.size();
            Object[][] objectArray = new Object[n2][];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = (Object[])this.m_rows.elementAt((Integer)this.m_select.elementAt(n3));
                ++n3;
            }
            if (n == this.m_sortCol) {
                this.m_rev = !this.m_rev;
                this.m_rows.quickSort(this, this.m_rev);
                this.secondarySort(this.m_lastSort, this.m_rev);
            } else {
                this.m_lastSort = this.m_sortCol;
                this.m_sortCol = n;
                this.m_rows.quickSort(this, this.m_rev);
                this.secondarySort(this.m_lastSort, this.m_rev);
            }
            this.m_select.removeAllElements();
            int n4 = this.m_rows.size();
            int n5 = 0;
            while (n5 < n4) {
                Object[] objectArray2 = (Object[])this.m_rows.elementAt(n5);
                int n6 = 0;
                while (n6 < n2) {
                    if (objectArray[n6] == objectArray2) {
                        this.m_select.addElement(new Integer(n5));
                    }
                    ++n6;
                }
                ++n5;
            }
            this.redraw();
            this.notifyListeners(new LEMLEvent(this, 5));
        }
    }

    public void secondarySort(int n, boolean bl) {
        int n2 = this.m_sortCol;
        this.m_sortCol = n;
        int n3 = 0;
        Object object = this.getCellItem(0, n2);
        int n4 = 1;
        while (n4 < this.m_rows.size()) {
            Object object2 = this.getCellItem(n4, n2);
            if (object != object2 && object2 != null && !object2.equals(object)) {
                if (n4 - n3 > 2) {
                    this.m_rows.quickSort(this, n3, n4 - 1, bl);
                }
                n3 = n4;
            }
            object = object2;
            ++n4;
        }
        if (n4 - n3 > 2) {
            this.m_rows.quickSort(this, n3, n4 - 1, bl);
        }
        this.m_sortCol = n2;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof Integer) {
            return this.compare((Number)object, (Number)object2);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        Object object3 = objectArray[this.m_sortCol];
        Object object4 = objectArray2[this.m_sortCol];
        if (object3 == null && object4 == null) {
            return 0;
        }
        if (object3 == null) {
            return -1;
        }
        if (object4 == null) {
            return 1;
        }
        if (this.m_sortObj != null && this.m_sortObj[this.m_sortCol] != null) {
            return this.m_sortObj[this.m_sortCol].compare(object3, object4);
        }
        if (object3 instanceof LEListItem) {
            return ((LEListItem)object3).compareTo((LEListItem)object4);
        }
        if (object3 instanceof String) {
            return ((String)object3).compareTo((String)object4);
        }
        if (object3 instanceof Number) {
            return this.compare((Number)object3, (Number)object4);
        }
        return object3.toString().compareTo(object4.toString());
    }

    public int compare(Number number, Number number2) {
        double d;
        if (number instanceof Long) {
            long l;
            long l2 = number.longValue();
            if (l2 < (l = number2.longValue())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        double d2 = number.doubleValue();
        if (d2 < (d = number2.doubleValue())) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public void update(Graphics graphics) {
        if (!this.m_done) {
            this.paint(graphics);
        }
    }

    public void redraw() {
        if (this.m_done) {
            return;
        }
        this.m_redraw = true;
        this.repaint();
    }

    public void layoutGrid() {
        if (this.m_done) {
            return;
        }
        this.m_changed = true;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.m_done) {
            return;
        }
        try {
            Dimension dimension = this.getSize();
            LEMultiList lEMultiList = this;
            synchronized (lEMultiList) {
                if (this.m_changed) {
                    this.m_redraw = true;
                    this.calculateLayout(graphics, true);
                    this.m_area.setSize(this.m_totalWidth, this.m_totalHeight);
                    if (this.m_scrollPanel != null) {
                        this.m_scrollPanel.updateScrollbars(this.m_area.width, this.m_area.height);
                        dimension = this.getSize();
                    }
                    this.calculateLayout(graphics, false);
                    this.m_changed = false;
                    if (this.m_cellDB != null) {
                        this.m_cellDB.flush();
                    }
                    if (this.m_colTitleDB != null) {
                        this.m_colTitleDB.flush();
                    }
                    if (this.m_rowTitleDB != null) {
                        this.m_rowTitleDB.flush();
                    }
                    if (this.m_cornerDB != null) {
                        this.m_cornerDB.flush();
                    }
                    this.m_cellDB = null;
                    this.m_colTitleDB = null;
                    this.m_rowTitleDB = null;
                    this.m_cornerDB = null;
                    int n = this.m_totalWidth - this.m_titleWidth;
                    int n2 = this.m_totalHeight - this.m_titleHeight;
                    if (n > 0 && n2 > 0) {
                        this.m_cellDB = this.createImage(n, n2);
                    }
                    if (this.m_titleWidth > 0) {
                        this.m_rowTitleDB = this.createImage(this.m_titleWidth, this.m_totalHeight - this.m_titleHeight);
                    }
                    if (this.m_titleHeight > 0) {
                        this.m_colTitleDB = this.createImage(this.m_totalWidth - this.m_titleWidth, this.m_titleHeight);
                    }
                    if (this.m_titleHeight > 0 && this.m_titleWidth > 0) {
                        this.m_cornerDB = this.createImage(this.m_titleWidth, this.m_titleHeight);
                    }
                }
                if (this.m_redraw) {
                    this.drawMultiList();
                }
                if (dimension.height > this.m_totalHeight) {
                    graphics.clearRect(0, this.m_totalHeight, dimension.width, dimension.height - this.m_totalHeight);
                }
                if (this.m_colTitleDB != null) {
                    graphics.drawImage(this.m_colTitleDB, this.m_titleWidth + this.m_x, 0, this);
                }
                if (this.m_cornerDB != null) {
                    graphics.drawImage(this.m_cornerDB, 0, 0, this);
                }
                graphics.clipRect(0, this.m_titleHeight, dimension.width, dimension.height - this.m_titleHeight);
                if (this.m_rowTitleDB != null) {
                    graphics.drawImage(this.m_rowTitleDB, 0, this.m_titleHeight + this.m_y, this);
                } else {
                    graphics.clearRect(0, this.m_titleHeight, this.m_titleWidth, dimension.height - this.m_titleHeight);
                }
                graphics.clipRect(this.m_titleWidth, this.m_titleHeight, dimension.width - this.m_titleWidth, dimension.height - this.m_titleHeight);
                if (this.m_cellDB != null) {
                    graphics.drawImage(this.m_cellDB, this.m_titleWidth + this.m_x, this.m_titleHeight + this.m_y, this);
                }
                if (this.m_gc != null && this.m_inside) {
                    this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                }
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.m_changed = true;
            this.repaint(1000L);
            return;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.m_done) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.x != n || rectangle.y != n2 || rectangle.width != n3 || rectangle.height != n4) {
            super.setBounds(n, n2, n3, n4);
            this.m_changed = true;
        }
    }

    public void setSize(int n, int n2) {
        if (this.m_done) {
            return;
        }
        super.setSize(n, n2);
        this.m_changed = true;
    }

    public void setSize(Dimension dimension) {
        if (this.m_done) {
            return;
        }
        super.setSize(dimension);
        this.m_changed = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_gc != null) {
                this.m_inside = true;
                this.m_mouse = mouseEvent.getX();
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_gc != null) {
                this.m_inside = false;
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block25: {
            if (this.m_disabled || this.m_done) {
                return;
            }
            try {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (this.m_titleHeight > 0 && n2 < this.m_titleHeight) {
                    int n3;
                    this.m_mouse = this.shouldResize(n);
                    if (this.m_mouse > 0) {
                        this.m_gc = this.getGraphics();
                        this.m_gc.setXORMode(Color.white);
                        this.m_height = this.getSize().height - 1;
                        this.m_height = this.m_totalHeight - 1;
                        this.m_inside = true;
                        return;
                    }
                    if (n2 < this.m_titleHeight && this.m_sortable[n3 = this.getColumn(n)]) {
                        this.sort(n3);
                        return;
                    }
                } else {
                    if (this.m_rows == null) break block25;
                    int n4 = this.getRow(n2);
                    if (n4 < 0 || n4 >= this.m_rows.size()) {
                        return;
                    }
                    if (mouseEvent.getClickCount() % 2 == 0) {
                        this.notifyListeners(new LEMLEvent(this, 6, n4));
                        return;
                    }
                    if (this.m_multiSelect && mouseEvent.isShiftDown()) {
                        int n5 = this.m_select.size();
                        if (n5 > 0) {
                            int n6;
                            int[] nArray = new int[n5];
                            int n7 = 0;
                            while (n7 < n5) {
                                nArray[n7] = (Integer)this.m_select.elementAt(n7);
                                ++n7;
                            }
                            int n8 = Math.min(n4, nArray[0]);
                            if (n8 < (n6 = Math.max(n4, nArray[0]))) {
                                int n9 = 1;
                                while (n9 < n5) {
                                    if (nArray[n9] < n8 || nArray[n9] > n6) {
                                        this.unselect(nArray[n9], true);
                                    }
                                    ++n9;
                                }
                                int n10 = n8;
                                while (n10 <= n6) {
                                    if (!this.isRowSelected(n10)) {
                                        this.select(n10, true);
                                    }
                                    ++n10;
                                }
                            }
                        } else {
                            this.select(n4, true);
                        }
                    } else if (mouseEvent.isControlDown()) {
                        if (this.isRowSelected(n4)) {
                            this.unselect(n4, true);
                        } else if (this.m_multiSelect) {
                            this.select(n4, true);
                        }
                    } else {
                        this.clearSelect(true);
                        this.select(n4, true);
                    }
                    this.notifyListeners(new LEMLEvent(this, 3));
                    this.redraw();
                }
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_gc != null) {
                if (this.m_inside) {
                    this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                    this.resizeColumn(mouseEvent.getX());
                }
                this.m_gc.dispose();
                this.m_gc = null;
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_inside && this.m_gc != null) {
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                this.m_mouse = mouseEvent.getX();
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setScrollPanel(LEScrollPanel lEScrollPanel) {
        this.m_scrollPanel = lEScrollPanel;
    }

    public void setOrigin(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void scrollTo(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        this.repaint();
    }

    public void startScroll() {
    }

    public void endScroll() {
    }

    public Dimension totalArea() {
        Graphics graphics = this.getGraphics();
        if (graphics != null && (this.m_totalWidth == 0 || this.m_totalHeight == 0)) {
            this.calculateLayout(graphics, true);
            this.m_area.setSize(this.m_totalWidth, this.m_totalHeight);
            this.calculateLayout(graphics, false);
            graphics.dispose();
        }
        return this.m_area;
    }

    public void notifyListeners(LEMLEvent lEMLEvent) {
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            LEMLListener lEMLListener = (LEMLListener)this.m_listeners.elementAt(n2);
            lEMLListener.onLEMLEvent(lEMLEvent);
            ++n2;
        }
    }

    void drawMultiList() {
        Graphics graphics;
        if (this.m_done) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.height > this.m_totalHeight && (graphics = this.getGraphics()) != null) {
            graphics.setColor(this.m_back);
            graphics.fillRect(0, dimension.height, dimension.width, dimension.height - this.m_totalHeight);
            graphics.dispose();
        }
        if (this.m_rows != null) {
            if (this.m_cellDB != null) {
                graphics = this.m_cellDB.getGraphics();
                this.drawData(graphics);
                if (this.m_grid) {
                    this.drawGrid(graphics);
                }
                graphics.dispose();
            }
            if (this.m_titleWidth > 0 && this.m_rowTitleDB != null) {
                graphics = this.m_rowTitleDB.getGraphics();
                this.drawRowTitles(graphics);
                graphics.dispose();
            } else {
                this.m_rowTitleDB = null;
            }
        }
        if (this.m_titleHeight > 0 && this.m_colTitleDB != null) {
            graphics = this.m_colTitleDB.getGraphics();
            this.drawColTitles(graphics);
            graphics.dispose();
        }
        if (this.m_titleHeight > 0 && this.m_titleWidth > 0 && this.m_cornerDB != null) {
            graphics = this.m_cornerDB.getGraphics();
            this.drawCorner(graphics);
            graphics.dispose();
        }
        this.m_redraw = false;
    }

    void drawGrid(Graphics graphics) {
        int n = 0;
        int n2 = this.m_numTitleCols;
        while (n2 < this.m_cols) {
            n += this.m_widths[n2] + 1;
            ++n2;
        }
        ++n;
        graphics.setColor(this.m_titleBack);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = this.m_numTitleRows;
        while (n2 < this.m_heights.length) {
            graphics.drawLine(n3, n4, n, n4);
            n4 += this.m_heights[n2] + 1;
            n5 += this.m_heights[n2] + 1;
            ++n2;
        }
        graphics.drawLine(n3, n4, n, n4);
        n3 = 0;
        n4 = 0;
        n2 = this.m_numTitleCols;
        while (n2 < this.m_cols) {
            graphics.drawLine(n3, n4, n3, n5);
            n3 += this.m_widths[n2] + 1;
            ++n2;
        }
        graphics.drawLine(n3, n4, n3, n5);
    }

    void drawData(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_font);
        graphics.setFont(this.m_font);
        int n = 1;
        int n2 = 1;
        int n3 = this.m_rows.size() + this.m_numTitleRows;
        int n4 = this.m_numTitleRows;
        while (n4 < n3) {
            Color color;
            Color color2;
            Object[] objectArray = (Object[])this.m_rows.elementAt(n4 - this.m_numTitleRows);
            if (this.isRowSelected(n4 - this.m_numTitleRows)) {
                color2 = this.m_selBack;
                color = this.m_selFore;
            } else {
                color2 = this.m_back;
                color = this.m_disabled ? this.m_back.darker() : this.m_fore;
            }
            int n5 = this.m_numTitleCols;
            while (n5 < this.m_cols) {
                graphics.setColor(color2);
                graphics.fillRect(n - 1, n2, this.m_widths[n5] + 1, this.m_heights[n4]);
                graphics.setColor(color);
                this.drawItem(objectArray[n5], graphics, fontMetrics, n + 4, n2 + 2, this.m_widths[n5] - 8, this.m_heights[n4] - 4, this.m_colJusts[n5]);
                n += this.m_widths[n5] + 1;
                ++n5;
            }
            n = 1;
            n2 += this.m_heights[n4] + 1;
            ++n4;
        }
    }

    void drawColTitles(Graphics graphics) {
        this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_bold);
        Color color = this.m_disabled ? this.m_titleBack.darker() : this.m_fore;
        graphics.setFont(this.m_bold);
        graphics.setColor(this.m_titleBack);
        graphics.fillRect(0, 0, this.m_totalWidth - this.m_titleWidth, this.m_titleHeight);
        int n = 1;
        int n2 = 1;
        int n3 = this.m_numTitleCols;
        while (n3 < this.m_cols) {
            graphics.setColor(this.m_titleBack);
            graphics.fill3DRect(n, n2, this.m_widths[n3], this.m_titleHeight - 2, true);
            graphics.setColor(color);
            int n4 = 0;
            while (n4 < this.m_numTitleRows) {
                this.drawItem(this.m_colTitles[n4][n3], graphics, fontMetrics, n + 4, n2 + 2, this.m_widths[n3] - 8, this.m_heights[n4] - 4, this.m_colTitleJusts[n3]);
                n2 += this.m_heights[n4] + 1;
                ++n4;
            }
            n += this.m_widths[n3] + 1;
            n2 = 1;
            ++n3;
        }
    }

    void drawRowTitles(Graphics graphics) {
        this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_bold);
        Color color = this.m_disabled ? this.m_titleBack.darker() : this.m_fore;
        graphics.setColor(this.m_titleBack);
        graphics.fillRect(0, 0, this.m_titleWidth, this.m_totalHeight - this.m_titleHeight);
        graphics.setFont(this.m_bold);
        int n = 1;
        int n2 = 1;
        int n3 = this.m_titleWidth - 2;
        int n4 = this.m_rows.size();
        int n5 = 0;
        while (n5 < n4) {
            Object[] objectArray = (Object[])this.m_rows.elementAt(n5);
            graphics.setColor(this.m_titleBack);
            graphics.fill3DRect(n, n2, n3, this.m_heights[n5 + this.m_numTitleRows], true);
            graphics.setColor(color);
            int n6 = 0;
            while (n6 < this.m_numTitleCols) {
                this.drawItem(objectArray[n6], graphics, fontMetrics, n + 4, n2 + 2, this.m_widths[n6] - 8, this.m_heights[n5 + this.m_numTitleRows] - 4, this.m_colJusts[n6]);
                n += this.m_widths[n6] + 1;
                ++n6;
            }
            n = 1;
            n2 += this.m_heights[n5 + this.m_numTitleRows] + 1;
            ++n5;
        }
    }

    void drawCorner(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_bold);
        graphics.setColor(this.m_titleBack);
        graphics.fillRect(0, 0, this.m_titleWidth, this.m_titleHeight);
        graphics.fill3DRect(1, 1, this.m_titleWidth - 2, this.m_titleHeight - 2, true);
        Color color = this.m_disabled ? this.m_titleBack.darker() : this.m_fore;
        graphics.setColor(color);
        graphics.setFont(this.m_bold);
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.m_numTitleRows) {
            int n4 = 0;
            while (n4 < this.m_numTitleCols) {
                this.drawItem(this.m_colTitles[n3][n4], graphics, fontMetrics, n + 4, n2 + 2, this.m_widths[n4] - 8, this.m_heights[n3] - 4, this.m_colJusts[n4]);
                n += this.m_widths[n4] + 1;
                ++n4;
            }
            n = 1;
            n2 += this.m_heights[n3] + 1;
            ++n3;
        }
    }

    void drawItem(Object object, Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
        if (object instanceof LEListItem) {
            ((LEListItem)object).draw(graphics, fontMetrics, n, n2, n3, n4, n5);
            return;
        }
        if (object instanceof String) {
            this.drawString((String)object, graphics, fontMetrics, n, n2, n3, n4, n5);
            return;
        }
        if (object != null) {
            this.drawString(object.toString(), graphics, fontMetrics, n, n2, n3, n4, n5);
        }
    }

    void drawString(String string, Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
        if (string == null) {
            return;
        }
        n2 += (n4 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        switch (n5) {
            case 1: {
                int n6 = Math.max(n, n + (n3 - fontMetrics.stringWidth(string)) / 2);
                graphics.drawString(string, n6, n2);
                return;
            }
            case 2: {
                int n7 = Math.max(n, n + n3 - fontMetrics.stringWidth(string));
                graphics.drawString(string, n7, n2);
                return;
            }
        }
        graphics.drawString(string, n, n2);
    }

    void drawCell(int n, int n2, Object object) {
        Color color;
        FontMetrics fontMetrics;
        Graphics graphics;
        int n3;
        this.m_rows.size();
        Object[] objectArray = (Object[])this.m_rows.elementAt(n);
        objectArray[n2] = object;
        if (this.m_changed || this.m_cellDB == null) {
            return;
        }
        int n4 = 1;
        int n5 = n3 = n2 < this.m_numTitleCols ? 0 : this.m_numTitleCols;
        while (n5 < n2) {
            n4 += this.m_widths[n5] + 1;
            ++n5;
        }
        int n6 = this.m_widths[n5];
        int n7 = 1;
        n += this.m_numTitleRows;
        n5 = this.m_numTitleRows;
        while (n5 < n) {
            n7 += this.m_heights[n5] + 1;
            ++n5;
        }
        int n8 = this.m_heights[n5];
        if (n2 < this.m_numTitleCols) {
            graphics = this.m_rowTitleDB.getGraphics();
            fontMetrics = graphics.getFontMetrics(this.m_bold);
            graphics.setColor(this.m_titleBack);
            graphics.setFont(this.m_bold);
            color = this.m_fore;
        } else {
            graphics = this.m_cellDB.getGraphics();
            fontMetrics = graphics.getFontMetrics(this.m_font);
            if (this.isRowSelected(n - this.m_numTitleRows)) {
                graphics.setColor(this.m_selBack);
                color = this.m_selFore;
            } else {
                graphics.setColor(this.m_back);
                color = this.m_fore;
            }
            graphics.setFont(this.m_font);
        }
        if (this.getItemHeight(object, graphics, fontMetrics) > n8 || this.getItemWidth(object, graphics, fontMetrics) > n6) {
            this.m_changed = true;
        } else {
            graphics.fillRect(n4 + 4, n7 + 2, n6 - 8, n8 - 4);
            graphics.setColor(color);
            this.drawItem(object, graphics, fontMetrics, n4 + 4, n7 + 2, n6 - 8, n8 - 4, this.m_colJusts[n2]);
        }
        graphics.dispose();
        this.repaint();
    }

    void select(int n, boolean bl) {
        this.m_select.addElement(new Integer(n));
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 1, n));
        }
    }

    void clearSelect(boolean bl) {
        int n = this.m_select.size();
        int n2 = 0;
        while (n2 < n) {
            this.unselect((Integer)this.m_select.elementAt(0), bl);
            ++n2;
        }
    }

    void unselect(int n, boolean bl) {
        this.m_select.removeElement(new Integer(n));
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 2, n));
        }
    }

    void calculateLayout(Graphics graphics, boolean bl) {
        block37: {
            if (this.m_done) {
                return;
            }
            try {
                if (this.m_font == null) {
                    this.m_font = graphics.getFont();
                    this.m_bold = new Font(this.m_font.getName(), 1, this.m_font.getSize());
                }
                int n = 0;
                if (this.m_numTitleRows > 0 || this.m_rows != null) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    FontMetrics fontMetrics = graphics.getFontMetrics(this.m_bold);
                    FontMetrics fontMetrics2 = graphics.getFontMetrics();
                    int n7 = fontMetrics2.getHeight();
                    int n8 = 0;
                    int n9 = n6 = this.m_rows == null ? 0 : this.m_rows.size();
                    if (this.m_heights == null) {
                        this.m_heights = new int[this.m_numTitleRows + n6];
                    }
                    if (this.m_numTitleRows > 0) {
                        n5 = 0;
                        while (n5 < this.m_numTitleRows) {
                            this.m_heights[n5] = 0;
                            int n10 = 0;
                            while (n10 < this.m_cols) {
                                if (n5 == 0) {
                                    this.m_widths[n10] = 0;
                                }
                                if (this.m_fixed[n10] > 0 && this.m_widths[n10] == 0) {
                                    this.m_widths[n10] = this.m_fixed[n10];
                                    ++n8;
                                } else if (this.m_fixed[n10] == 0) {
                                    this.m_widths[n10] = Math.max(this.m_widths[n10], this.getItemWidth(this.m_colTitles[n5][n10], graphics, fontMetrics) + 8);
                                }
                                this.m_heights[n5] = Math.max(this.m_heights[n5], this.getItemHeight(this.m_colTitles[n5][n10], graphics, fontMetrics) + 4);
                                ++n10;
                            }
                            n += this.m_heights[n5] + 1;
                            ++n5;
                        }
                        ++n;
                    }
                    this.m_titleHeight = n;
                    n5 = 0;
                    if (this.m_rows != null) {
                        n4 = n5 = this.m_rows.size();
                        FontMetrics fontMetrics3 = this.m_numTitleCols > 0 ? fontMetrics : fontMetrics2;
                        n3 = 0;
                        while (n3 < n4) {
                            Object[] objectArray = (Object[])this.m_rows.elementAt(n3);
                            n2 = 0;
                            while (n2 < this.m_cols) {
                                FontMetrics fontMetrics4 = fontMetrics3 = n2 < this.m_numTitleCols ? fontMetrics : fontMetrics2;
                                if (this.m_fixed[n2] > 0 && this.m_widths[n2] == 0) {
                                    if (this.m_widths[n2] == 0) {
                                        this.m_widths[n2] = this.m_fixed[n2];
                                        ++n8;
                                    }
                                } else if (this.m_fixed[n2] == 0) {
                                    this.m_widths[n2] = Math.max(this.m_widths[n2], this.getItemWidth(objectArray[n2], graphics, fontMetrics3) + 8);
                                }
                                this.m_heights[n3 + this.m_numTitleRows] = Math.max(this.m_heights[n3 + this.m_numTitleRows], this.getItemHeight(objectArray[n2], graphics, fontMetrics3) + 4);
                                ++n2;
                            }
                            ++n3;
                        }
                    }
                    int n11 = 0;
                    while (n11 < this.m_numTitleCols) {
                        if (this.m_fixed[n11] == 0) {
                            ++n8;
                        }
                        ++n11;
                    }
                    if (!bl) {
                        Dimension dimension = this.getSize();
                        int n12 = dimension.width - (this.m_cols + 1);
                        if (this.m_numTitleCols > 0) {
                            --n12;
                        }
                        n3 = 0;
                        while (n3 < this.m_cols) {
                            n12 -= this.m_widths[n3];
                            ++n3;
                        }
                        if (n12 > 0 && this.m_cols - n8 > 0) {
                            n2 = 0;
                            int n13 = n12 / (this.m_cols - n8);
                            int n14 = this.m_numTitleCols;
                            while (n14 < this.m_cols) {
                                if (this.m_fixed[n14] == 0) {
                                    n2 = n14;
                                    int n15 = n14;
                                    this.m_widths[n15] = this.m_widths[n15] + n13;
                                    n12 -= n13;
                                }
                                ++n14;
                            }
                            if (n12 > 0) {
                                int n16 = n2;
                                this.m_widths[n16] = this.m_widths[n16] + n12;
                            }
                        }
                    }
                    this.m_titleWidth = 0;
                    if (this.m_numTitleCols > 0) {
                        n4 = 0;
                        while (n4 < this.m_numTitleCols) {
                            this.m_titleWidth += this.m_widths[n4] + 1;
                            ++n4;
                        }
                        ++this.m_titleWidth;
                    }
                    this.m_totalWidth = 1;
                    n4 = 0;
                    while (n4 < this.m_cols) {
                        this.m_totalWidth += this.m_widths[n4] + 1;
                        ++n4;
                    }
                    if (this.m_numTitleCols > 0) {
                        ++this.m_totalWidth;
                    }
                    this.m_totalHeight = 1;
                    int n17 = 0;
                    while (n17 < this.m_heights.length) {
                        this.m_totalHeight += this.m_heights[n17] + 1;
                        ++n17;
                    }
                    if (this.m_numTitleRows > 0) {
                        ++this.m_totalHeight;
                    }
                    if (n5 >= this.m_minDisplayRows) break block37;
                    this.m_totalHeight += (this.m_minDisplayRows - n5) * (n7 + 4);
                }
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    int getItemHeight(Object object, Graphics graphics, FontMetrics fontMetrics) {
        if (object == null) {
            return 0;
        }
        if (object instanceof LEListItem) {
            return ((LEListItem)object).getHeight(graphics, fontMetrics);
        }
        if (object instanceof Image) {
            return ((Image)object).getHeight(null);
        }
        return fontMetrics.getHeight();
    }

    int getItemWidth(Object object, Graphics graphics, FontMetrics fontMetrics) {
        if (object == null) {
            return 0;
        }
        if (object instanceof LEListItem) {
            return ((LEListItem)object).getWidth(graphics, fontMetrics);
        }
        if (object instanceof Image) {
            return ((Image)object).getWidth(null);
        }
        if (object instanceof String) {
            return fontMetrics.stringWidth((String)object);
        }
        return fontMetrics.stringWidth(object.toString());
    }

    int shouldResize(int n) {
        if (n < this.m_titleWidth) {
            return 0;
        }
        int n2 = n - this.m_x;
        int n3 = 1;
        int n4 = 1;
        while (n4 < this.m_cols) {
            int n5 = n2 - (n3 += this.m_widths[n4 - 1] + 1);
            if (n5 < -2) {
                return 0;
            }
            if (n5 <= 2) {
                this.m_resizeCol = n4 - 1;
                return n3 + this.m_x;
            }
            ++n4;
        }
        return 0;
    }

    int getColumn(int n) {
        int n2 = 0;
        if (n >= this.m_titleWidth) {
            n -= this.m_x;
        }
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.m_cols) {
            n2 = n4;
            if (n < (n3 += this.m_widths[n4] + 1)) break;
            ++n4;
        }
        return n2;
    }

    int getRow(int n) {
        int n2 = -1;
        if (this.m_rows != null && (n -= this.m_y) < this.m_totalHeight) {
            int n3 = this.m_titleHeight;
            int n4 = this.m_numTitleRows;
            while (n4 < this.m_heights.length) {
                ++n2;
                if (n < (n3 += this.m_heights[n4] + 1)) break;
                ++n4;
            }
        }
        return n2;
    }

    void resizeColumn(int n) {
        int n2 = n - this.m_x;
        int n3 = 1;
        int n4 = 0;
        while (n4 <= this.m_resizeCol) {
            n3 += this.m_widths[n4] + 1;
            ++n4;
        }
        this.m_fixed[this.m_resizeCol] = Math.max(this.m_widths[this.m_resizeCol] + n2 - n3, 2);
        this.layoutGrid();
    }

    void deleteRow(int n, boolean bl) {
        if (this.m_rows == null) {
            return;
        }
        int n2 = this.m_rows.size();
        if (n >= n2) {
            return;
        }
        if (this.isRowSelected(n)) {
            this.unselect(n, true);
        }
        this.m_rows.removeElementAt(n);
        if (this.m_rows.size() == 0) {
            this.m_titleWidth = 0;
            this.m_rows = null;
        }
        int n3 = this.m_select.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (Integer)this.m_select.elementAt(n4);
            if (n5 > n) {
                this.m_select.removeElementAt(n4);
                this.m_select.insertElementAt(new Integer(n5 - 1), n4);
            }
            ++n4;
        }
        if (this.m_heights == null || this.m_heights.length == 0) {
            return;
        }
        int[] nArray = new int[this.m_heights.length - 1];
        int n6 = n + this.m_numTitleRows;
        int n7 = 0;
        while (n7 < n6) {
            nArray[n7] = this.m_heights[n7];
            ++n7;
        }
        int n8 = n6 + 1;
        while (n8 < this.m_heights.length) {
            nArray[n8 - 1] = this.m_heights[n8];
            ++n8;
        }
        this.m_heights = nArray;
        if (bl) {
            this.layoutGrid();
        }
    }
}

