/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.util.LENetmask;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Panel;

public class LENetmaskPanel
extends Panel {
    private static final int DEFAULT_MIN_CIDR = 24;
    private static final int DEFAULT_MAX_CIDR = 30;
    int m_min_cidr;
    int m_max_cidr;
    Choice m_mask;

    public LENetmaskPanel() {
        super(new FlowLayout(0, 0, 0));
        Insets insets = this.getInsets();
        insets.right = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.top = 0;
        this.m_min_cidr = 24;
        this.m_max_cidr = 30;
        this.m_mask = new Choice();
        this.fillNetmask();
        this.add(this.m_mask);
    }

    public LENetmaskPanel(String string) {
        this();
        this.setNetmask(string);
    }

    public void setMinCIDR(int n) {
        this.m_min_cidr = n;
        this.fillNetmask();
        this.repaint();
    }

    public void setMaxCIDR(int n) {
        this.m_max_cidr = n;
        this.fillNetmask();
        this.repaint();
    }

    public void setCIDRRange(int n, int n2) {
        this.m_min_cidr = n;
        this.m_max_cidr = n2;
        this.fillNetmask();
        this.repaint();
    }

    public int getMinCIDR() {
        return this.m_min_cidr;
    }

    public int getMaxCIDR() {
        return this.m_max_cidr;
    }

    public void setNetmask(String string) {
        int n = this.m_mask.getItemCount();
        int n2 = string.indexOf(".");
        int n3 = 0;
        while (n3 < n) {
            String string2 = this.m_mask.getItem(n3);
            int n4 = string2.indexOf(":");
            String string3 = n2 > -1 ? string2.substring(0, n4) : string2.substring(n4 + 3);
            if (string3.indexOf(string) > -1) {
                this.m_mask.select(n3);
                return;
            }
            ++n3;
        }
    }

    public String getNetmask() {
        String string = this.m_mask.getSelectedItem();
        int n = string.indexOf(" : ");
        return string.substring(0, n);
    }

    public String getCIDR() {
        String string = this.m_mask.getSelectedItem();
        int n = string.indexOf("/");
        return string.substring(n + 1);
    }

    public long getAddressTotal() {
        String string = this.getCIDR();
        int n = Integer.parseInt(string);
        long l = LENetmask.GetTotalFromCIDR(n);
        return l;
    }

    protected void fillNetmask() {
        this.m_mask.removeAll();
        int n = this.m_min_cidr;
        while (n <= this.m_max_cidr) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LENetmask.GetQuadFromCIDR(n));
            stringBuffer.append(" : /");
            stringBuffer.append(n);
            this.m_mask.add(stringBuffer.toString());
            ++n;
        }
    }
}

