/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPRules;
import COM.livingston.model.LEIPXRule;
import COM.livingston.model.LEIPXRules;
import COM.livingston.model.LESAPRule;
import COM.livingston.model.LESAPRules;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class LEFilterFileParser {
    private static final int FILTER_TOKEN = 10;
    private static final int START = 3;
    LEFilters m_filters = new LEFilters(null);

    public void readFilters(LEVector lEVector) {
        int n = lEVector.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string;
                int n4;
                String string2 = (String)lEVector.elementAt(n2);
                if (!string2.startsWith("#") && string2.length() >= 3 && !string2.equals("save all") && (n4 = string2.length()) >= 13 && (string = string2.substring(3, 3 + (n3 = Math.min(n4, 10))).toLowerCase()).indexOf("filter") >= 0) {
                    if (string2.regionMatches(true, 0, "add ", 0, 4)) {
                        this.addFilter(string2);
                    } else if (string2.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseRule(string2);
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public LEFilters getFilters() {
        return this.m_filters;
    }

    public void writeFilters(PrintWriter printWriter) {
        LEVector lEVector = new LEVector();
        this.m_filters.getCommands(lEVector);
        int n = lEVector.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            printWriter.println(string);
            ++n2;
        }
    }

    private void addFilter(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        LEFilter lEFilter = new LEFilter(null, string2);
        lEFilter.initialize();
        this.m_filters.setField(string2, lEFilter);
    }

    protected void parseRule(String string) {
        block10: {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken().toLowerCase();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                LEFilter lEFilter = (LEFilter)this.m_filters.getConfig(string3);
                if (string2.equals("filter")) {
                    LEIPRules lEIPRules;
                    LEIPRule lEIPRule = new LEIPRule(null, string3, string4);
                    this.parseIPRule(lEIPRule, stringTokenizer);
                    if (lEFilter instanceof LEFilter && (lEIPRules = (LEIPRules)lEFilter.getConfig("ip_rule")) instanceof LEIPRules) {
                        lEIPRules.setField(string4, lEIPRule);
                        return;
                    }
                } else if (string2.equals("ipxfilter")) {
                    LEIPXRules lEIPXRules;
                    LEIPXRule lEIPXRule = new LEIPXRule(null, string3, string4);
                    this.parseIPXRule(lEIPXRule, stringTokenizer);
                    if (lEFilter instanceof LEFilter && (lEIPXRules = (LEIPXRules)lEFilter.getConfig("ipx_rule")) instanceof LEIPXRules) {
                        lEIPXRules.setField(string4, lEIPXRule);
                        return;
                    }
                } else {
                    LESAPRules lESAPRules;
                    if (!string2.equals("sapfilter")) break block10;
                    LESAPRule lESAPRule = new LESAPRule(null, string3, string4);
                    this.parseSAPRule(lESAPRule, stringTokenizer);
                    if (!(lEFilter instanceof LEFilter) || !((lESAPRules = (LESAPRules)lEFilter.getConfig("sap_rule")) instanceof LESAPRules)) break block10;
                    lESAPRules.setField(string4, lESAPRule);
                }
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    protected void parseIPRule(LEIPRule lEIPRule, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            lEIPRule.initialize(string);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            lEIPRule.setField("source", string2);
            lEIPRule.setField("destination", string3);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            String string4 = stringTokenizer.nextToken().toLowerCase();
            if (string4.equals("log")) {
                lEIPRule.setField("log", "on");
                return;
            }
            if (string4.equals("notify")) {
                lEIPRule.setField("notify", "on");
                return;
            }
            this.parseIPProtocol(lEIPRule, string4, stringTokenizer);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected void parseIPProtocol(LEIPRule lEIPRule, String string, StringTokenizer stringTokenizer) {
        try {
            if (string.equals("tcp")) {
                lEIPRule.setField("protocol", "tcp");
                this.parseTCPProtocol(lEIPRule, stringTokenizer);
                return;
            }
            if (string.equals("udp")) {
                lEIPRule.setField("protocol", "udp");
                this.parseUDPProtocol(lEIPRule, stringTokenizer);
                return;
            }
            if (string.equals("icmp")) {
                lEIPRule.setField("protocol", "icmp");
                this.parseICMPProtocol(lEIPRule, stringTokenizer);
                return;
            }
            if (string.equals("ip")) {
                lEIPRule.setField("protocol", "ip");
                return;
            }
            if (string.equals("protocol")) {
                String string2 = stringTokenizer.nextToken();
                lEIPRule.setField("protocol", "protocol");
                lEIPRule.setField("protocol_number", string2);
                return;
            }
            if (string.equals("esp")) {
                lEIPRule.setField("protocol", "esp");
                return;
            }
            if (string.equals("ah")) {
                lEIPRule.setField("protocol", "ah");
                return;
            }
            if (string.equals("ipip")) {
                lEIPRule.setField("protocol", "ipip");
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    protected void parseTCPProtocol(LEIPRule lEIPRule, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreElements()) {
            return;
        }
        try {
            String string = stringTokenizer.nextToken().toLowerCase();
            if (string.indexOf("estab") > -1) {
                lEIPRule.setField("estab", "on");
            } else if (string.equals("log")) {
                lEIPRule.setField("log", "on");
            } else if (string.equals("notify")) {
                lEIPRule.setField("notify", "on");
            } else if (string.equals("src")) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                lEIPRule.setField("src_cmp", string2);
                lEIPRule.setField("src_port", string3);
            } else if (string.equals("dst")) {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                lEIPRule.setField("dst_cmp", string4);
                lEIPRule.setField("dst_port", string5);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.parseTCPProtocol(lEIPRule, stringTokenizer);
    }

    protected void parseUDPProtocol(LEIPRule lEIPRule, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreElements()) {
            return;
        }
        try {
            String string = stringTokenizer.nextToken().toLowerCase();
            if (string.equals("log")) {
                lEIPRule.setField("log", "on");
            } else if (string.equals("notify")) {
                lEIPRule.setField("notify", "on");
            } else if (string.equals("src")) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                lEIPRule.setField("src_cmp", string2);
                lEIPRule.setField("src_port", string3);
            } else if (string.equals("dst")) {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                lEIPRule.setField("dst_cmp", string4);
                lEIPRule.setField("dst_port", string5);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.parseUDPProtocol(lEIPRule, stringTokenizer);
    }

    protected void parseICMPProtocol(LEIPRule lEIPRule, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreElements()) {
            return;
        }
        try {
            String string = stringTokenizer.nextToken().toLowerCase();
            if (string.equals("log")) {
                lEIPRule.setField("log", "on");
            } else if (string.equals("notify")) {
                lEIPRule.setField("notify", "on");
            } else if (string.equals("type")) {
                String string2 = stringTokenizer.nextToken();
                lEIPRule.setField("type", string2);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.parseICMPProtocol(lEIPRule, stringTokenizer);
    }

    protected void parseIPXRule(LEIPXRule lEIPXRule, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            lEIPXRule.initialize(string);
            if (!stringTokenizer.hasMoreElements()) {
                return;
            }
            this.parseIPXOptions(lEIPXRule, stringTokenizer);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected void parseIPXOptions(LEIPXRule lEIPXRule, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreElements()) {
            return;
        }
        try {
            String string = stringTokenizer.nextToken().toLowerCase();
            if (string.equals("srcnet")) {
                String string2 = stringTokenizer.nextToken();
                lEIPXRule.setField("src_net", string2);
            } else if (string.equals("srchost")) {
                String string3 = stringTokenizer.nextToken();
                lEIPXRule.setField("src_host", string3);
            } else if (string.equals("srcsocket")) {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                lEIPXRule.setField("src_cmp", string4);
                lEIPXRule.setField("src_socket", string5);
            } else if (string.equals("dstnet")) {
                String string6 = stringTokenizer.nextToken();
                lEIPXRule.setField("dst_net", string6);
            } else if (string.equals("dsthost")) {
                String string7 = stringTokenizer.nextToken();
                lEIPXRule.setField("dst_host", string7);
            } else if (string.equals("dstsocket")) {
                String string8 = stringTokenizer.nextToken();
                String string9 = stringTokenizer.nextToken();
                lEIPXRule.setField("dst_cmp", string8);
                lEIPXRule.setField("dst_socket", string9);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.parseIPXOptions(lEIPXRule, stringTokenizer);
    }

    protected void parseSAPRule(LESAPRule lESAPRule, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            lESAPRule.initialize(string);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            this.parseSAPOptions(lESAPRule, stringTokenizer);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void parseSAPOptions(LESAPRule lESAPRule, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        try {
            String string = stringTokenizer.nextToken().toLowerCase();
            if (string.equals("server")) {
                String string2 = stringTokenizer.nextToken();
                lESAPRule.setField("server", string2);
            } else if (string.equals("network")) {
                String string3 = stringTokenizer.nextToken();
                lESAPRule.setField("network", string3);
            } else if (string.equals("host")) {
                String string4 = stringTokenizer.nextToken();
                lESAPRule.setField("host", string4);
            } else if (string.equals("socket")) {
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                lESAPRule.setField("cmp", string5);
                lESAPRule.setField("socket", string6);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.parseSAPOptions(lESAPRule, stringTokenizer);
    }
}

