/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LEIPPanel;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.PropertyResourceBundle;

public class LELocDestinationPage
extends LEWizardDataPage
implements ItemListener {
    static final String INC_IPADDRESS = new String("The Internet address is incomplete.");
    private static final String INSTRUCTION_TAG = "DESTINATION_INST";
    private static final String HELP_TAG = "";
    Checkbox m_specified;
    Checkbox m_negotiated;
    LEIPPanel m_destination;
    LEIPPanel m_mask;
    Label m_addr_label;
    Label m_mask_label;
    static LEVector s_template_keys;

    public LELocDestinationPage(LEWizardDataModel model) {
        super(model);
        this.setTitle(" Destination");
        this.setImage("wiz.gif");
        PropertyResourceBundle resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setResourceInstructions(resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_component = new Label("Select the destination address type: ");
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        CheckboxGroup dest_type = new CheckboxGroup();
        this.m_specified = new Checkbox("Specified", true, dest_type);
        this.m_specified.addItemListener(this);
        this.m_panel.add((Component)this.m_specified, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_negotiated = new Checkbox("Negotiated", false, dest_type);
        this.m_negotiated.addItemListener(this);
        this.m_panel.add((Component)this.m_negotiated, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_addr_label = new Label("Enter the specified address:");
        this.m_panel.add((Component)this.m_addr_label, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_destination = new LEIPPanel(HELP_TAG);
        this.m_panel.add((Component)this.m_destination, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_mask_label = new Label("Enter the netmask:");
        this.m_panel.add((Component)this.m_mask_label, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_mask = new LEIPPanel(this.m_model.get(LEPMWizardModel.DEST_NETMASK));
        this.m_panel.add((Component)this.m_mask, this.m_gbc);
        String dest = this.m_model.get(LEPMWizardModel.DEST_ADDRESS);
        if (dest.equals("255.255.255.255")) {
            this.m_negotiated.setState(true);
            this.m_addr_label.setEnabled(false);
            this.m_destination.setEnabled(false);
            this.m_mask_label.setEnabled(false);
            this.m_mask.setEnabled(false);
        } else {
            this.m_destination.setAddress(dest);
        }
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        if (this.m_negotiated.getState()) {
            this.m_model.set(LEPMWizardModel.DEST_ADDRESS, "255.255.255.255");
            this.m_model.set(LEPMWizardModel.DEST_NETMASK, "0.0.0.0");
        } else {
            String address = this.m_destination.getAddress();
            if (address.equals(HELP_TAG)) {
                this.m_problem = INC_IPADDRESS;
                return false;
            }
            this.m_model.set(LEPMWizardModel.DEST_ADDRESS, this.m_destination.getAddress());
            this.m_model.set(LEPMWizardModel.DEST_NETMASK, this.m_mask.getAddress());
        }
        return true;
    }

    public void itemStateChanged(ItemEvent event) {
        this.m_addr_label.setEnabled(this.m_specified.getState());
        this.m_destination.setEnabled(this.m_specified.getState());
        this.m_mask_label.setEnabled(this.m_specified.getState());
        this.m_mask.setEnabled(this.m_specified.getState());
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("destination");
            s_template_keys.add("netmask");
        }
        return s_template_keys;
    }
}

