/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMOpFailureException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LESendResponse;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import java.io.BufferedReader;
import java.io.IOException;

class LEDSSPMTftpUpgrade {
    static final int TIMEOUT = 80000;
    static final short FILE_WRITESIZE = 256;
    LEStatusManager m_status;
    static final int StateInit = 1;
    static final int StateFindEOL = 2;
    static final int StateComment = 3;
    static final int StateDatafile = 4;
    static final int StateCommand = 5;
    static final int StateDone = 6;
    static final String DatafileStart = "file";
    static final String DatafileEnd = "end";
    LEDSSPortMaster m_dss;
    BufferedReader m_reader;
    int m_state;
    byte[] m_workBuffer;
    byte[] m_dataBuffer;
    byte[] m_sendBuffer;
    String m_fileName;
    short m_sendCount;
    int m_fileCount;

    static byte Dec(int c) {
        return (byte)(c - 32 & 0x3F);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] decodeBytes(byte[] inbuf) {
        count = 0;
        p = 0;
        if ((n = LEDSSPMTftpUpgrade.Dec(inbuf[p++])) > 0) ** GOTO lbl13
        return new byte[0];
lbl-1000:
        // 1 sources

        {
            if (n >= 1) {
                this.m_workBuffer[count++] = (byte)(LEDSSPMTftpUpgrade.Dec(inbuf[p++]) << 2 | LEDSSPMTftpUpgrade.Dec(inbuf[p]) >> 4);
            }
            if (n >= 2) {
                this.m_workBuffer[count++] = (byte)(LEDSSPMTftpUpgrade.Dec(inbuf[p++]) << 4 | LEDSSPMTftpUpgrade.Dec(inbuf[p]) >> 2);
            }
            if (n >= 3) {
                this.m_workBuffer[count++] = (byte)(LEDSSPMTftpUpgrade.Dec(inbuf[p++]) << 6 | LEDSSPMTftpUpgrade.Dec(inbuf[p]));
            }
            n -= 3;
            ++p;
lbl13:
            // 2 sources

            ** while (n > 0)
        }
lbl14:
        // 1 sources

        outbuf = new byte[count];
        System.arraycopy(this.m_workBuffer, 0, outbuf, 0, count);
        return outbuf;
    }

    LEDSSPMTftpUpgrade(LEDSSPortMaster pm, BufferedReader in, LEStatusManager status) {
        this.m_dss = pm;
        this.m_reader = in;
        this.m_sendBuffer = new byte[256];
        this.m_workBuffer = new byte[256];
        this.m_sendCount = 0;
        this.m_fileCount = 0;
        this.m_status = status;
    }

    void doTftpUpgrade() throws LEDSSException {
        String sBuf = null;
        int Count = 25;
        this.m_state = 1;
        try {
            int counter = 0;
            while ((sBuf = this.m_reader.readLine()) != null) {
                byte[] buf = sBuf.getBytes();
                if (buf.length == 0) continue;
                switch (this.m_state) {
                    case 4: {
                        if (sBuf.regionMatches(0, DatafileEnd, 0, 3)) {
                            this.flush((byte)6);
                            this.send((byte)6, (short)0, this.m_dataBuffer);
                            this.dumpLogV("End of file " + this.m_fileName + " " + Integer.toString(this.m_fileCount) + " bytes");
                            this.m_status.setStatus("Finished file " + this.m_fileName, 0);
                            this.m_state = 5;
                            this.m_sendCount = 0;
                            this.m_fileCount = 0;
                            counter = 0;
                            break;
                        }
                        if (++counter % Count == 0) {
                            this.m_status.setStatus(counter / Count);
                        }
                        this.m_dataBuffer = this.decodeBytes(buf);
                        this.queue((byte)6, this.m_dataBuffer.length, this.m_dataBuffer);
                        break;
                    }
                    default: {
                        char[] name;
                        if (buf[0] == 35 || buf[0] == 33) {
                            String comment;
                            name = new char[sBuf.length()];
                            if (sBuf.length() > 1) {
                                sBuf.getChars(1, sBuf.length(), name, 0);
                                comment = new String(name);
                            } else {
                                comment = "";
                            }
                            this.m_status.setStatus(comment);
                            this.dumpLogV("Comment: " + comment);
                            break;
                        }
                        if (sBuf.regionMatches(0, DatafileStart, 0, 3)) {
                            name = new char[sBuf.length()];
                            this.m_state = 4;
                            sBuf.getChars(DatafileStart.length() + 1, sBuf.length(), name, 0);
                            this.m_fileName = new String(name);
                            this.send((byte)5, this.m_fileName);
                            this.m_sendCount = 0;
                            this.m_fileCount = 0;
                            this.dumpLogV("File: " + this.m_fileName);
                            this.m_status.setStatus("Downloading file " + this.m_fileName);
                            break;
                        }
                        this.dumpLogV("Command: " + sBuf);
                        this.m_status.setStatus("Command: " + sBuf);
                        this.m_dss.execute(sBuf, 80000);
                    }
                }
            }
        }
        catch (IOException xc) {
            this.dumpLogV("doTftpUpgrade Exception: " + xc.getClass().getName());
            String msg = "Upgrade failed";
            if (xc.getMessage() != null) {
                msg = String.valueOf(msg) + ": " + xc.getMessage();
            }
            throw new LEDSSException(xc, msg);
        }
    }

    void flush(byte cmd) throws LEDSSException, IOException {
        if (this.m_sendCount > 0) {
            this.send(cmd, this.m_sendCount, this.m_sendBuffer);
        }
        this.m_sendCount = 0;
    }

    void queue(byte cmd, int len, byte[] data) throws LEDSSException, IOException {
        this.dumpLogV("Queue'ing more data: " + len);
        if (this.m_sendCount + len > 256) {
            short remainder = (short)(this.m_sendCount + len - 256);
            System.arraycopy(data, 0, this.m_sendBuffer, this.m_sendCount, 256 - this.m_sendCount);
            this.send(cmd, (short)256, this.m_sendBuffer);
            System.arraycopy(data, 256 - this.m_sendCount, this.m_sendBuffer, 0, remainder);
            this.m_sendCount = remainder;
        } else {
            System.arraycopy(data, 0, this.m_sendBuffer, this.m_sendCount, len);
            this.m_sendCount = (short)(this.m_sendCount + len);
        }
    }

    void send(byte cmd, String data) throws LEDSSException, IOException {
        byte[] dst = data.getBytes();
        this.send(cmd, (short)data.length(), dst);
    }

    void send(byte cmd, short len, byte[] data) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Sending " + LEDSSPortMaster.GetOpCodeString(cmd) + " Length: " + Integer.toString(len) + " bytes");
        LESendResponse resp = this.m_dss.send(cmd, len, data, false, 80000);
        if (!resp.successful()) {
            this.dumpLogV("TFTP Upgrade: Data Send Failed");
            throw new LEDSSPMOpFailureException("Data Send Failed: " + LEDSSPortMaster.GetOpCodeString(cmd));
        }
        this.dumpLogV("TFTP Upgrade: Data Send Succeeded");
        this.m_fileCount += len;
    }

    void dump(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        int ii = 0;
        while (ii < len) {
            if (data[ii] == 0) break;
            if ((short)(data[ii] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Integer.toString((short)(data[ii] & 0xFF), 16));
            sb.append(' ');
            if (sb.length() > 60) {
                this.dumpLogV(sb.toString());
                sb = new StringBuffer();
            }
            ++ii;
        }
        if (sb.length() > 0) {
            this.dumpLogV(sb.toString());
        }
    }

    protected final synchronized void dumpLogV(String msg) {
        LEDebug.getLog().logln(40, msg);
    }
}

