/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDataSpec;
import COM.livingston.util.LEAlphaNumericCompare;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEConfig
extends LEObservable
implements Cloneable {
    public static final String BLANK = "";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String FALSE = "false";
    public static final String OFF = "off";
    public static final String ON = "on";
    public static final String SPACE = " ";
    public static final String TRUE = "true";
    public static final String ADD = "add ";
    public static final String DELETE = "delete ";
    public static final String REBOOT = "reboot";
    public static final String SAVE_ALL = "save all";
    public static final String SET = "set ";
    public static final String SET_VIEW = "set view ";
    public static final String VERSION = "version";
    LEConfigFacility m_facility;
    String m_board;
    Hashtable m_fields = new Hashtable();
    LEDataSpec m_spec;
    LEConfig m_owner;
    String m_fetchKey;
    boolean m_fetched;
    LEVector m_changed;
    LEVector m_added;
    LEVector m_deleted;

    public LEConfig(LEConfigFacility lEConfigFacility, String string, String string2) {
        this.m_facility = lEConfigFacility;
        this.m_board = string;
        this.m_fetchKey = string2;
    }

    public LEConfig(LEConfigFacility lEConfigFacility, String string) {
        this(lEConfigFacility, string, null);
        this.m_fetched = true;
    }

    public LEConfig(LEConfigFacility lEConfigFacility) {
        this(lEConfigFacility, null, null);
        this.m_fetched = true;
    }

    public Object clone() {
        LEConfig lEConfig = new LEConfig(this.m_facility);
        lEConfig.copy(this);
        return lEConfig;
    }

    public void copy(LEConfig lEConfig) {
        Object object;
        String string;
        LEVector lEVector = this.getKeys();
        LEVector lEVector2 = lEConfig.getKeys();
        int n = lEVector2.size();
        int n2 = 0;
        while (n2 < n) {
            string = (String)lEVector2.elementAt(n2);
            object = lEConfig.get(string);
            if (object instanceof LEConfig) {
                LEConfig lEConfig2 = (LEConfig)this.get(string);
                if (lEConfig2 == null) {
                    lEConfig2 = this.getConfig(string);
                    if (this.m_added == null) {
                        this.m_added = new LEVector();
                    }
                    this.m_added.addUnique(string);
                }
                lEConfig2.copy((LEConfig)object);
            } else {
                Object object2 = this.get(string);
                if (object2 == null || !object2.equals(object)) {
                    this.set(string, object);
                }
            }
            ++n2;
        }
        n = lEVector.size();
        int n3 = 0;
        while (n3 < n) {
            string = (String)lEVector.elementAt(n3);
            if (!lEVector2.contains(string) && (object = this.get(string)) instanceof LEConfig) {
                if (this.m_deleted == null) {
                    this.m_deleted = new LEVector();
                }
                this.m_deleted.addUnique(string);
                this.remove(string);
            }
            ++n3;
        }
    }

    public LEVector getKeys() {
        if (!this.m_fetched) {
            this.fetch();
        }
        LEVector lEVector = new LEVector();
        Enumeration enumeration = this.m_fields.keys();
        while (enumeration.hasMoreElements()) {
            lEVector.addElement((String)enumeration.nextElement());
        }
        lEVector.quickSort(new LEAlphaNumericCompare());
        return lEVector;
    }

    public LEConfigFacility getConfigFacility() {
        return this.m_facility;
    }

    public LEConfig getOwner() {
        return this.m_owner;
    }

    public boolean requiresReboot(String string) {
        return false;
    }

    public boolean requiresPowerCycle(String string) {
        return false;
    }

    public boolean hasChanges() {
        if (this.m_added != null || this.m_deleted != null || this.m_changed != null) {
            return true;
        }
        boolean bl = false;
        LEVector lEVector = this.getKeys();
        int n = lEVector.size();
        int n2 = 0;
        while (!bl && n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            Object object = this.get(string);
            if (object instanceof LEConfig) {
                bl = ((LEConfig)object).hasChanges();
            }
            ++n2;
        }
        return bl;
    }

    public void clearChangeVectors() {
        if (this.m_added != null) {
            this.m_added.removeAllElements();
            this.m_added = null;
        }
        if (this.m_changed != null) {
            this.m_changed.removeAllElements();
            this.m_changed = null;
        }
        if (this.m_deleted != null) {
            this.m_deleted.removeAllElements();
            this.m_deleted = null;
        }
        LEVector lEVector = this.getKeys();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            Object object = this.get(string);
            if (object instanceof LEConfig) {
                ((LEConfig)object).clearChangeVectors();
            }
            ++n2;
        }
    }

    public Object get(String string) {
        if (!this.m_fetched) {
            this.fetch();
        }
        return this.m_fields.get(string);
    }

    public boolean getChanges(LEVector lEVector) {
        boolean bl = this.getChangedCommands(lEVector);
        if (bl) {
            lEVector.addElement(SAVE_ALL);
        }
        return bl;
    }

    public boolean getCommands(LEVector lEVector) {
        boolean bl = this.getAllCommands(lEVector);
        if (bl) {
            lEVector.addElement(SAVE_ALL);
        }
        return bl;
    }

    public void set(String string, Object object) {
        if (object instanceof LEConfig) {
            if (this.m_added == null) {
                this.m_added = new LEVector();
            }
            this.m_added.addUnique(string);
            ((LEConfig)object).setConfigFacility(this.m_facility);
        } else {
            if (this.m_changed == null) {
                this.m_changed = new LEVector();
            }
            this.m_changed.addUnique(string);
        }
        this.m_fields.put(string, object);
        if (object instanceof LEConfig) {
            ((LEConfig)object).setOwner(this);
        }
        this.setChanged();
        this.notifyObservers(string);
    }

    public void setConfigFacility(LEConfigFacility lEConfigFacility) {
        this.m_facility = lEConfigFacility;
        LEVector lEVector = this.getKeys();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            Object object = this.get(string);
            if (object instanceof LEConfig) {
                ((LEConfig)object).setConfigFacility(lEConfigFacility);
            }
            ++n2;
        }
    }

    public void setOwner(LEConfig lEConfig) {
        this.m_owner = lEConfig;
    }

    public void refresh() {
        this.refresh(this);
    }

    public LEVector saveChanges() {
        return this.saveChanges(true);
    }

    public LEVector saveChanges(boolean bl) {
        LEVector lEVector = null;
        LEVector lEVector2 = new LEVector();
        if (this.getChanges(lEVector2)) {
            int n = lEVector2.size();
            int n2 = 0;
            while (n2 < n) {
                LEPMCommand lEPMCommand;
                String string = (String)lEVector2.elementAt(n2);
                if (!(!bl && (LEPMCommand.IsReboot(string) || LEPMCommand.IsPowerOff(string) || LEPMCommand.IsPowerOn(string)) || (lEPMCommand = this.m_facility.execute(string)).getStatus())) {
                    if (lEVector == null) {
                        lEVector = new LEVector();
                    }
                    lEVector.addElement(lEPMCommand);
                }
                ++n2;
            }
        }
        return lEVector;
    }

    public void setSpec(LEDataSpec lEDataSpec) {
        this.m_spec = lEDataSpec;
    }

    public String getDescription() {
        String string = BLANK;
        if (this.m_spec != null) {
            string = this.m_spec.getDescription();
        }
        return string;
    }

    public LEDataSpec getSpec() {
        return this.m_spec;
    }

    public LEDataSpec getSpecFor(String string) {
        LEDataSpec lEDataSpec = null;
        if (this.m_spec != null) {
            lEDataSpec = this.m_spec.getSpecFor(string);
        }
        return lEDataSpec;
    }

    public String getDescriptionFor(String string) {
        String string2 = BLANK;
        LEDataSpec lEDataSpec = this.getSpecFor(string);
        if (lEDataSpec != null) {
            string2 = lEDataSpec.getDescription();
        }
        return string2;
    }

    public String getTypeFor(String string) {
        String string2 = BLANK;
        LEDataSpec lEDataSpec = this.getSpecFor(string);
        if (lEDataSpec != null) {
            string2 = lEDataSpec.getDescription();
        }
        return string2;
    }

    public Object getAttributeFor(String string, String string2) {
        Object object = null;
        LEDataSpec lEDataSpec = this.getSpecFor(string);
        if (lEDataSpec != null) {
            object = lEDataSpec.getAttribute(string2);
        }
        return object;
    }

    public boolean hasDependencies(String string) {
        boolean bl = false;
        LEDataSpec lEDataSpec = this.getSpecFor(string);
        if (lEDataSpec != null) {
            bl = lEDataSpec.hasDependencies();
        }
        return bl;
    }

    void markChanged() {
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
    }

    void refresh(LEConfig lEConfig) {
        if (this.m_fetchKey != null) {
            this.m_fetched = false;
            this.fetch();
            return;
        }
        if (this.m_owner != null) {
            this.m_owner.refresh(this);
        }
    }

    void fetch() {
        if (this.m_fetched) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Getting ");
        stringBuffer.append(this.getDescription());
        if (this.m_board != null) {
            stringBuffer.append(" for board ");
            stringBuffer.append(this.m_board);
        }
        stringBuffer.append(" from ");
        stringBuffer.append(this.m_facility.getDescription());
        LEStatusManager.SetStatus(stringBuffer.toString());
        this.m_fetched = true;
        if (this.m_board != null) {
            this.m_fetched = this.m_facility.getConfig(this.m_fetchKey, this.m_board);
            return;
        }
        this.m_fetched = this.m_facility.getConfig(this.m_fetchKey);
    }

    Object remove(String string) {
        Object v = this.m_fields.remove(string);
        this.setChanged();
        this.notifyObservers(string);
        return v;
    }

    boolean getChangedCommands(LEVector lEVector) {
        LEVector lEVector2;
        if (lEVector == null) {
            return false;
        }
        boolean bl = false;
        if (this.m_changed != null || this.m_added != null || this.m_deleted != null) {
            bl = this.makeViewCommand(lEVector);
            if (this.m_changed != null) {
                bl = this.generateCommands(this.m_changed, lEVector);
                this.m_changed.removeAllElements();
                this.m_changed = null;
            }
            if (this.m_deleted != null) {
                bl |= this.getDeleteCommands(lEVector);
            }
        }
        if ((lEVector2 = this.getChildren()) != null) {
            int n = lEVector2.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)lEVector2.elementAt(n2);
                if (this.m_added != null && this.m_added.contains(string)) {
                    bl |= this.generateAddCommand(string, lEVector);
                }
                LEConfig lEConfig = (LEConfig)this.get(string);
                bl |= lEConfig.getChangedCommands(lEVector);
                ++n2;
            }
            if (this.m_added != null) {
                this.m_added.removeAllElements();
                this.m_added = null;
            }
        }
        return bl;
    }

    boolean getDeleteCommands(LEVector lEVector) {
        boolean bl = false;
        int n = this.m_deleted.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.m_deleted.elementAt(n2);
            bl |= this.generateDeleteCommand(string, lEVector);
            ++n2;
        }
        this.m_deleted.removeAllElements();
        this.m_deleted = null;
        return bl;
    }

    boolean getAllCommands(LEVector lEVector) {
        if (lEVector == null) {
            return false;
        }
        boolean bl = this.makeViewCommand(lEVector);
        bl |= this.generateCommands(null, lEVector);
        LEVector lEVector2 = this.getChildren();
        if (lEVector2 != null) {
            int n = lEVector2.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)lEVector2.elementAt(n2);
                bl |= this.generateAddCommand(string, lEVector);
                LEConfig lEConfig = (LEConfig)this.get(string);
                bl |= lEConfig.getAllCommands(lEVector);
                ++n2;
            }
        }
        return bl;
    }

    LEVector getChildren() {
        LEVector lEVector = null;
        LEVector lEVector2 = this.getKeys();
        int n = lEVector2.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector2.elementAt(n2);
            Object object = this.get(string);
            if (object instanceof LEConfig) {
                if (lEVector == null) {
                    lEVector = new LEVector();
                }
                lEVector.addElement(string);
            }
            ++n2;
        }
        return lEVector;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        return false;
    }

    boolean generateDeleteCommand(String string, LEVector lEVector) {
        return false;
    }

    boolean generateAddCommand(String string, LEVector lEVector) {
        return false;
    }

    void setField(String string, Object object) {
        if (this.m_changed != null && this.m_changed.contains(string)) {
            return;
        }
        this.m_fields.put(string, object);
        this.setChanged();
        this.notifyObservers(string);
    }

    LEConfig getConfig(String string) {
        Object v = this.m_fields.get(string);
        if (v instanceof LEConfig) {
            return (LEConfig)v;
        }
        LEConfig lEConfig = this.createConfig(string);
        lEConfig.setSpec(this.getSpecFor(string));
        lEConfig.setOwner(this);
        this.setField(string, lEConfig);
        return lEConfig;
    }

    LEConfig createConfig(String string) {
        return new LEConfig(this.m_facility);
    }

    boolean makeAddCommand(LEVector lEVector, String string, String string2, String string3) {
        return this.makeCommand(ADD, lEVector, string, string2, string3);
    }

    boolean makeDeleteCommand(LEVector lEVector, String string, String string2, String string3) {
        return this.makeCommand(DELETE, lEVector, string, string2, string3);
    }

    boolean makeSetCommand(LEVector lEVector, String string, String string2, String string3) {
        return this.makeCommand(SET, lEVector, string, string2, string3);
    }

    boolean makeCommand(String string, LEVector lEVector, String string2, String string3, String string4) {
        boolean bl = false;
        Object object = this.get(string3);
        if (object instanceof String) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(SPACE);
            }
            if (string4 != null) {
                stringBuffer.append(string4);
                stringBuffer.append(SPACE);
            }
            stringBuffer.append((String)object);
            lEVector.addElement(new String(stringBuffer));
            bl = true;
        }
        return bl;
    }

    boolean makeRIPCommand(LEVector lEVector, String string, String string2, String string3, String string4) {
        boolean bl = false;
        boolean bl2 = false;
        if (string3 != null && string3.equals(ON)) {
            bl = true;
        }
        if (string4 != null && string4.equals(ON)) {
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(SET);
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(SPACE);
        }
        stringBuffer.append(string2);
        stringBuffer.append(SPACE);
        if (bl && bl2) {
            stringBuffer.append(ON);
        } else if (bl) {
            stringBuffer.append("broadcast");
        } else if (bl2) {
            stringBuffer.append("listen");
        } else {
            stringBuffer.append(OFF);
        }
        lEVector.addElement(new String(stringBuffer));
        return true;
    }

    boolean makeServiceCommand(LEVector lEVector, String string, String string2, String string3) {
        if (string2 == null) {
            return false;
        }
        String string4 = (String)this.get(string2);
        if (string4 == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(SET);
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(SPACE);
        }
        if (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append(SPACE);
        }
        stringBuffer.append(string4.replace('@', ' '));
        lEVector.addElement(new String(stringBuffer));
        return true;
    }

    boolean makeNATTimeOutCommand(LEVector lEVector, String string, String string2, String string3) {
        String string4 = (String)this.get(string3);
        if (string4 == null || string4.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(SET);
        stringBuffer.append(string);
        stringBuffer.append(" nat sto ");
        if (string2.equals("353")) {
            stringBuffer.append("tcp ");
        } else if (string2.equals("354")) {
            stringBuffer.append("other ");
        } else {
            return false;
        }
        stringBuffer.append(string4);
        lEVector.addElement(new String(stringBuffer));
        return true;
    }

    boolean makeNATFailActionCommand(LEVector lEVector, String string, String string2) {
        String string3 = (String)this.get(string2);
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(SET);
        stringBuffer.append(string);
        stringBuffer.append(" nat sdfa ");
        stringBuffer.append(string3);
        lEVector.addElement(new String(stringBuffer));
        return true;
    }

    boolean makeNATLogCommand(LEVector lEVector, String string, String string2, String string3) {
        String string4 = (String)this.get(string3);
        if (string4 == null || string4.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(SET);
        stringBuffer.append(string);
        stringBuffer.append(" nat log ");
        if (string2.equals("360")) {
            stringBuffer.append("sessionfail ");
        } else if (string2.equals("361")) {
            stringBuffer.append("sessionsuccess ");
        } else if (string2.equals("362")) {
            stringBuffer.append("syslog ");
        } else if (string2.equals("363")) {
            stringBuffer.append("console ");
        } else {
            return false;
        }
        stringBuffer.append(string4);
        lEVector.addElement(new String(stringBuffer));
        return true;
    }

    boolean makeNATMapCommand(LEVector lEVector, String string, String string2, boolean bl, boolean bl2) {
        String string3 = (String)this.get(string2);
        if (string3 == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(SET);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" nat inmap ");
        } else {
            stringBuffer.append(" nat outmap ");
        }
        stringBuffer.append(string3);
        if (bl2) {
            stringBuffer.append(" proxy");
        }
        lEVector.addElement(new String(stringBuffer));
        return true;
    }

    boolean makeViewCommand(LEVector lEVector) {
        String string = this.getViewCommand();
        if (string != null) {
            lEVector.addElement(string);
            return true;
        }
        return false;
    }

    boolean makePowerCycleCommands(LEVector lEVector) {
        if (this.m_board == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(SET_VIEW);
        stringBuffer.append('4');
        lEVector.addElement(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append(SET);
        stringBuffer.append("slot");
        stringBuffer.append(this.m_board);
        stringBuffer.append(SPACE);
        stringBuffer.append(OFF);
        lEVector.addElement(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append(SET);
        stringBuffer.append("slot");
        stringBuffer.append(this.m_board);
        stringBuffer.append(SPACE);
        stringBuffer.append(ON);
        lEVector.addElement(stringBuffer.toString());
        return true;
    }

    LEPMCommand setView() {
        String string = this.getViewCommand();
        if (string != null) {
            return this.m_facility.execute(string);
        }
        return null;
    }

    String getViewCommand() {
        String string = null;
        if (this.m_board != null) {
            StringBuffer stringBuffer = new StringBuffer(11);
            stringBuffer.append(SET_VIEW);
            stringBuffer.append(this.m_board);
            string = stringBuffer.toString();
        }
        return string;
    }

    void updateSaveStatus(String string, int n, int n2) {
        int n3 = 0;
        if (n > 0) {
            n3 = n2 / n * 100;
        }
    }

    String getKeyFor(LEConfig lEConfig) {
        String string = null;
        LEVector lEVector = this.getKeys();
        int n = lEVector.size();
        int n2 = 0;
        while (string == null && n2 < n) {
            string = (String)lEVector.elementAt(n2);
            if (lEConfig != this.get(string)) {
                string = null;
            }
            ++n2;
        }
        return string;
    }
}

