/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFilterRule;
import COM.livingston.util.LEVector;

public class LEIPXRule
extends LEFilterRule {
    public static final String ACTION = "action";
    public static final String DST_COMPARE = "dst_cmp";
    public static final String DST_HOST = "dst_host";
    public static final String DST_NET = "dst_net";
    public static final String DST_SOCKET = "dst_socket";
    public static final String SRC_COMPARE = "src_cmp";
    public static final String SRC_HOST = "src_host";
    public static final String SRC_NET = "src_net";
    public static final String SRC_SOCKET = "src_socket";
    public static final int KEY_COUNT = 9;
    public static final String DENY = "deny";
    public static final String PERMIT = "permit";
    public static final String COMPARE_EQ = "eq";
    public static final String COMPARE_GT = "gt";
    public static final String COMPARE_LT = "lt";
    static final String DEFAULT_NUM = "1";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[9];
            LEIPXRule.s_keys[0] = ACTION;
            LEIPXRule.s_keys[1] = DST_COMPARE;
            LEIPXRule.s_keys[2] = DST_HOST;
            LEIPXRule.s_keys[3] = DST_NET;
            LEIPXRule.s_keys[4] = DST_SOCKET;
            LEIPXRule.s_keys[5] = SRC_COMPARE;
            LEIPXRule.s_keys[6] = SRC_HOST;
            LEIPXRule.s_keys[7] = SRC_NET;
            LEIPXRule.s_keys[8] = SRC_SOCKET;
        }
        return s_keys;
    }

    public LEIPXRule(LEConfigFacility lEConfigFacility, String string, String string2) {
        super(lEConfigFacility, string, string2);
    }

    public void initialize(String string) {
        this.setField(ACTION, string);
        this.setField(DST_COMPARE, "");
        this.setField(DST_HOST, "");
        this.setField(DST_NET, "");
        this.setField(DST_SOCKET, DEFAULT_NUM);
        this.setField(SRC_COMPARE, "");
        this.setField(SRC_HOST, "");
        this.setField(SRC_NET, "");
        this.setField(SRC_SOCKET, DEFAULT_NUM);
    }

    public Object clone() {
        LEIPXRule lEIPXRule = new LEIPXRule(this.m_facility, this.m_name, this.m_number);
        lEIPXRule.copy(this);
        return lEIPXRule;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        String string = (String)this.get(ACTION);
        if (this.m_name == null || this.m_number == null || string == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer("set ");
        stringBuffer.append("ipxfilter ");
        stringBuffer.append(this.m_name);
        stringBuffer.append(" ");
        stringBuffer.append(this.m_number);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        String string2 = (String)this.get(SRC_NET);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" srcnet ");
            stringBuffer.append(string2);
        }
        if ((string2 = (String)this.get(SRC_HOST)) != null && string2.length() > 0) {
            stringBuffer.append(" srchost ");
            stringBuffer.append(string2);
        }
        string2 = (String)this.get(SRC_COMPARE);
        String string3 = (String)this.get(SRC_SOCKET);
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            stringBuffer.append(" srcsocket ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string3);
        }
        if ((string2 = (String)this.get(DST_NET)) != null && string2.length() > 0) {
            stringBuffer.append(" dstnet ");
            stringBuffer.append(string2);
        }
        if ((string2 = (String)this.get(DST_HOST)) != null && string2.length() > 0) {
            stringBuffer.append(" dsthost ");
            stringBuffer.append(string2);
        }
        string2 = (String)this.get(DST_COMPARE);
        string3 = (String)this.get(DST_SOCKET);
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            stringBuffer.append(" dstsocket ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string3);
        }
        lEVector2.addElement(new String(stringBuffer));
        return true;
    }
}

