/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.bootp.LEBootPARPTableHandler;
import COM.livingston.bootp.LEBootPIPHandler;
import COM.livingston.bootp.LEBootPPacketHandler;
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEActionDialog;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEIPPanel;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LETextField;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEIPAddress;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;

public class LEIPDataPage
extends LEWizardDataPage
implements ActionListener,
LEActionClient,
LEConfirmClient {
    public static final String IP_DONE = new String("SetupIPDone");
    static final int MAX_CONNECT_ATTEMPTS = 30;
    static final String INC_IPADDRESS = new String("The Internet address is incomplete.");
    static final String BAD_IPADDRESS = new String("The Internet address is invalid.");
    static final String BAD_NETMASK = new String("The netmask is invalid.");
    static final String INC_NETMASK = new String("The netmask is incomplete");
    static final String BAD_MACADDRESS = new String("The MAC address has a bad format.  Use ##:##:## .");
    static final String NO_DEVICE = "Could not find the device with the specified IP Address.  Make sure the device is on the same subnet.";
    static final String BAD_PASSWORD_MSG = "You entered a wrong password for this device.";
    static final String NEED_ROOT = "You need to be root in order to set the Internet address from the Wizard!";
    static final String UNKNOWN_PROBLEM = "An unknown problem has occurred, please restart the wizard.";
    static final String SOCKET_EXCEPTION = "The BootP server could not start because another application is using the socket.";
    static final String SECURITY_EXCEPTION = "The BootP server could not start because you don't have the necessary privledges.";
    static final String CONNECTION_REFUSED = "Connection to the specified address was refused.";
    static final String CONFIG_PROBLEM = "Could not retrieve the configuration information.";
    static final String VENDOR_CODE = "00:c0:05:";
    static final int CONNECTED = 0;
    static final int NO_RESPONSE = -1;
    static final int BAD_PASSWORD = -2;
    static final int ROOT = -3;
    static final int NO_SOCKET = -4;
    static final int SECURITY = -5;
    static final int CONNECT_FAILURE = -6;
    static final int UNKNOWN_FAILURE = -20;
    private static final String INSTRUCTION_TAG = "IPDATA_BASIC_INST";
    private static final String ADV_INSTRUCTION_TAG = "IPDATA_ADVANCED_INST";
    private static final String HELP_TAG = "Internet_Address";
    private static final String TITLE_TAG = "IPDATA_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    Label m_infoText;
    LEIPPanel m_ippanel;
    LEIPPanel m_maskpanel;
    boolean m_connected;
    LEBootPPacketHandler m_ipHandler = null;
    LEActionDialog m_connectDlg;
    Frame m_topFrame = LEUiUtils.GetBaseFrame();
    LEStatusBar m_status;
    boolean m_canceled = false;
    LEStatusManager m_manager;
    LEPortMaster m_pm;
    LETextField m_macaddr;
    Label m_maclabel;
    Label m_livlabel;
    Panel m_macPanel;
    String m_basicInst;
    String m_advInst;
    static LEVector s_template_keys;
    PropertyResourceBundle m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);

    public LEIPDataPage(LEWizardDataModel model) {
        super(model);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.m_basicInst = this.m_instructions;
        this.m_advInst = this.m_resource.getString(ADV_INSTRUCTION_TAG);
        this.setHelpTag(HELP_TAG);
        this.m_infoText = null;
        this.m_connected = false;
        if (this.m_model.get(LEPMWizardModel.IPADDRESS) == null) {
            this.m_model.set(LEPMWizardModel.IPADDRESS, "");
        }
        if (this.m_model.get(LEPMWizardModel.NETMASK) == null) {
            this.m_model.set(LEPMWizardModel.NETMASK, "255.255.255.0");
        }
        if (this.m_model.get(LEPMWizardModel.MAC_ADDRESS) == null) {
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, "");
        }
    }

    public Panel createPanel() {
        super.createPanel();
        String level = this.m_model.get(LEPMWizardModel.WIZARD_LEVEL);
        String s = new String("Enter the Internet (IP) address: ");
        this.m_infoText = new Label(s);
        this.m_component = this.m_infoText;
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_ippanel = new LEIPPanel(this.m_model.get(LEPMWizardModel.IPADDRESS));
        this.m_component = this.m_ippanel;
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 20;
        s = new String("Enter the netmask:");
        this.m_component = new Label(s);
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_gbc.insets.top = 0;
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_maskpanel = new LEIPPanel(this.m_model.get(LEPMWizardModel.NETMASK));
        this.m_component = this.m_maskpanel;
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 20;
        return this.m_panel;
    }

    public Panel getPanel() {
        Panel panel = this.m_panel;
        String level = this.m_model.get(LEPMWizardModel.WIZARD_LEVEL);
        if (this.m_panel == null) {
            this.m_panel = panel = this.createPanel();
            panel.setLayout(this.m_gbl);
        }
        if (level.equals("Advanced")) {
            if (this.m_macPanel == null) {
                this.m_macPanel = this.createMacPanel();
                this.m_panel.add((Component)this.m_macPanel, this.m_gbc);
            }
            this.m_instructions = this.m_advInst;
        } else {
            if (this.m_macPanel != null) {
                this.m_panel.remove(this.m_macPanel);
                this.m_macPanel = null;
            }
            this.m_instructions = this.m_basicInst;
        }
        return panel;
    }

    public void setInstructions(String instructions) {
        this.m_instructions = this.m_basicInst = instructions;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        this.m_canceled = false;
        if (this.m_ippanel.getAddress().equals("0.0.0.0")) {
            this.m_problem = INC_IPADDRESS;
            return false;
        }
        if (this.m_maskpanel.getAddress().equals("0.0.0.0")) {
            this.m_problem = INC_NETMASK;
            return false;
        }
        if (!this.m_model.get(LEPMWizardModel.IPADDRESS).equals("0.0.0.0") && !this.m_ippanel.getAddress().equals(this.m_model.get(LEPMWizardModel.IPADDRESS))) {
            if (this.m_pm != null) {
                this.m_pm.disconnect();
            }
            this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            this.m_model.removeObject(LEPMWizardModel.PORTMASTER);
            this.m_connected = false;
            this.m_pm = null;
        }
        if (this.m_connected) {
            this.m_model.set(LEPMWizardModel.CONNECTED, "on");
            return true;
        }
        this.m_model.set(LEPMWizardModel.IPADDRESS, this.m_ippanel.getAddress());
        this.m_model.set(LEPMWizardModel.NETMASK, this.m_maskpanel.getAddress());
        String level = this.m_model.get(LEPMWizardModel.WIZARD_LEVEL);
        if (level.equals("Advanced")) {
            String macaddr = this.m_macaddr.getText();
            if (!this.processMacAddress(macaddr)) {
                this.m_problem = BAD_MACADDRESS;
                return false;
            }
        } else {
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, "");
        }
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals(IP_DONE)) {
            ActionEvent next_event = new ActionEvent(this, 1001, "next");
            ((ActionListener)((Object)this.m_topFrame)).actionPerformed(next_event);
        }
    }

    public void actionStart(LEActionDialog dlg) {
        this.m_status = dlg.getStatusBar();
        this.m_status.setStatusText("Connecting to device");
        this.setupPM();
        ((Component)this.m_connectDlg).setVisible(false);
    }

    public void actionDone(LEActionDialog dlg) {
        this.m_panel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void actionCancel(LEActionDialog dlg) {
        this.m_panel.setCursor(Cursor.getPredefinedCursor(0));
        this.m_canceled = true;
        if (this.m_pm != null) {
            this.m_pm.disconnect();
            this.m_pm = null;
        }
    }

    public void confirmAction(String action, Object data) {
    }

    public void cancelAction(Object data) {
    }

    private int runIPHandler() {
        try {
            String ip_address = this.m_model.get(LEPMWizardModel.IPADDRESS);
            String mac_address = this.m_model.get(LEPMWizardModel.MAC_ADDRESS);
            String broadcast_addr = LEIPAddress.determineBroadcastAddress(ip_address, this.m_model.get(LEPMWizardModel.NETMASK));
            InetAddress server_ip = InetAddress.getLocalHost();
            String server_addr = server_ip.getHostAddress();
            if (mac_address.equals("")) {
                this.m_ipHandler = new LEBootPIPHandler(ip_address, server_addr, broadcast_addr);
            } else {
                Hashtable<String, String> ip_table = new Hashtable<String, String>();
                ip_table.put(mac_address, ip_address);
                this.m_ipHandler = new LEBootPARPTableHandler(ip_table, server_addr, broadcast_addr);
            }
        }
        catch (SecurityException securityException) {
            return -5;
        }
        catch (SocketException socketException) {
            return -4;
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return -20;
        }
        return 0;
    }

    private void setupDialog() {
        this.m_manager = new LEStatusManager();
        this.m_connectDlg = new LEActionDialog(this.m_topFrame, "Connecting...", this, this.m_manager, true);
        Thread m_connectAction = new Thread(this.m_connectDlg);
        m_connectAction.start();
        this.m_panel.setCursor(Cursor.getPredefinedCursor(3));
        ((Component)this.m_connectDlg).setVisible(true);
    }

    private int connectToPM() {
        try {
            this.m_pm = new LEPortMaster(this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", this.m_model.get(LEPMWizardModel.ADMIN_PASSWORD));
            if (this.m_pm != null && this.m_pm.isConnected()) {
                this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
            }
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            try {
                this.m_pm = new LEPortMaster(this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", "");
                if (this.m_pm != null && this.m_pm.isConnected()) {
                    this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
                }
            }
            catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException2) {
                return -2;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                return -20;
            }
        }
        catch (LEDSSException e) {
            LEDebug.getLog().logln(20, e);
            return -20;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            return -1;
        }
        catch (ConnectException e) {
            LEDebug.getLog().logln(20, e);
            return -6;
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return -20;
        }
        if (this.m_model.getObject(LEPMWizardModel.PORTMASTER) == null) {
            this.m_connected = false;
            return -1;
        }
        this.m_connected = true;
        return 0;
    }

    private void setupPM() {
        try {
            int status = this.connectToPM();
            if (status == -1) {
                int attempts = 0;
                if (LEAppInfo.isUnix()) {
                    String name = System.getProperty("user.name");
                    if (name.equals("root")) {
                        int bootpStatus = this.runIPHandler();
                        if (bootpStatus < 0) {
                            status = bootpStatus;
                            attempts = 30;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(15000L);
                        }
                        catch (Exception exception) {}
                    } else {
                        status = -3;
                        attempts = 30;
                    }
                } else {
                    int bootpStatus = this.runIPHandler();
                    if (bootpStatus < 0) {
                        status = bootpStatus;
                        attempts = 30;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(15000L);
                    }
                    catch (Exception exception) {}
                }
                while (attempts < 30) {
                    this.m_status.setStatusText("Setting the unit's ipaddress and then connecting...");
                    ++attempts;
                    status = this.connectToPM();
                    if (status != 0) continue;
                    attempts = 30;
                }
            }
            switch (status) {
                case 0: {
                    this.m_status.setStatusText("Connected, getting configuration...");
                    if (!this.m_model.getModelInfo()) {
                        this.m_status.setStatusText("Could not get configuration!");
                        System.out.println("Problem with configuration");
                        this.m_problem = CONFIG_PROBLEM;
                    }
                    break;
                }
                case -2: {
                    this.m_status.setStatusText("Incorrect password");
                    this.m_problem = BAD_PASSWORD_MSG;
                    break;
                }
                case -3: {
                    this.m_problem = NEED_ROOT;
                    break;
                }
                case -5: {
                    this.m_problem = SECURITY_EXCEPTION;
                    break;
                }
                case -4: {
                    this.m_problem = SOCKET_EXCEPTION;
                    break;
                }
                case -6: {
                    this.m_problem = CONNECTION_REFUSED;
                    break;
                }
                case -20: {
                    this.m_problem = NO_DEVICE;
                    break;
                }
                default: {
                    this.m_problem = UNKNOWN_PROBLEM;
                    break;
                }
            }
        }
        catch (Exception e) {
            this.m_status.setStatusText("Could not connect.");
            LEDebug.getLog().logln(20, e);
        }
        if (this.m_ipHandler != null) {
            this.m_ipHandler.disconnect();
        }
    }

    private Panel createMacPanel() {
        Panel toppanel = new Panel(new GridLayout(2, 1, 0, 0));
        this.m_maclabel = new Label("Optionally, enter the MAC address of your PortMaster");
        toppanel.add(this.m_maclabel);
        Panel macpanel = new Panel(new FlowLayout(0, 0, 0));
        this.m_livlabel = new Label(VENDOR_CODE);
        macpanel.add(this.m_livlabel);
        this.m_macaddr = new LETextField(8);
        macpanel.add(this.m_macaddr);
        toppanel.add(macpanel);
        return toppanel;
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("ether0 address");
            s_template_keys.add("ether0 netmask");
        }
        return s_template_keys;
    }

    private boolean processMacAddress(String macaddr) {
        if (!macaddr.equals("")) {
            String mac = "";
            StringTokenizer mactok = new StringTokenizer(macaddr, ":-");
            int count = mactok.countTokens();
            if (count == 3) {
                mac = macaddr.replace('-', ':');
            } else if (count == 1 && macaddr.length() == 6) {
                char[] macarray = macaddr.toCharArray();
                StringBuffer macbuffer = new StringBuffer();
                int i = 0;
                while (i < 6) {
                    char mac_char = macarray[i];
                    if (Character.isDigit(mac_char)) {
                        macbuffer.append(mac_char);
                    } else if (Character.isLetter(mac_char)) {
                        mac_char = Character.toLowerCase(mac_char);
                        macbuffer.append(mac_char);
                    } else {
                        return false;
                    }
                    if (i == 1 || i == 3) {
                        macbuffer.append(':');
                    }
                    ++i;
                }
                mac = macbuffer.toString();
            } else {
                return false;
            }
            int len = mac.length();
            int g_value = Character.getNumericValue('g');
            char[] letterarray = mac.toCharArray();
            int i = 0;
            while (i < len) {
                int char_value;
                char letter = letterarray[i];
                if (letter != ':' && !Character.isDigit(letter) && (char_value = Character.getNumericValue(letter)) >= g_value) {
                    return false;
                }
                ++i;
            }
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, VENDOR_CODE + mac);
        } else {
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, "");
        }
        return true;
    }
}

