/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEPMEntityParser;
import COM.livingston.model.LEPMOldParser;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;

public class LEPMConfigFacility
implements LEConfigFacility,
Runnable {
    LEPortMaster m_pm;
    Thread m_thread;

    public LEPMConfigFacility(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
    }

    public String getDescription() {
        return this.m_pm.getHostname();
    }

    public boolean getConfig(String string) {
        return this.getConfig(string, null);
    }

    public boolean getConfig(String string, String string2) {
        LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
        if (lEDSSPortMaster == null) {
            return false;
        }
        boolean bl = false;
        if (string2 == null) {
            if (lEDSSPortMaster.supportsEntities() && (!string.equals("2162688") || this.globalEntityOkay())) {
                bl = LEPMEntityParser.Parse(string, lEDSSPortMaster, this.m_pm);
            }
            if (!bl) {
                bl = LEPMOldParser.Parse(string, lEDSSPortMaster, this.m_pm);
            }
        } else if (lEDSSPortMaster.supportsEntities()) {
            bl = LEPMEntityParser.Parse(string, string2, lEDSSPortMaster, this.m_pm);
        }
        return bl;
    }

    public boolean getUserPasswords() {
        if (!this.m_pm.supports(0x310000)) {
            return false;
        }
        LEConfig lEConfig = (LEConfig)this.m_pm.get("1835008");
        if (lEConfig == null) {
            return true;
        }
        String string = Integer.toString(0x310000);
        return LEPMEntityParser.Parse(this.m_pm.getDSS(), lEConfig, string, string);
    }

    public boolean getSecrets() {
        if (!this.m_pm.supports(0x320000)) {
            return false;
        }
        this.m_pm.get("2228224");
        this.m_pm.get("1507328");
        String string = Integer.toString(0x320000);
        return LEPMEntityParser.Parse(this.m_pm.getDSS(), this.m_pm, string, string);
    }

    public LEPMCommand execute(String string) {
        String string2;
        LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
        if (lEDSSPortMaster == null) {
            return null;
        }
        LEStatusManager.SetStatus(string);
        LEPMCommand lEPMCommand = lEDSSPortMaster.execute(string);
        if (LEPMCommand.IsReboot(string) && (string2 = this.m_pm.getHardwareType()) != null && string2.equals("PM-4")) {
            this.checkForBoards();
        }
        if (LEPMCommand.IsPowerOn(string) && this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
        return lEPMCommand;
    }

    public void run() {
        try {
            this.checkForBoards();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_thread = null;
    }

    void checkForBoards() {
        LEBoards lEBoards = (LEBoards)this.m_pm.get("2555904");
        if (lEBoards == null) {
            return;
        }
        LEVector lEVector = lEBoards.getKeys();
        int n = lEVector.size();
        boolean bl = true;
        while (bl) {
            lEBoards.refresh();
            bl = false;
            int n2 = 0;
            while (!bl && n2 < n) {
                LEBoard lEBoard = (LEBoard)lEBoards.get((String)lEVector.elementAt(n2));
                if (lEBoard != null) {
                    String string = (String)lEBoard.get(LEBoard.BOARD_TYPE);
                    String string2 = (String)lEBoard.get(LEBoard.POWER);
                    if (string != null && string.equals("Present") && string2 != null && string2.equals("on")) {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (!bl) continue;
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    boolean globalEntityOkay() {
        boolean bl;
        block4: {
            bl = true;
            String string = this.m_pm.getSoftwareVersion();
            if (!string.startsWith("3.8b")) break block4;
            String string2 = string.substring(4);
            int n = string2.indexOf(47);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < 18) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        return bl;
    }
}

