/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ppp.LEPPPDebugFileReader;
import COM.livingston.smartagent.LEAgentMessage;
import COM.livingston.smartagent.LEPPPSmartAgent;
import COM.livingston.smartagent.LEPPPStateMessageLevel;
import COM.livingston.smartagent.LESourceInfo;
import COM.livingston.ui.LEAboutDialog;
import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEActionDialog;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConnectDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEImageView;
import COM.livingston.ui.LELEDs;
import COM.livingston.ui.LELoginClient;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LETitleBar;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEProperties;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEStatusManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.help.Book;
import oracle.help.Help;

public class LESmartAgentMessageViewer
extends Frame
implements LEObserver,
ActionListener,
LELoginClient,
LEActionClient,
LEAMObserver {
    LEMessageViewerPanel m_msgview;
    LEPPPSmartAgent m_pppsmartagent;
    LEConnectDialog m_condial;
    LEAgentMessageLevelSetDialog m_msg_level_dialog;
    MenuItem m_portmaster_disconnect_mi;
    MenuItem m_portmaster_reconnect_mi;
    MenuItem m_message_delete_mi;
    MenuItem m_message_delete_all_mi;
    MenuItem m_message_detail_mi;
    MenuBar m_menubar;
    LEStatusBar m_sb;
    LEImageView m_image1;
    LEImageView m_image2;
    boolean m_toggleLED;
    String m_hostname;
    String m_username;
    String m_password;
    String m_saLogfile;
    LEPortMaster m_pm;
    Hashtable m_ht_name_to_pm;
    LESmartAgentLoggingDialog m_log_dialog;
    PrintWriter m_pw;
    Rectangle m_mainBounds;
    Object m_threadObject = new Object();
    Book m_book;
    Help m_help;
    public static final String ABOUT = "About";
    public static final String HELP = "Help";
    public static final String ACTION_HELP_SEARCH = "help_search";
    public static final String CONNECT = "Connect";
    public static final String DISCONNECT = "Disconnect";
    public static final String RECONNECT = "Reconnect";
    public static final String REMOVE_PM = "Remove PM";
    public static final String DELETE_ALL_MESSAGES = "Delete all messages";
    public static final String EXIT = "Exit";
    public static final String PREFERENCES = "Preferences";
    public static final String START_LOGGING = "Start Logging";
    public static final String STOP_LOGGING = "Stop Logging";
    public static final float MIN_VERSION = 3.8f;
    static final String PROPERTIES_FILE = "pppagentprops.cfg";
    static final String PROP_MAIN_X = "main_x";
    static final String PROP_MAIN_Y = "main_y";
    static final String PROP_MAIN_W = "main_w";
    static final String PROP_MAIN_H = "main_h";
    static final String READ_LOG_FILE = "read_log_file";
    static /* synthetic */ Class class$pppagenthlp$PPPAgentHelp;

    public LESmartAgentMessageViewer(boolean bl) {
        this.addNotify();
        LEProperties.SetPropertyFile(LEAppInfo.getUserAppDirPath(PROPERTIES_FILE));
        this.loadProps();
        this.setTitle(LEAppInfo.getAppTitle());
        ((Component)this).setBackground(LEColor.getBackground());
        this.setLayout(new BorderLayout());
        LETitleBar lETitleBar = new LETitleBar();
        this.add("North", lETitleBar);
        this.m_msgview = new LEMessageViewerPanel(null);
        this.add((Component)this.m_msgview, "Center");
        this.m_pppsmartagent = new LEPPPSmartAgent();
        this.m_pppsmartagent.addObserver(this);
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        Panel panel = this.layoutStatusPanel();
        this.add("South", panel);
        this.m_sb.setStatusText(LEAppInfo.getAppTitle());
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        Image image = LEResource.GetImage("lucent_32.gif");
        if (image instanceof Image) {
            this.setIconImage(image);
        }
        this.m_ht_name_to_pm = new Hashtable();
        this.setPosition();
        try {
            this.m_book = Help.createBook((Class)(class$pppagenthlp$PPPAgentHelp != null ? class$pppagenthlp$PPPAgentHelp : (class$pppagenthlp$PPPAgentHelp = LESmartAgentMessageViewer.class$("pppagenthlp.PPPAgentHelp"))), (String)".", (String)"PPPHelp", (String)"PPPSmartAgent Help");
            if (this.m_book != null) {
                this.m_help = new Help();
                this.m_help.addBook(this.m_book);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
        ViewPanelMessageListListener viewPanelMessageListListener = new ViewPanelMessageListListener();
        this.m_msgview.getMessageList().addListener(viewPanelMessageListListener);
    }

    Panel layoutStatusPanel() {
        Panel panel = new Panel(new BorderLayout(5, 0));
        LEStatusManager lEStatusManager = new LEStatusManager();
        this.m_sb = new LEStatusBar(1, lEStatusManager);
        panel.add((Component)this.m_sb, "Center");
        LELEDs.Initialize();
        this.m_image1 = new LEImageView(LELEDs.GetLED(LELEDs.GREEN));
        this.m_image2 = new LEImageView(LELEDs.GetLED(LELEDs.GRAY));
        Panel panel2 = new Panel(new BorderLayout(0, 5));
        panel2.add((Component)this.m_image1, "Center");
        panel2.add((Component)this.m_image2, "South");
        panel.add((Component)panel2, "East");
        this.m_toggleLED = false;
        return panel;
    }

    public static void main(String[] stringArray) {
        ((Component)new LESmartAgentMessageViewer(true)).setVisible(true);
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof LEAgentMessage) {
            LEAgentMessage lEAgentMessage = (LEAgentMessage)object;
            this.switchLEDs();
            this.m_msgview.addSmartAgentMessage(lEAgentMessage);
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            int n = lEStatusMessage.getStatus();
            if (n == 2) {
                this.m_sb.setStatusText("Disconnected from " + string + "... Attempting to Auto Reconnect.....");
                LEPortMaster lEPortMaster = (LEPortMaster)this.m_ht_name_to_pm.get(string);
                if (lEPortMaster != null) {
                    this.m_pppsmartagent.removePMFromMonitor(lEPortMaster);
                    lEPortMaster.reconnect();
                    this.m_sb.setStatusText("Failed to Auto Reconnect to: " + string);
                    return;
                }
            } else if (n == 1) {
                this.m_sb.setStatusText("Connection establised to: " + string);
                LEPortMaster lEPortMaster = (LEPortMaster)this.m_ht_name_to_pm.get(string);
                if (lEPortMaster != null) {
                    this.m_pppsmartagent.addPMToMonitor(lEPortMaster);
                }
            }
        }
    }

    void Frame_WindowClosing() {
        ((Component)this).setVisible(false);
        try {
            this.turnDebuggingOff();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.saveProperties();
        this.dispose();
        System.exit(0);
    }

    void turnDebuggingOff() {
        Enumeration enumeration = this.m_ht_name_to_pm.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_ht_name_to_pm.get(string);
            if (!(lEPortMaster != null & lEPortMaster.isConnected())) continue;
            lEPortMaster.disconnect();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CONNECT)) {
            this.m_condial = new LEConnectDialog((Frame)this, this);
            this.m_condial.show();
            return;
        }
        if (string.equals(RECONNECT)) {
            String[] stringArray = this.m_msgview.getSelectedHosts();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                LEPortMaster lEPortMaster;
                String string2 = stringArray[n2];
                if (this.m_ht_name_to_pm.containsKey(string2) && !(lEPortMaster = (LEPortMaster)this.m_ht_name_to_pm.get(string2)).isConnected()) {
                    lEPortMaster.reconnect();
                }
                ++n2;
            }
            return;
        }
        if (string.equals(DISCONNECT)) {
            this.disconnectSelectedPortMasters();
            return;
        }
        if (string.equals(REMOVE_PM)) {
            this.removeSelectedPortMasters();
            String[] stringArray = this.m_msgview.getSelectedHosts();
            if (stringArray.length <= 0) {
                this.m_portmaster_disconnect_mi.setEnabled(false);
                this.m_portmaster_reconnect_mi.setEnabled(false);
                return;
            }
        } else {
            if (string.equals(EXIT)) {
                this.Frame_WindowClosing();
                return;
            }
            if (string.equals(DELETE_ALL_MESSAGES)) {
                this.m_msgview.deleteAllMessages();
                return;
            }
            if (string.equals(PREFERENCES)) {
                this.displayMessageLevelPrefDialog();
                return;
            }
            if (string.equals(ABOUT)) {
                LEAboutDialog.Show(this);
                return;
            }
            if (string.equals(READ_LOG_FILE)) {
                this.readLogFile_ActionPerformed();
                return;
            }
            if (string.equals(HELP)) {
                this.showHelp();
                return;
            }
            if (string.equals(ACTION_HELP_SEARCH) && this.m_help != null) {
                this.m_help.showSearch();
            }
        }
    }

    public void displayMessageLevelPrefDialog() {
        if (this.m_msg_level_dialog == null) {
            this.m_msg_level_dialog = new LEAgentMessageLevelSetDialog(this);
        }
        ((Component)this.m_msg_level_dialog).setVisible(true);
    }

    public void loginTo(String string, String string2, String string3) {
        this.m_hostname = string;
        this.m_username = string2;
        this.m_password = string3;
        LEActionDialog lEActionDialog = new LEActionDialog((Frame)this, "Connecting", this, LEStatusManager.GetManager());
        new Thread(lEActionDialog).start();
        ((Component)lEActionDialog).setVisible(true);
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Message");
        Menu menu3 = new Menu("PortMaster");
        Menu menu4 = new Menu("Logging");
        Menu menu5 = new Menu(HELP);
        MenuItem menuItem = new MenuItem("Read Telnet Log File...");
        menuItem.setActionCommand(READ_LOG_FILE);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        MenuItem menuItem2 = new MenuItem(EXIT);
        menuItem2.setActionCommand(EXIT);
        menuItem2.addActionListener(this);
        menu.add(menuItem2);
        this.m_message_detail_mi = new MenuItem("PPP Detail...");
        this.m_message_detail_mi.setEnabled(false);
        this.m_message_detail_mi.setActionCommand("pppdetail");
        this.m_message_detail_mi.addActionListener(this.m_msgview);
        menu2.add(this.m_message_detail_mi);
        menu2.addSeparator();
        this.m_message_delete_mi = new MenuItem("Delete");
        this.m_message_delete_mi.setActionCommand("delete_message");
        this.m_message_delete_mi.addActionListener(this.m_msgview);
        this.m_message_delete_mi.setEnabled(false);
        menu2.add(this.m_message_delete_mi);
        this.m_message_delete_all_mi = new MenuItem("Delete All");
        this.m_message_delete_all_mi.setEnabled(false);
        this.m_message_delete_all_mi.setActionCommand(DELETE_ALL_MESSAGES);
        this.m_message_delete_all_mi.addActionListener(this);
        menu2.add(this.m_message_delete_all_mi);
        menu2.addSeparator();
        MenuItem menuItem3 = new MenuItem("Preferences...");
        menuItem3.setActionCommand(PREFERENCES);
        menuItem3.addActionListener(this);
        menu2.add(menuItem3);
        MenuItem menuItem4 = new MenuItem("Connect...");
        menuItem4.setActionCommand(CONNECT);
        menuItem4.addActionListener(this);
        menu3.add(menuItem4);
        this.m_portmaster_disconnect_mi = new MenuItem(DISCONNECT);
        this.m_portmaster_disconnect_mi.setActionCommand(DISCONNECT);
        this.m_portmaster_disconnect_mi.addActionListener(this);
        this.m_portmaster_disconnect_mi.setEnabled(false);
        menu3.add(this.m_portmaster_disconnect_mi);
        this.m_portmaster_reconnect_mi = new MenuItem(RECONNECT);
        this.m_portmaster_reconnect_mi.setActionCommand(RECONNECT);
        this.m_portmaster_reconnect_mi.addActionListener(this);
        this.m_portmaster_reconnect_mi.setEnabled(false);
        menu3.add(this.m_portmaster_reconnect_mi);
        MenuItem menuItem5 = new MenuItem("Remove");
        menuItem5.setActionCommand(REMOVE_PM);
        menuItem5.addActionListener(this);
        menu3.add(menuItem5);
        MenuItem menuItem6 = new MenuItem("Help Contents...");
        menuItem6.setActionCommand(HELP);
        menuItem6.addActionListener(this);
        menu5.add(menuItem6);
        MenuItem menuItem7 = new MenuItem("Search for Help on...");
        menuItem7.setActionCommand(ACTION_HELP_SEARCH);
        menuItem7.addActionListener(this);
        menu5.add(menuItem7);
        MenuItem menuItem8 = new MenuItem(ABOUT);
        menuItem8.setActionCommand(ABOUT);
        menuItem8.addActionListener(this);
        menu5.add(menuItem8);
        MenuItem menuItem9 = new MenuItem("Start Logging...");
        menuItem9.setActionCommand(START_LOGGING);
        menuItem9.addActionListener(this);
        menu4.add(menuItem9);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu5);
        return menuBar;
    }

    void setPosition() {
        ((Component)this).setLocation(this.m_mainBounds.x, this.m_mainBounds.y);
        ((Component)this).setSize(this.m_mainBounds.width, this.m_mainBounds.height);
    }

    void addPortMastersToMonitor(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof LEPortMaster)) continue;
            LEPortMaster lEPortMaster = (LEPortMaster)e;
            this.addPortMasterToMonitor(lEPortMaster);
        }
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        try {
            LEStatusBar lEStatusBar = lEActionDialog.getStatusBar();
            lEStatusBar.setStatusText("Connecting to " + this.m_hostname + "...");
            this.m_pm = new LEPortMaster(this.m_hostname, this.m_username, this.m_password);
            if (this.m_hostname == null) {
                this.m_pm.disconnect();
                this.m_pm = null;
            } else {
                LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
                if (lEDSSPortMaster == null || !lEDSSPortMaster.isConnected()) {
                    new LEErrorDialog((Frame)this, new String("Failed to connect to " + this.m_hostname));
                    this.m_pm = null;
                }
                String string = this.m_pm.getSoftwareVersion();
                try {
                    Float f = Float.valueOf(string.substring(0, 3));
                    if (f.floatValue() < 3.8f) {
                        new LEErrorDialog((Frame)this, new String("Must be running COMOS " + 3.8f + " or Greater"));
                        this.m_pm = null;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.m_sb.setStatusText("Connected to " + this.m_hostname);
            return;
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            this.m_pm = null;
            new LEErrorDialog((Frame)this, new String("Invalid password!"));
            return;
        }
        catch (Exception exception) {
            this.m_pm = null;
            LEDebug.getLog().logln(20, exception);
            if (this.m_hostname != null) {
                new LEErrorDialog((Frame)this, exception.getMessage());
            }
            return;
        }
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (this.m_pm != null && !this.m_ht_name_to_pm.containsKey(this.m_pm.getHostname())) {
            this.addPortMasterToMonitor(this.m_pm);
        }
    }

    public void actionCancel(LEActionDialog lEActionDialog) {
        this.m_hostname = null;
        this.m_username = null;
        this.m_password = null;
    }

    void addPortMasterToMonitor(LEPortMaster lEPortMaster) {
        this.m_pppsmartagent.addPMToMonitor(lEPortMaster);
        this.m_msgview.addHostname(lEPortMaster.getHostname(), lEPortMaster);
        this.m_portmaster_disconnect_mi.setEnabled(true);
        this.m_portmaster_reconnect_mi.setEnabled(true);
        this.m_ht_name_to_pm.put(lEPortMaster.getHostname(), lEPortMaster);
        LEStatusFactory.GetFactory().addObserver(lEPortMaster.getHostname(), this);
    }

    void removeSelectedPortMasters() {
        String[] stringArray = this.m_msgview.getSelectedHosts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            LEStatusFactory.GetFactory().deleteObserver(string, this);
            this.m_ht_name_to_pm.remove(string);
            this.m_pppsmartagent.removeHostnameFromMonitor(string);
            ++n2;
        }
        this.m_msgview.removeSelectedHosts();
    }

    void disconnectSelectedPortMasters() {
        String[] stringArray = this.m_msgview.getSelectedHosts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            LEStatusFactory.GetFactory().deleteObserver(string, this);
            Object v = this.m_ht_name_to_pm.get(string);
            if (v instanceof LEPortMaster) {
                LEPortMaster lEPortMaster = (LEPortMaster)v;
                lEPortMaster.disconnect();
            }
            this.m_pppsmartagent.removeHostnameFromMonitor(string);
            ++n2;
        }
    }

    public void loadProps() {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 640;
            int n2 = 480;
            int n3 = dimension.width / 2 - n / 2;
            int n4 = dimension.height / 2 - n2 / 2;
            String string = LEProperties.GetProperty(PROP_MAIN_X);
            if (string != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_Y)) != null) {
                n4 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_W)) != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_H)) != null) {
                n2 = Integer.parseInt(string);
            }
            this.m_mainBounds = new Rectangle(n3, n4, n, n2);
            LEPPPStateMessageLevel.LoadLevelPrefs();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void saveProperties() {
        try {
            Rectangle rectangle = this.getBounds();
            LEProperties.SetProperty(PROP_MAIN_X, Integer.toString(rectangle.x));
            LEProperties.SetProperty(PROP_MAIN_Y, Integer.toString(rectangle.y));
            LEProperties.SetProperty(PROP_MAIN_W, Integer.toString(rectangle.width));
            LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height));
            LEPPPStateMessageLevel.SaveProperties();
            LEMessageViewerPanel.SaveProperties();
            LEProperties.SaveProperties();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void logMessage(LEAgentMessage lEAgentMessage) {
        if (this.m_log_dialog != null && this.m_log_dialog.loggingEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(30);
            String string = "";
            this.m_pw = this.m_log_dialog.getPrintWriter();
            this.m_pw.println("--------------------------------------------------------------------------------");
            this.m_pw.println("Agent Message Contains:");
            stringBuffer.append("\tMessage: ");
            String string2 = lEAgentMessage.getMessage();
            stringBuffer.append(string2);
            this.m_pw.println(stringBuffer.toString());
            stringBuffer = new StringBuffer("\tFrom: ");
            String string3 = string;
            Object object = lEAgentMessage.getContext();
            if (object instanceof LESourceInfo) {
                string3 = ((LESourceInfo)object).getAllSourceInfo();
            }
            stringBuffer.append(string3);
            stringBuffer.append("\tReceived: ");
            Date date = new Date(lEAgentMessage.getTimeStamp());
            String string4 = date.toString();
            stringBuffer.append(string4);
            stringBuffer.append("\tLevel: ");
            String string5 = Integer.toString(lEAgentMessage.getLevel());
            stringBuffer.append(string5);
            this.m_pw.println(stringBuffer.toString());
            stringBuffer = new StringBuffer("\tSuggestion:");
            stringBuffer.append("\t");
            String string6 = lEAgentMessage.getSuggestion();
            if (string6 != null) {
                stringBuffer.append(string6);
            }
            this.m_pw.println(stringBuffer.toString());
        }
    }

    void readLogFile_ActionPerformed() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setLocation(50, 20);
        fileDialog.show();
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            this.m_msgview.addHostname(string2, null);
            this.m_pppsmartagent.addFilenameToMonitor(string2);
            LEPPPDebugFileReader.ReadFile(fileDialog.getDirectory(), string2);
            LEAppInfo.createFullPath(string, string2);
            LEAppInfo.setLastDirectory(string);
        }
    }

    void showHelp() {
        try {
            if (this.m_help != null) {
                this.m_help.showContents();
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void addNotify() {
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
    }

    public void processInitFlags() {
        String string = LEAppInfo.getFlag("-h");
        try {
            ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
            if (string != null) {
                String string2 = LEAppInfo.getFlag("-p");
                String string3 = LEAppInfo.getFlag("-u") != null ? LEAppInfo.getFlag("-u") : "!root";
                this.loginTo(string, string3, string2);
            }
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            this.m_saLogfile = LEAppInfo.getFlag("-salog");
            if (this.m_saLogfile != null) {
                LEPPPSmartAgent.EnableLogging(this.m_saLogfile);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    private void switchLEDs() {
        if (this.m_toggleLED) {
            this.m_image1.setImage(LELEDs.GetLED(LELEDs.GRAY));
            this.m_image2.setImage(LELEDs.GetLED(LELEDs.GREEN));
            this.m_toggleLED = false;
            return;
        }
        this.m_image1.setImage(LELEDs.GetLED(LELEDs.GREEN));
        this.m_image2.setImage(LELEDs.GetLED(LELEDs.GRAY));
        this.m_toggleLED = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == LESmartAgentMessageViewer.this) {
                LESmartAgentMessageViewer.this.Frame_WindowClosing();
            }
        }

        SymWindow() {
            LESmartAgentMessageViewer.this = LESmartAgentMessageViewer.this;
        }
    }

    class ViewPanelMessageListListener
    implements LEMLListener {
        public void onLEMLEvent(LEMLEvent lEMLEvent) {
            int n = lEMLEvent.getType();
            if (n == 1 || n == 3) {
                LEMultiList lEMultiList = LESmartAgentMessageViewer.this.m_msgview.getMessageList();
                int n2 = lEMultiList.getSelectSize();
                if (n2 == 0) {
                    LESmartAgentMessageViewer.this.m_message_delete_mi.setEnabled(false);
                    LESmartAgentMessageViewer.this.m_message_detail_mi.setEnabled(false);
                    LESmartAgentMessageViewer.this.m_message_delete_all_mi.setEnabled(false);
                    return;
                }
                LESmartAgentMessageViewer.this.m_message_delete_mi.setEnabled(true);
                LESmartAgentMessageViewer.this.m_message_detail_mi.setEnabled(true);
                LESmartAgentMessageViewer.this.m_message_delete_all_mi.setEnabled(true);
            }
        }

        ViewPanelMessageListListener() {
            LESmartAgentMessageViewer.this = LESmartAgentMessageViewer.this;
        }
    }
}

