/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEUiUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class UTModifyDialog
extends Dialog
implements ActionListener {
    Frame m_parent;
    List m_nonActiveList;
    List m_activeList;
    String m_title;
    Vector m_addedItems = new Vector();
    Vector m_removedItems = new Vector();
    boolean m_hasChanged;
    boolean m_newAdded;
    public static final String ADD_ITEM = "add_item";
    public static final String REMOVE_ITEM = "remove_item";
    public static final String OKAY = "okay";
    public static final String CANCEL = "cancel";
    public static final String DELETE = "delete";
    public static final String ADD_NEW = "add_new";

    UTModifyDialog(Frame frame, String string, Vector vector, Vector vector2) {
        super(frame, true);
        this.m_title = string;
        this.setTitle("Modify " + string + "s");
        this.m_parent = frame;
        this.m_hasChanged = false;
        this.m_newAdded = true;
        ((Component)this).setSize(320, 300);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createModifyPanel(vector, vector2), "Center");
        this.add((Component)this.createMainControlPanel(), "South");
        LEUiUtils.CenterDialog(this);
    }

    Panel createModifyPanel(Vector vector, Vector vector2) {
        LEBorderPanel lEBorderPanel = new LEBorderPanel();
        lEBorderPanel.setBorderType(4);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        lEBorderPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Panel panel = this.createNonActivePanel(vector);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        lEBorderPanel.add(panel);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        Panel panel2 = this.createControlPanel();
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        lEBorderPanel.add(panel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 5;
        Panel panel3 = this.createActivePanel(vector2);
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        lEBorderPanel.add(panel3);
        return lEBorderPanel;
    }

    Panel createNonActivePanel(Vector vector) {
        Panel panel = new Panel(new BorderLayout());
        this.m_nonActiveList = new List();
        this.m_nonActiveList.setMultipleMode(true);
        if (vector == null) {
            vector = new Vector();
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_nonActiveList.add((String)vector.elementAt(n2));
            ++n2;
        }
        panel.add((Component)new Label("Available:"), "North");
        panel.add((Component)this.m_nonActiveList, "Center");
        Panel panel2 = new Panel(new FlowLayout());
        Button button = new Button(" Add  ");
        button.setActionCommand(ADD_NEW);
        button.addActionListener(this);
        panel2.add(button);
        Button button2 = new Button("Delete");
        button2.setActionCommand(DELETE);
        button2.addActionListener(this);
        panel2.add(button2);
        panel.add((Component)panel2, "South");
        return panel;
    }

    Panel createActivePanel(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        Panel panel = new Panel(new BorderLayout());
        this.m_activeList = new List();
        this.m_activeList.setMultipleMode(true);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_activeList.add((String)vector.elementAt(n2));
            ++n2;
        }
        panel.add((Component)new Label("Selected:"), "North");
        panel.add((Component)this.m_activeList, "Center");
        return panel;
    }

    Panel createMainControlPanel() {
        Panel panel = new Panel(new FlowLayout());
        Button button = new Button("  OK  ");
        button.setActionCommand(OKAY);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button("Cancel");
        button2.setActionCommand(CANCEL);
        button2.addActionListener(this);
        panel.add(button2);
        return panel;
    }

    Panel createControlPanel() {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new GridLayout(4, 1, 20, 20));
        panel2.add(new Label(""));
        panel2.add(new Label(""));
        Button button = new Button(">>");
        button.setActionCommand(ADD_ITEM);
        button.addActionListener(this);
        panel2.add(button);
        Button button2 = new Button("<<");
        button2.setActionCommand(REMOVE_ITEM);
        button2.addActionListener(this);
        panel2.add(button2);
        panel.add((Component)panel2, "North");
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ADD_ITEM)) {
            this.addSelectedItem();
            return;
        }
        if (string.equals(REMOVE_ITEM)) {
            this.removeSelectedItem();
            return;
        }
        if (string.equals(OKAY)) {
            this.closeDialog();
            return;
        }
        if (string.equals(CANCEL)) {
            this.processCancel();
            return;
        }
        if (string.equals(DELETE)) {
            this.processDelete();
            return;
        }
        if (string.equals(ADD_NEW)) {
            this.processAddNew();
        }
    }

    void addSelectedItem() {
        String[] stringArray = this.m_nonActiveList.getSelectedItems();
        if (stringArray.length <= 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!this.alreadyExistsInList(this.m_activeList, string)) {
                this.m_activeList.add(string);
                this.m_addedItems.addElement(string);
            }
            this.m_nonActiveList.remove(string);
            ++n;
        }
    }

    void removeSelectedItem() {
        String[] stringArray = this.m_activeList.getSelectedItems();
        if (stringArray.length <= 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!this.alreadyExistsInList(this.m_nonActiveList, string)) {
                this.m_nonActiveList.add(string);
            }
            this.m_activeList.remove(string);
            if (!this.m_addedItems.removeElement(string)) {
                this.m_removedItems.addElement(string);
            }
            ++n;
        }
    }

    void closeDialog() {
        this.m_hasChanged = this.m_addedItems.size() > 0 || this.m_removedItems.size() > 0 || this.m_newAdded;
        ((Component)this).setVisible(false);
    }

    void processCancel() {
        this.m_addedItems.removeAllElements();
        this.m_removedItems.removeAllElements();
        this.m_hasChanged = false;
        this.closeDialog();
    }

    void processDelete() {
        int[] nArray = this.m_nonActiveList.getSelectedIndexes();
        int n = nArray.length;
        while (n > 0) {
            this.m_nonActiveList.remove(nArray[n - 1]);
            --n;
        }
    }

    void processAddNew() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("Add ");
        stringBuffer.append(this.m_title);
        UTModifyIDDialog uTModifyIDDialog = new UTModifyIDDialog(this.m_parent, "", stringBuffer.toString());
        ((Component)uTModifyIDDialog).setVisible(true);
        if (uTModifyIDDialog.hasChanged() && !this.alreadyExistsInList(this.m_nonActiveList, string = uTModifyIDDialog.getNewID())) {
            this.m_nonActiveList.add(string);
            this.m_nonActiveList.select(this.m_nonActiveList.getItemCount() - 1);
            this.m_newAdded = true;
        }
    }

    boolean alreadyExistsInList(List list, String string) {
        int n = list.getItemCount();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (list.getItem(n2).equals(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public Vector getAddedItems() {
        return this.m_addedItems;
    }

    public Vector getRemovedItems() {
        return this.m_removedItems;
    }

    public Vector getNonActiveItems() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.m_nonActiveList.getItems();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        return vector;
    }

    public Vector getActiveItems() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.m_activeList.getItems();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        return vector;
    }

    public boolean isChanged() {
        return this.m_hasChanged;
    }
}

