/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UTPMGrid
extends LEMultiList
implements LEAMObserver,
Runnable {
    public static final String REBOOTING = "Rebooting...";
    public static final String NOT_CONNECTED = "Connection Lost";
    public static final String FILE = "File";
    static final int COLUMNS = 5;
    static int UPDATE_SLEEP_TIME = 90000;
    Hashtable m_pms = new Hashtable();
    Vector m_filenames = new Vector();
    Hashtable m_htidtotime = new Hashtable();

    public UTPMGrid() {
        super(1, 0, 5);
        Object[] objectArray = new String[]{new String("PortMaster"), new String("Model"), new String("ComOS"), new String("Up Time"), new String("Time Connected")};
        this.setTitles(0, objectArray);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortable(3, true);
        this.setSortable(4, true);
        this.setSortObject(3, new LEUpTimeCompare());
        LEStatusFactory.GetFactory().addObserver("", this);
        Thread thread = new Thread(this);
        thread.setName("ULTPMGrid Updater");
        thread.start();
    }

    public synchronized boolean connectedTo(String string) {
        return this.m_pms.containsKey(string);
    }

    public void addPortMaster(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().addObserver(string, this);
        this.m_pms.put(string, lEPortMaster);
        String string2 = lEPortMaster.getDescription();
        Object[] objectArray = new String[5];
        objectArray[0] = string2;
        objectArray[1] = lEPortMaster.getHardwareType();
        objectArray[2] = lEPortMaster.getSoftwareVersion();
        objectArray[3] = lEPortMaster.getUpTime();
        this.m_htidtotime.put(string, new String("0"));
        objectArray[4] = new String("0 minutes");
        this.addRow(objectArray);
        this.setRowObject(this.getNumRows() - 1, string);
        this.selectCurrentPlusPreviousRows();
        this.repaint();
    }

    public synchronized void addFilename(String string) {
        this.m_filenames.addElement(string);
        Object[] objectArray = new String[]{string, FILE, FILE, FILE, FILE};
        this.addRow(objectArray);
        this.setRowObject(this.getNumRows() - 1, string);
        this.selectCurrentPlusPreviousRows();
        this.repaint();
    }

    void selectCurrentPlusPreviousRows() {
        if (this.getNumRows() == 1) {
            int[] nArray = new int[]{0};
            this.selectRows(nArray);
            return;
        }
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = new int[nArray.length + 1];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n];
            ++n;
        }
        nArray2[nArray2.length - 1] = this.getNumRows() - 1;
        this.selectRows(nArray2);
    }

    public synchronized void deletePortMaster(LEPortMaster lEPortMaster) {
        if (lEPortMaster == null) {
            return;
        }
        lEPortMaster.disconnect();
    }

    public synchronized void removeSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.removePM(lEPortMasterArray[n]);
            ++n;
        }
        String[] stringArray = this.getSelectedFilenames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.removeFilenames(stringArray[n2]);
            ++n2;
        }
    }

    public synchronized void removePM(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().deleteObserver(string, this);
        int n = this.getPortMasterRow(string);
        this.m_pms.remove(string);
        this.deletePortMaster(lEPortMaster);
        this.deleteRow(n);
    }

    public synchronized void removeFilenames(String string) {
        int n = this.getPortMasterRow(string);
        this.deleteRow(n);
        this.m_filenames.removeElement(string);
    }

    public synchronized void removeSelectedHosts() {
        String[] stringArray = this.getSelectedHostnames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getPortMasterRow(stringArray[n2]);
            Object v = this.m_pms.get(stringArray[n2]);
            if (v instanceof LEPortMaster) {
                this.deletePortMaster((LEPortMaster)v);
            }
            this.m_pms.remove(stringArray[n2]);
            this.deleteRow(n3);
            ++n2;
        }
        this.repaint();
        this.setEnabled(false);
        this.setEnabled(true);
    }

    public synchronized void deleteSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.deletePortMaster(lEPortMasterArray[n]);
            ++n;
        }
        this.repaint();
    }

    public synchronized void reconnectSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            ++n;
        }
    }

    public synchronized LEPortMaster[] getSelectedPMs() {
        int[] nArray = this.getSelectedRows();
        Vector<LEPortMaster> vector = new Vector<LEPortMaster>();
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.getRowObject(nArray[n]);
            if (this.m_pms.containsKey(string)) {
                vector.addElement((LEPortMaster)this.m_pms.get(string));
            }
            ++n;
        }
        int n2 = vector.size();
        LEPortMaster[] lEPortMasterArray = new LEPortMaster[n2];
        int n3 = 0;
        while (n3 < n2) {
            lEPortMasterArray[n3] = (LEPortMaster)vector.elementAt(n3);
            ++n3;
        }
        return lEPortMasterArray;
    }

    public synchronized String[] getSelectedFilenames() {
        int[] nArray = this.getSelectedRows();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < nArray.length) {
            if (this.getCellItem(nArray[n], 1).equals(FILE)) {
                vector.addElement((String)this.getCellItem(nArray[n], 0));
            }
            ++n;
        }
        int n2 = vector.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public synchronized String[] getSelectedHostnames() {
        int[] nArray = this.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)this.getCellItem(nArray[n], 0);
            ++n;
        }
        return stringArray;
    }

    public String getSelectedModel() {
        int[] nArray = this.getSelectedRows();
        int n = nArray[nArray.length - 1];
        String string = (String)this.getCellItem(n, 1);
        return string;
    }

    public void updateUpTimes() {
        int n = this.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster;
            String string = (String)this.getRowObject(n2);
            if (string != null && this.m_pms.containsKey(string) && (lEPortMaster = (LEPortMaster)this.m_pms.get(string)) != null && lEPortMaster.isConnected() && lEPortMaster.ping()) {
                this.setCellItem(n2, 2, lEPortMaster.getSoftwareVersion());
                this.setCellItem(n2, 3, lEPortMaster.getUpTime());
                String string2 = (String)this.m_htidtotime.get(string);
                long l = Long.parseLong(string2);
                this.m_htidtotime.put(string, Long.toString(l += (long)(UPDATE_SLEEP_TIME / 1000)));
                String string3 = this.getConnectTime(l);
                this.setCellItem(n2, 4, string3);
            }
            ++n2;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.get(string);
            if (lEPortMaster == null) {
                return;
            }
            String string2 = null;
            String string3 = null;
            switch (lEStatusMessage.getStatus()) {
                case 1: {
                    lEPortMaster.ping();
                    string2 = lEPortMaster.getUpTime();
                    string3 = lEPortMaster.getSoftwareVersion();
                    this.m_htidtotime.put(string, new String("0"));
                    break;
                }
                case 2: {
                    string2 = NOT_CONNECTED;
                    this.m_htidtotime.put(string, new String("0"));
                    break;
                }
                case 4: {
                    string2 = REBOOTING;
                    break;
                }
            }
            if (string2 != null || string3 != null) {
                int n = this.getPortMasterRow(string);
                if (n > -1) {
                    if (string3 != null) {
                        this.setCellItem(n, 2, string3);
                    }
                    if (string2 != null) {
                        this.setCellItem(n, 3, string2);
                    }
                }
                this.notifyListeners(new LEMLEvent(this, 3));
            }
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.m_pms.elements();
        while (enumeration.hasMoreElements()) {
            LEPortMaster lEPortMaster = (LEPortMaster)enumeration.nextElement();
            lEPortMaster.disconnect();
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(UPDATE_SLEEP_TIME);
                    this.updateUpTimes();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    int getPortMasterRow(String string) {
        int n = -1;
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            String string2 = (String)this.getRowObject(n3);
            if (string.equals(string2)) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    String getConnectTime(long l) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n3 = (int)(l / 86400L);
        if (n3 != 0) {
            stringBuffer.append(String.valueOf(n3) + " days ");
        }
        if ((n2 = (int)((l - (long)(n3 * 24 * 60 * 60)) / 3600L)) != 0 || n3 != 0) {
            stringBuffer.append(String.valueOf(n2) + " hours ");
        }
        if ((n = (int)((l - (long)(n3 * 24 * 60 * 60) - (long)(n2 * 60 * 60)) / 60L)) != 0 || n3 != 0 || n2 != 0) {
            stringBuffer.append(String.valueOf(n) + " minutes ");
        }
        int n4 = (int)(l - (long)(n3 * 24 * 60 * 60) - (long)(n2 * 60 * 60) - (long)(60 * n));
        stringBuffer.append(String.valueOf(n4) + " sec");
        return stringBuffer.toString();
    }
}

