/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.amf;

import com.lucent.ra.nms.amf.LEAMManager_R;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.amf.LEAsyncMessage;
import com.lucent.ra.nms.util.LEAppSpecs;
import com.lucent.ra.nms.util.LEClientPerf;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LETQClient;
import com.lucent.ra.nms.util.LEThreadedQueue;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;

public class LEClientRouter
implements LETQClient {
    public static final int MAX_MESSAGES = 50;
    LEAMRouter_RI m_router;
    LEAMManager_R m_manager;
    LEVector m_critical;
    LEAppSpecs m_specs;
    LEThreadedQueue m_queue;
    int m_messagesDropped;
    boolean m_done;
    boolean m_ignore;

    public LEClientRouter(LEAMRouter_RI lEAMRouter_RI, LEAMManager_R lEAMManager_R, LEAppSpecs lEAppSpecs) {
        this.m_router = lEAMRouter_RI;
        this.m_manager = lEAMManager_R;
        this.m_specs = lEAppSpecs;
        this.m_queue = new LEThreadedQueue(this);
    }

    public void setCriticalMessageTypes(LEVector lEVector) {
        this.m_critical = lEVector;
    }

    public String getId() {
        return this.m_specs.m_id;
    }

    public LEAppSpecs getAppSpecs() {
        return this.m_specs;
    }

    public LEClientPerf getPerformance() {
        return new LEClientPerf(this.m_specs.m_id, this.m_queue.getQueueSize(), this.m_queue.getIdleTime(), this.m_messagesDropped);
    }

    public void process(LEAsyncMessage lEAsyncMessage) {
        if (this.m_done) {
            return;
        }
        if (!this.m_ignore && this.m_queue.getQueueSize() > 50) {
            this.m_ignore = true;
        }
        if (this.m_ignore) {
            if (this.m_critical != null && this.m_critical.contains(lEAsyncMessage.getType())) {
                LEDebug.getLog().logln(30, "ClientRouter " + this.m_specs.m_id + " overflow message of type " + lEAsyncMessage.getType() + " from " + lEAsyncMessage.getID());
                this.m_queue.add(lEAsyncMessage);
                return;
            }
            ++this.m_messagesDropped;
            return;
        }
        this.m_queue.add(lEAsyncMessage);
    }

    public void next(Object object) {
        if (this.m_done) {
            return;
        }
        LEAsyncMessage lEAsyncMessage = (LEAsyncMessage)object;
        if (!(this.notifyClient(lEAsyncMessage) || this.notifyClient(lEAsyncMessage) || this.notifyClient(lEAsyncMessage))) {
            this.shutdown();
        }
    }

    public boolean ping() {
        if (!(this.pingClient() || this.pingClient() || this.pingClient())) {
            this.shutdown();
            return false;
        }
        return true;
    }

    public void shutdown() {
        this.m_done = true;
        if (this.m_queue != null) {
            LEDebug.getLog().logln(30, "Shutting down ClientRouter for " + this.m_specs.m_id);
            this.m_queue.shutdown();
            this.m_queue = null;
        }
        if (this.m_router != null) {
            this.m_router.clientShutdown(this);
            this.m_router = null;
        }
        this.m_manager = null;
    }

    boolean pingClient() {
        try {
            if (!this.m_done && this.m_manager.ping()) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            LEDebug.getLog().logln(30, remoteException);
        }
        return false;
    }

    boolean notifyClient(LEAsyncMessage lEAsyncMessage) {
        boolean bl = false;
        try {
            if (this.m_ignore && this.m_queue.getQueueSize() == 0) {
                this.m_queue.shrink(50);
                this.m_ignore = false;
            }
            if (this.m_manager != null) {
                this.m_manager.process(lEAsyncMessage);
            }
            bl = true;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(30, exception);
        }
        return bl;
    }
}

