/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import com.lucent.ra.nms.util.LEDebug;
import java.util.Hashtable;

public class LEIEBearerCapability
extends LEInfoElement {
    int m_length;
    int m_offset;
    int m_q931Standard;
    int m_infoTransferCap;
    int m_transferMode;
    int m_infoTransferRate;
    int m_userInfoLayer1protocol;
    int m_syncAsync = -1;
    int m_inBandNeg = -1;
    int m_userRate;
    int m_intermediateRate = -1;
    int m_txNIC = -1;
    int m_rxNIC = -1;
    int m_txFlow = -1;
    int m_rxFlow = -1;
    int m_headerYN = -1;
    int m_multiFrame = -1;
    int m_mode = -1;
    int m_LLI = -1;
    int m_assn = -1;
    int m_inBoundOutBoundNeg = -1;
    int m_numberStopBits = -1;
    int m_numberDataBits = -1;
    int m_parity;
    int m_duplexMode = -1;
    int m_modemType;
    int m_userInfoLayer2Protocol = -1;
    int m_userInfoLayer3Protocol = -1;
    public static String[] Q_931_STANDARD = new String[]{"CCITT standardized coding", "ISO/IEC standard", "National standard", "Standard Defined for Network present on the Network Side"};
    public static Hashtable INFO_TRANSFER_CAPABILITY = new Hashtable();
    public static Hashtable TRANSFERMODE;
    public static Hashtable INFO_TRANSFER_RATE;
    public static Hashtable USER_INFO_LAYER_1_PROTOCOL;
    public static String[] SYNCH_ASYNC;
    public static String[] NEGOTIATION;
    public static final Hashtable USER_RATE;
    public static String[] INTERMEDIATE_RATE;
    public static String[] REQUIRED_BIT;
    public static String[] SUPPORT_BIT;
    public static String[] HEADER_YES_NO;
    public static String[] MULTI_FRAME;
    public static String[] MODE;
    public static String[] LLI;
    public static String[] ASSN;
    public static String[] NEGOT;
    public static String[] NUMBER_OF_STOP_BITS;
    public static String[] NUMBER_OF_DATA_BITS;
    public static final Hashtable PARITY;
    public static String[] DUPLEX_MODE;
    public static final Hashtable MODEM_TYPE;
    public static final Hashtable USER_INFO_LAYER2_PROTOCOL;
    public static final Hashtable USER_INFO_LAYER3_PROTOCOL;

    public LEIEBearerCapability(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        int n = 0;
        this.m_length = this.m_data[1];
        this.m_q931Standard = (this.m_data[2] & 6) >> 5;
        this.m_infoTransferCap = this.m_data[2] & 0x1F;
        this.m_transferMode = (this.m_data[3] & 0x60) >> 5;
        this.m_infoTransferRate = this.m_data[3] & 0x3F;
        this.m_userInfoLayer1protocol = this.m_data[4] & 0x1F;
        if ((this.m_data[4] & 0x80) == 0 && this.m_infoTransferCap == 8 && (this.m_userInfoLayer1protocol == 1 || this.m_userInfoLayer1protocol == 8)) {
            this.m_syncAsync = (this.m_data[5] & 0x40) >> 6;
            this.m_inBandNeg = (this.m_data[5] & 0x20) >> 5;
            this.m_userRate = this.m_data[5] & 0x1F;
            ++n;
            if ((this.m_data[5] & 0x80) == 0 && this.m_userInfoLayer1protocol == 1 && this.m_length >= 5) {
                this.m_intermediateRate = (this.m_data[6] & 0x60) >> 5;
                this.m_txNIC = (this.m_data[6] & 0x10) >> 4;
                this.m_rxNIC = (this.m_data[6] & 0x80) >> 3;
                this.m_txFlow = (this.m_data[6] & 0x40) >> 2;
                this.m_rxFlow = (this.m_data[6] & 0x20) >> 1;
                ++n;
            } else if ((this.m_data[5] & 0x80) == 0 && this.m_userInfoLayer1protocol == 8 && this.m_length >= 5) {
                this.m_headerYN = (this.m_data[6] & 0x40) >> 6;
                this.m_multiFrame = (this.m_data[6] & 0x20) >> 5;
                this.m_mode = (this.m_data[6] & 0x10) >> 4;
                this.m_LLI = (this.m_data[6] & 0x80) >> 3;
                this.m_assn = (this.m_data[6] & 0x40) >> 2;
                this.m_inBoundOutBoundNeg = (this.m_data[6] & 0x20) >> 1;
                ++n;
            }
            if ((this.m_data[5] & 0x80) == 0 && (this.m_data[6] & 0x80) == 0 && this.m_length >= 6) {
                this.m_numberStopBits = (this.m_data[7] & 0x60) >> 5;
                this.m_numberDataBits = (this.m_data[7] & 0x18) >> 3;
                this.m_parity = this.m_data[7] & 7;
                ++n;
                if ((this.m_data[7] & 0x80) == 0) {
                    this.m_duplexMode = (this.m_data[8] & 0x40) >> 6;
                    this.m_modemType = this.m_data[8] & 0x3F;
                    ++n;
                }
            }
            if (this.m_length >= 8) {
                this.m_userInfoLayer2Protocol = this.m_data[5 + n] & 0x1F;
                this.m_userInfoLayer3Protocol = this.m_data[6 + n] & 0x1F;
            }
        }
    }

    public String getTranslatedString() {
        try {
            Integer n;
            Integer n2;
            Integer n3;
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append("\n\t\tBearer Capability Information Element");
            stringBuffer.append("\n\t\t" + this.getIdentifier());
            stringBuffer.append(" ,IE Element Length:" + this.m_length);
            stringBuffer.append(LEInfoElement.TABS);
            stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
            stringBuffer.append(" Coding Standard:");
            stringBuffer.append(Q_931_STANDARD[this.m_q931Standard]);
            Integer n4 = new Integer(this.m_infoTransferCap);
            if (INFO_TRANSFER_CAPABILITY.containsKey(n4)) {
                stringBuffer.append(" ,Information Transfer Capability:" + (String)INFO_TRANSFER_CAPABILITY.get(n4));
            }
            Integer n5 = new Integer(this.m_transferMode);
            stringBuffer.append(LEInfoElement.TABS);
            stringBuffer.append(LEDiagUtil.toHexString(this.m_data[3]));
            if (TRANSFERMODE.containsKey(n5)) {
                stringBuffer.append(" TransferMode:" + (String)TRANSFERMODE.get(n5));
            }
            if (INFO_TRANSFER_RATE.containsKey(n3 = new Integer(this.m_infoTransferRate))) {
                stringBuffer.append(" ,Info Transfer Rate:" + INFO_TRANSFER_RATE.get(n3));
            }
            Integer n6 = new Integer(this.m_userInfoLayer1protocol);
            stringBuffer.append(LEInfoElement.TABS);
            stringBuffer.append(LEDiagUtil.toHexString(this.m_data[4]));
            if (USER_INFO_LAYER_1_PROTOCOL.containsKey(n6)) {
                stringBuffer.append(" User Info Layer 1:" + USER_INFO_LAYER_1_PROTOCOL.get(n6));
            }
            int n7 = 5;
            if (this.m_syncAsync != -1) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                stringBuffer.append(" Synch/Asynch:" + SYNCH_ASYNC[this.m_syncAsync]);
                stringBuffer.append(" ,In Band Negotiation:" + NEGOTIATION[this.m_inBandNeg]);
                stringBuffer.append(" ,User Rate:");
                n2 = new Integer(this.m_userRate);
                if (USER_RATE.containsKey(n2)) {
                    stringBuffer.append(USER_RATE.get(n2));
                } else {
                    stringBuffer.append("???");
                }
                ++n7;
            }
            if (this.m_intermediateRate != -1) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                stringBuffer.append("Intermediate Rate:" + INTERMEDIATE_RATE[this.m_intermediateRate]);
                stringBuffer.append(" ,Tx Nic:" + REQUIRED_BIT[this.m_txNIC]);
                stringBuffer.append(" ,Rx Nic:" + REQUIRED_BIT[this.m_rxNIC]);
                stringBuffer.append(" ,Tx Flow:" + REQUIRED_BIT[this.m_txFlow]);
                stringBuffer.append(" ,Rx Flow:" + SUPPORT_BIT[this.m_rxFlow]);
                ++n7;
            }
            if (this.m_headerYN != -1) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                stringBuffer.append(" Header yes/no:" + HEADER_YES_NO[this.m_headerYN]);
                stringBuffer.append(" ,Multiframe:" + MULTI_FRAME[this.m_multiFrame]);
                stringBuffer.append(" ,Mode:" + MODE[this.m_mode]);
                stringBuffer.append(" ,LLI:" + LLI[this.m_LLI]);
                stringBuffer.append(" ,Assn:" + ASSN[this.m_assn]);
                stringBuffer.append(" ,InBand/OutBand Neg:" + NEGOT[this.m_inBoundOutBoundNeg]);
                ++n7;
            }
            if (this.m_numberStopBits != -1) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                stringBuffer.append(" Number of Stop bits:" + NUMBER_OF_STOP_BITS[this.m_numberStopBits]);
                stringBuffer.append(" ,Number of Data bits:" + NUMBER_OF_DATA_BITS[this.m_numberDataBits]);
                n2 = new Integer(this.m_parity);
                if (PARITY.containsKey(n2)) {
                    stringBuffer.append(" ,Parity:" + PARITY.get(n2));
                }
                ++n7;
            }
            if (this.m_duplexMode != -1) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                ++n7;
                stringBuffer.append(" Duplex Mode:" + DUPLEX_MODE[this.m_duplexMode]);
                stringBuffer.append(" ,Modem Type:");
                n2 = new Integer(this.m_modemType);
                if (MODEM_TYPE.containsKey(n2)) {
                    stringBuffer.append(MODEM_TYPE.get(n2));
                } else if (this.m_modemType >= 0 && this.m_modemType <= 5) {
                    stringBuffer.append("National");
                } else if (this.m_modemType >= 32 && this.m_modemType <= 47) {
                    stringBuffer.append("National Use");
                } else if (this.m_modemType >= 48 && this.m_modemType <= 63) {
                    stringBuffer.append("User Specified");
                } else {
                    stringBuffer.append("??");
                }
            }
            if (USER_INFO_LAYER2_PROTOCOL.containsKey(n2 = new Integer(this.m_userInfoLayer2Protocol))) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                ++n7;
                stringBuffer.append(" User Info Layer 2 Protocol:" + USER_INFO_LAYER2_PROTOCOL.get(n2));
            }
            if (USER_INFO_LAYER3_PROTOCOL.containsKey(n = new Integer(this.m_userInfoLayer3Protocol))) {
                stringBuffer.append(LEInfoElement.TABS);
                stringBuffer.append(LEDiagUtil.toHexString(this.m_data[n7]));
                ++n7;
                stringBuffer.append(" User Info Layer 3 Protocol:" + USER_INFO_LAYER3_PROTOCOL.get(n));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return "Error decoding BearerIE";
        }
    }

    static {
        INFO_TRANSFER_CAPABILITY.put(new Integer(0), "Speech");
        INFO_TRANSFER_CAPABILITY.put(new Integer(8), "Unrestricted digital information");
        INFO_TRANSFER_CAPABILITY.put(new Integer(9), "Restricted Digital Information");
        INFO_TRANSFER_CAPABILITY.put(new Integer(16), "3.1 kHz audio");
        INFO_TRANSFER_CAPABILITY.put(new Integer(17), "Unrestricted digital information with tones/announcements");
        INFO_TRANSFER_CAPABILITY.put(new Integer(24), "Video");
        TRANSFERMODE = new Hashtable();
        TRANSFERMODE.put(new Integer(0), "Circuit Mode");
        TRANSFERMODE.put(new Integer(2), "Packet Mode");
        INFO_TRANSFER_RATE = new Hashtable();
        INFO_TRANSFER_RATE.put(new Integer(0), "Packet Mode Only");
        INFO_TRANSFER_RATE.put(new Integer(16), "64kbit/s");
        INFO_TRANSFER_RATE.put(new Integer(17), "2x64kbit/s");
        INFO_TRANSFER_RATE.put(new Integer(19), "384 kbit/s");
        INFO_TRANSFER_RATE.put(new Integer(21), "1536 kbit/s");
        INFO_TRANSFER_RATE.put(new Integer(23), "1920 kbit/s");
        INFO_TRANSFER_RATE.put(new Integer(24), "Multirate (64 kbit/s base rate)");
        USER_INFO_LAYER_1_PROTOCOL = new Hashtable();
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(1), "CCITT Rate Adoption V.110 and X.30");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(2), "G.711 u-Law");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(3), "G.711 A-Law");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(4), "G.721 32 kbit/s ADPCM and I.460");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(5), "H.211 and H.242");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(7), "Nonstandardized CCITT Rate Adoption");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(8), "CCITT Standardized Rate Adoption V.120");
        USER_INFO_LAYER_1_PROTOCOL.put(new Integer(9), "CCITT Standardized Rate Adoption X.31");
        SYNCH_ASYNC = new String[]{"Synchronous", "Asynchronous"};
        NEGOTIATION = new String[]{"In-band negotiation not possible", "In-Band neg."};
        USER_RATE = new Hashtable();
        USER_RATE.put(new Integer(0), "Rate is in EBits (see I.460) or may be negotiated in-band");
        USER_RATE.put(new Integer(1), "0.6 kbit/s Recommendation V.6 and X.1");
        USER_RATE.put(new Integer(2), "1.2 kbit/s Recommendation V.6");
        USER_RATE.put(new Integer(3), "2.4 kbit/s Recommendation V.6 and X.1");
        USER_RATE.put(new Integer(4), "3.6 kbit/s Recommendation V.6");
        USER_RATE.put(new Integer(5), "4.8 kbit/s Recommendation V.6 and X.1");
        USER_RATE.put(new Integer(6), "7.2 kbit/s Recommendation V.6");
        USER_RATE.put(new Integer(7), "8.0 kbit/s Recommendation I.460");
        USER_RATE.put(new Integer(8), "9.6 kbit/s Recommendation V.6 and X.1");
        USER_RATE.put(new Integer(9), "14.4 kbit/s Recommendation V.6");
        USER_RATE.put(new Integer(10), "16.0 kbit/s Recommendation I.460");
        USER_RATE.put(new Integer(11), "19.2 kbit/s Recommendation V.6");
        USER_RATE.put(new Integer(12), "32 kbit/s Recommendation I.460");
        USER_RATE.put(new Integer(14), "48 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(15), "56 kbit/s Recommendation V.6");
        USER_RATE.put(new Integer(21), "0.1345 kbit/s Recommendation X.1");
        USER_RATE.put(new Integer(22), "0.100 kbit/s Recommendation X.1");
        USER_RATE.put(new Integer(23), "0.075/1.2 kbit/s Recommendations V.6 and X.1 ");
        USER_RATE.put(new Integer(24), "1.2/0.075 kbit/s Recommendations V.6 and X.1 ");
        USER_RATE.put(new Integer(25), "0.050 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(26), "0.075 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(27), "0.110 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(28), "0.150 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(29), "0.200 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(30), "0.300 kbit/s Recommendations V.6 and X.1");
        USER_RATE.put(new Integer(31), "12 kbit/s Recommendation V.6");
        INTERMEDIATE_RATE = new String[]{"Not Used", "8 kbit/s", "16 kbit/s", "32 kbit/s"};
        REQUIRED_BIT = new String[]{"Not Required", "Required"};
        SUPPORT_BIT = new String[]{"Not Supported", "Is Supported"};
        HEADER_YES_NO = new String[]{"Not Included", "Included"};
        MULTI_FRAME = new String[]{"Establishment is Not Supported. Only UI Frames are Allowed", "Establishment is Supported"};
        MODE = new String[]{"Bit transparent mode", "Protocol Sensitive mode"};
        LLI = new String[]{"Default,LLI=256 only", "Full protocol negegotiation"};
        ASSN = new String[]{"Message originator is default assignee", "Message originator is assignor"};
        NEGOT = new String[]{"Negotiation is in USER INFORMATION messages on a temporary signaling connection", " Negotiation is in-band using logical link zero"};
        NUMBER_OF_STOP_BITS = new String[]{"Not Used", "1 bit", "1.5 bits", "2 bits"};
        NUMBER_OF_DATA_BITS = new String[]{"Not Used", "5 bits", "7 bits", "8 bits"};
        PARITY = new Hashtable();
        PARITY.put(new Integer(0), "Odd");
        PARITY.put(new Integer(2), "Even");
        PARITY.put(new Integer(3), "None");
        PARITY.put(new Integer(4), "Forced to 0");
        PARITY.put(new Integer(5), "Forced to 1");
        DUPLEX_MODE = new String[]{"Half duplex", "Full duplex"};
        MODEM_TYPE = new Hashtable();
        MODEM_TYPE.put(new Integer(17), "Recommendation V.21");
        MODEM_TYPE.put(new Integer(18), "Recommendation V.22");
        MODEM_TYPE.put(new Integer(19), "Recommendation V.22 bis");
        MODEM_TYPE.put(new Integer(20), "Recommendation V.26");
        MODEM_TYPE.put(new Integer(21), "Recommendation V.26 bis");
        MODEM_TYPE.put(new Integer(22), "Recommendation V.26 ter");
        MODEM_TYPE.put(new Integer(23), "Recommendation V.27");
        MODEM_TYPE.put(new Integer(24), "Recommendation V.26 ter");
        MODEM_TYPE.put(new Integer(25), "Recommendation V.27 bis");
        MODEM_TYPE.put(new Integer(26), "Recommendation V.27 ter");
        MODEM_TYPE.put(new Integer(27), "Recommendation V.29");
        MODEM_TYPE.put(new Integer(29), "Recommendation V.32");
        USER_INFO_LAYER2_PROTOCOL = new Hashtable();
        USER_INFO_LAYER2_PROTOCOL.put(new Integer(2), "Recomendation LAP-D ->Q.921/I.441");
        USER_INFO_LAYER2_PROTOCOL.put(new Integer(6), "Recomendation LAP-B ->X.25,link layer");
        USER_INFO_LAYER3_PROTOCOL = new Hashtable();
        USER_INFO_LAYER3_PROTOCOL.put(new Integer(2), "Recommendation Q.931/I.451");
        USER_INFO_LAYER3_PROTOCOL.put(new Integer(3), "Recommendation X.25,packet layer");
    }
}

