/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;

public class LEIECallingPartyNumber
extends LEInfoElement {
    int m_length;
    int m_typeNumber;
    int m_numberPlan;
    int m_presIndicator = -1;
    int m_screenIndicator = -1;
    String m_digits;

    public LEIECallingPartyNumber(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_typeNumber = (this.m_data[2] & 0x60) >> 4;
        this.m_numberPlan = this.m_data[2] & 0xF;
        if ((this.m_data[2] & 0x50) >> 7 == 0) {
            this.m_presIndicator = (this.m_data[3] & 0x3C) >> 5;
            this.m_screenIndicator = this.m_data[3] & 3;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_length <= this.m_data.length - 2) {
                char[] cArray = new char[this.m_length - 2];
                int n = 4;
                while (n < this.m_length + 2) {
                    cArray[n - 4] = (char)(this.m_data[n] & 0x7F);
                    ++n;
                }
                stringBuffer.append(cArray);
            } else {
                int n = 4;
                while (n < this.m_data.length) {
                    stringBuffer.append(String.valueOf(this.m_data[n] & 0x7F));
                    ++n;
                }
            }
            this.m_digits = stringBuffer.toString();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_length < this.m_data.length - 2) {
            char[] cArray = new char[this.m_data.length - 2];
            int n = 3;
            while (n < this.m_length + 2) {
                cArray[n - 3] = (char)(this.m_data[n] & 0x7F);
                ++n;
            }
            stringBuffer.append(cArray);
        } else {
            char[] cArray = new char[this.m_data.length - 2];
            int n = 3;
            while (n < this.m_data.length) {
                cArray[n - 3] = (char)(this.m_data[n] & 0x7F);
                ++n;
            }
            stringBuffer.append(cArray);
        }
        this.m_digits = stringBuffer.toString();
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tCalling Party Number Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append("Type of Number:");
        stringBuffer.append(LEInfoElement.TYPE_OF_NUMBER[this.m_typeNumber]);
        stringBuffer.append(" ,Numbering Plan:");
        Integer n = new Integer(this.m_numberPlan);
        if (LEInfoElement.NUMBER_PLAN_ID.containsKey(n)) {
            stringBuffer.append(LEInfoElement.NUMBER_PLAN_ID.get(n));
        } else {
            stringBuffer.append("RESERVED");
        }
        if (this.m_presIndicator != -1) {
            stringBuffer.append(LEInfoElement.TABS);
            stringBuffer.append(LEDiagUtil.toHexString(this.m_data[3]));
            stringBuffer.append(" Presentation Indicator:" + LEInfoElement.PRES_INDICATOR[this.m_presIndicator]);
            stringBuffer.append(" ,Screen Indicator:");
            if (this.m_screenIndicator < LEInfoElement.SCREEN_INDICATOR.length) {
                stringBuffer.append(LEInfoElement.SCREEN_INDICATOR[this.m_screenIndicator]);
            } else {
                stringBuffer.append("???");
            }
        }
        stringBuffer.append("\n\t\t\tDigits:" + this.m_digits);
        return stringBuffer.toString();
    }
}

