/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEIECauseDiagnostics;
import com.lucent.ra.nms.diag.isdn.LEIECauseValues;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;

public class LEIECause
extends LEInfoElement {
    int m_length;
    int m_codingStandard;
    int m_generalLocation;
    int m_classCauseValue;
    int m_valueCauseValue;
    int[] diagValue = new int[10];
    public static final String[] CODING_STANDARD = new String[]{"CCITT standardized coding", "ISO/IEC standard", "National standard", "Standard defined for the network present on the network side"};
    public static final String[] GENERAL_LOCATION = new String[]{"User", "Private Network Serving Local User(LPN)", "Public Network Serving Local User(LN)", "Transit Network(TN)", "Public Network Serving Remote Users(RLN)", "Remote Private Network(RPN)", "UNKNOWN", "International Network(INTL)", "UNKNOWN", "UNKNOWN", "Network Beyond Interworking Point(BI)"};

    public LEIECause(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_codingStandard = (this.m_data[2] & 6) >> 5;
        this.m_generalLocation = this.m_data[2] & 0xF;
        this.m_classCauseValue = (this.m_data[3] & 0x70) >> 4;
        this.m_valueCauseValue = this.m_data[3] & 0x7F;
        this.diagValue = new int[this.m_length - 2];
        int n = 4;
        while (n < this.m_length + 2) {
            this.diagValue[n - 4] = this.m_data[n];
            ++n;
        }
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tCause Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append(" Coding Standard:" + CODING_STANDARD[this.m_codingStandard]);
        stringBuffer.append(" ,General Location:" + GENERAL_LOCATION[this.m_generalLocation]);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[3]));
        stringBuffer.append(" Class:" + LEIECauseValues.GetClassName(this.m_classCauseValue));
        stringBuffer.append(" ,Value:" + LEIECauseValues.GetDescription(this.m_valueCauseValue));
        if (this.diagValue.length > 0) {
            int n = 0;
            while (n < this.diagValue.length) {
                stringBuffer.append("\n\t\t\tDiagnostic Value:");
                stringBuffer.append(LEIECauseDiagnostics.GetContentofOctet(this.diagValue[n]));
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

