/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.mdp;

import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.diag.LEDiagFactory;
import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.LESmartDebugFactory;
import com.lucent.ra.nms.diag.mdp.LEMDPBindMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPBoundMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPCalleXStationIDMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPDeactivateMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPDebugMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPReadyMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import java.util.Hashtable;

public class LEMDPDebugFactory
extends LEObservable
implements LEDiagFactory {
    protected static Hashtable s_managers = new Hashtable();
    private static boolean s_debugenabled;
    protected static Hashtable s_pms;
    public static final String TYPE_CALLER_STATION_ID = "Caller-Station-ID";
    public static final String TYPE_BOUND = "bound";
    public static final String TYPE_BIND = "mdp_bind";
    public static final String MDP_READY = "mdp2_psm: READY";
    public static final String MDP_READY_STATE = "ready state";
    public static final String MDP_DEACTIVATE = "mdp_deactivate: from";

    public LEMDPDebugFactory(String string) {
        LESmartDebugFactory lESmartDebugFactory = LESmartDebugFactory.GetFactory();
        lESmartDebugFactory.registerFactory("TYPE_MDP", this, string);
    }

    public static LEMDPDebugFactory addObserver(LEPortMaster lEPortMaster, LEObserver lEObserver) {
        String string = lEPortMaster.getResourceID();
        LEMDPDebugFactory lEMDPDebugFactory = (LEMDPDebugFactory)s_managers.get(string);
        s_pms.put(string, lEPortMaster);
        if (lEMDPDebugFactory == null) {
            lEMDPDebugFactory = new LEMDPDebugFactory(string);
            s_managers.put(string, lEMDPDebugFactory);
            lEMDPDebugFactory.addObserver(lEObserver);
        } else {
            lEMDPDebugFactory.addObserver(lEObserver);
        }
        LEMDPDebugFactory.setDebugFlags(lEPortMaster);
        return lEMDPDebugFactory;
    }

    public static String addObserver(String string, LEObserver lEObserver) {
        LEMDPDebugFactory lEMDPDebugFactory = (LEMDPDebugFactory)s_managers.get(string = LEDiagUtil.BuildDescriptiveID(string));
        if (lEMDPDebugFactory == null) {
            lEMDPDebugFactory = new LEMDPDebugFactory(string);
            s_managers.put(string, lEMDPDebugFactory);
            lEMDPDebugFactory.addObserver(lEObserver);
            return "Reading " + string + "\n";
        }
        lEMDPDebugFactory.addObserver(lEObserver);
        return "Reading" + string + "\n";
    }

    public LEDiagFactory getResourceFactory(String string) {
        return (LEDiagFactory)s_managers.get(string);
    }

    public void process(LEDebugMessage lEDebugMessage) {
        LEMDPDebugMessage lEMDPDebugMessage = new LEMDPDebugMessage(lEDebugMessage);
        LEMDPDebugMessage lEMDPDebugMessage2 = this.processMDPMessage(lEMDPDebugMessage);
        this.notifyObservers(lEMDPDebugMessage2);
    }

    LEMDPDebugMessage processMDPMessage(LEMDPDebugMessage lEMDPDebugMessage) {
        String string = lEMDPDebugMessage.getData();
        LEMDPDebugMessage lEMDPDebugMessage2 = string.indexOf(TYPE_CALLER_STATION_ID) != -1 ? new LEMDPCalleXStationIDMessage(lEMDPDebugMessage) : (string.indexOf(TYPE_BOUND) != -1 ? new LEMDPBoundMessage(lEMDPDebugMessage) : (string.indexOf(TYPE_BIND) != -1 ? new LEMDPBoundMessage(new LEMDPBindMessage(lEMDPDebugMessage)) : (string.indexOf(MDP_READY) != -1 ? new LEMDPReadyMessage(lEMDPDebugMessage) : (string.indexOf(MDP_READY_STATE) != -1 ? new LEMDPReadyMessage(lEMDPDebugMessage) : (string.indexOf(MDP_DEACTIVATE) != -1 ? new LEMDPDeactivateMessage(lEMDPDebugMessage) : lEMDPDebugMessage)))));
        return lEMDPDebugMessage2;
    }

    public static boolean setDebugFlags(LEPortMaster lEPortMaster) {
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade != null) {
            lEPortMaster.execute("set deb mdp-max");
            return LEMDPDebugFactory.SendDebugCommand(lEPMConnectionFacade, -1);
        }
        return false;
    }

    static boolean SendDebugCommand(LEPMConnectionFacade lEPMConnectionFacade, int n) {
        return lEPMConnectionFacade.startDebug(196608, 28, n);
    }

    public static void removeObserver(String string, LEObserver lEObserver) {
        if (lEObserver == null || string == null) {
            return;
        }
        LEMDPDebugFactory lEMDPDebugFactory = (LEMDPDebugFactory)s_managers.get(string);
        if (lEMDPDebugFactory != null) {
            lEMDPDebugFactory.deleteObserver(lEObserver);
            if (lEMDPDebugFactory.countObservers() == 0) {
                lEMDPDebugFactory.stopDebugging(string);
            }
        }
    }

    private void stopDebugging(String string) {
        LEPortMaster lEPortMaster = (LEPortMaster)s_pms.get(string);
        if (lEPortMaster != null) {
            LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
            if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
                return;
            }
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            if (lEPMConnectionFacade != null) {
                lEPMConnectionFacade.stopDebug(196608, 28, -1);
            }
        }
    }

    public static boolean ChangeBoards(LEPortMaster lEPortMaster, int n, int n2) {
        String string = lEPortMaster.getResourceID();
        if (!s_pms.containsKey(string)) {
            return false;
        }
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade == null) {
            return false;
        }
        if (n >= 0) {
            lEPortMaster.execute("set view" + n);
            lEPortMaster.execute("set deb mdp-max off");
            lEPMConnectionFacade.stopDebug(196608, 28, n);
        }
        if (lEPortMaster.getHardwareType().equals("PM-4")) {
            lEPortMaster.execute("set view" + n2);
        }
        lEPortMaster.execute("set deb mdp-max");
        return LEMDPDebugFactory.SendDebugCommand(lEPMConnectionFacade, n2);
    }

    static {
        s_pms = new Hashtable();
    }
}

