/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPOptionList;
import com.lucent.ra.nms.util.LEDebug;
import java.util.Hashtable;

public class LEPPPBAPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private String m_responseCode;
    private LEPPPOptionList m_optionList;
    public static final Hashtable BAP_OPTIONS = new Hashtable();
    public static final String BAP_CALL_REQUEST = "01";
    public static final String BAP_CALL_RESPONSE = "02";
    public static final String BAP_CALLBACK_REQUEST = "03";
    public static final String BAP_CALLBACK_RESPONSE = "04";
    public static final String BAP_LINK_DROP_QUERY_REQUEST = "05";
    public static final String BAP_LINK_DROP_QUERY_RESPONSE = "06";
    public static final String BAP_CALL_STATUS_INDICATION = "07";
    public static final String BAP_CALL_STATUS_RESPONSE = "08";
    public static final Hashtable BAP_CODES;
    public static final Hashtable BAP_RESPONSE_CODES;
    public static final String[] BAP_RESPONSE_CODES2;
    public static final String[] LINK_TYPE;
    public static final String[] PHONE_DELTA_SUB_OPTIONS;

    public LEPPPBAPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPBAPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_optionList = lEPPPOptionList;
    }

    void setCode(String string) {
        this.m_code = string;
    }

    public String getCode() {
        return this.m_code;
    }

    void setID(String string) {
        this.m_id = string;
    }

    public String getID() {
        return this.m_id;
    }

    void setLength(String string) {
        this.m_length = string;
    }

    public String getLength() {
        return this.m_length;
    }

    void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHexData();
        if (string.length() >= 12) {
            try {
                String string2 = string.substring(0, 2);
                String string3 = string.substring(3, 5);
                String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
                this.m_code = string2;
                this.m_id = string3;
                this.m_length = string4;
                if (this.m_code.equals(BAP_CALL_RESPONSE) || this.m_code.equals(BAP_CALLBACK_RESPONSE) || this.m_code.equals(BAP_LINK_DROP_QUERY_RESPONSE) || this.m_code.equals(BAP_CALL_STATUS_RESPONSE)) {
                    this.m_responseCode = string.substring(12, 14);
                    if (string.length() > 15) {
                        this.m_optionList = new LEPPPOptionList(string.substring(15));
                        return;
                    }
                    this.m_optionList = null;
                    return;
                }
                if (string.length() > 12) {
                    this.m_optionList = new LEPPPOptionList(string.substring(12));
                    return;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\t[BAP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        if (this.m_optionList != null) {
            LEPPPOptionList lEPPPOptionList = this.m_optionList;
            while (lEPPPOptionList != null) {
                String string = lEPPPOptionList.getOption();
                if (this.m_code.equals(BAP_CALL_RESPONSE) || this.m_code.equals(BAP_CALLBACK_RESPONSE) || this.m_code.equals(BAP_LINK_DROP_QUERY_RESPONSE) || this.m_code.equals(BAP_CALL_STATUS_RESPONSE)) {
                    stringBuffer.append("\n\t Response Code:");
                    int n = Integer.parseInt(this.m_responseCode, 16);
                    stringBuffer.append("[0x");
                    stringBuffer.append(this.m_responseCode);
                    stringBuffer.append("] ");
                    if (n < BAP_RESPONSE_CODES2.length) {
                        stringBuffer.append(BAP_RESPONSE_CODES2[n]);
                    }
                }
                stringBuffer.append("\n\t\t");
                if (BAP_OPTIONS.containsKey(string)) {
                    String string2 = (String)BAP_OPTIONS.get(string);
                    stringBuffer.append(string2);
                    stringBuffer.append("[0x");
                    stringBuffer.append(string);
                    stringBuffer.append("], length: (");
                    stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                    stringBuffer.append(" bytes)");
                } else {
                    stringBuffer.append("[0x");
                    stringBuffer.append(string);
                    stringBuffer.append("], length: (");
                    stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                    stringBuffer.append(" bytes)");
                }
                stringBuffer.append(this.processBAPOptions(lEPPPOptionList));
                lEPPPOptionList = lEPPPOptionList.getNextOptionList();
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String processBAPOptions(LEPPPOptionList lEPPPOptionList) {
        String string = lEPPPOptionList.getOption();
        lEPPPOptionList.getILength();
        String string2 = lEPPPOptionList.getData();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equals(BAP_CALL_REQUEST)) {
            StringBuffer stringBuffer2 = new StringBuffer(string2.substring(0, 2));
            stringBuffer2.append(string2.substring(3, 5));
            stringBuffer.append("\n\t\tLinkSpeed:");
            stringBuffer.append(Integer.valueOf(stringBuffer2.toString(), 16));
            stringBuffer.append("kbps ");
            stringBuffer.append("[0x");
            stringBuffer.append((Object)stringBuffer2);
            stringBuffer.append("]\n\t\tLink Types: ");
            String string3 = string2.substring(6, 8);
            int n = Integer.parseInt(string3, 16);
            Integer.toBinaryString(n);
            int n2 = 0;
            while (n2 <= 4) {
                if ((n & 1 << n2) != 0) {
                    stringBuffer.append(LINK_TYPE[n2]);
                    stringBuffer.append(", ");
                }
                ++n2;
            }
        } else if (string.equals(BAP_CALL_RESPONSE)) {
            LEPPPOptionList lEPPPOptionList2;
            LEPPPOptionList lEPPPOptionList3 = lEPPPOptionList2 = new LEPPPOptionList(string2);
            while (lEPPPOptionList3 != null) {
                stringBuffer.append("\n\t\tSub Option Type: ");
                String string4 = lEPPPOptionList3.getOption();
                String string5 = lEPPPOptionList3.getData();
                if (string4.equals(BAP_CALL_REQUEST)) {
                    stringBuffer.append(PHONE_DELTA_SUB_OPTIONS[1]);
                    stringBuffer.append("[0x");
                    stringBuffer.append(string5);
                    stringBuffer.append("] ");
                    stringBuffer.append(Integer.valueOf(string5, 16));
                } else if (string4.equals(BAP_CALL_RESPONSE)) {
                    stringBuffer.append(PHONE_DELTA_SUB_OPTIONS[2]);
                    stringBuffer.append(": ");
                    stringBuffer.append(LEDiagUtil.hex2str(string5, string5.length()));
                } else if (string4.equals(BAP_CALLBACK_REQUEST)) {
                    stringBuffer.append(PHONE_DELTA_SUB_OPTIONS[3]);
                    stringBuffer.append(": ");
                    stringBuffer.append(LEDiagUtil.hex2str(string5, string5.length()));
                } else {
                    stringBuffer.append("UNKNOWN");
                    return stringBuffer.toString();
                }
                lEPPPOptionList3 = lEPPPOptionList3.getNextOptionList();
            }
        } else if (!string.equals(BAP_CALLBACK_REQUEST)) {
            if (string.equals(BAP_CALLBACK_RESPONSE)) {
                stringBuffer.append("\n\t\tReason String:");
                stringBuffer.append(LEDiagUtil.hex2str(string2, string2.length()));
            } else if (string.equals(BAP_LINK_DROP_QUERY_REQUEST)) {
                String string6 = string2.substring(0, 2);
                int n = Integer.parseInt(string6, 16);
                if (n == 0) {
                    stringBuffer.append("\n\t\tStatus: Call Was Successful");
                } else {
                    stringBuffer.append("\n\t\tStatus: Unsuccessful, Reason:");
                    stringBuffer.append(n);
                }
                String string7 = string2.substring(3, 5);
                int n3 = Integer.parseInt(string7, 16);
                if (n3 == 0) {
                    stringBuffer.append(" ,No retry");
                } else {
                    stringBuffer.append(" ,Retry");
                }
            } else {
                stringBuffer.append("\n\t\tUnknown Option");
            }
        }
        return stringBuffer.toString();
    }

    static {
        BAP_OPTIONS.put(BAP_CALL_REQUEST, "Link-Type");
        BAP_OPTIONS.put(BAP_CALL_RESPONSE, "Phone-Delta");
        BAP_OPTIONS.put(BAP_CALLBACK_REQUEST, "No-Phone-Number-Needed");
        BAP_OPTIONS.put(BAP_CALLBACK_RESPONSE, "Reason");
        BAP_OPTIONS.put(BAP_LINK_DROP_QUERY_REQUEST, "Link-Discriminator");
        BAP_OPTIONS.put(BAP_LINK_DROP_QUERY_RESPONSE, "Call-Status");
        BAP_CODES = new Hashtable();
        BAP_CODES.put(BAP_CALL_REQUEST, "Call-Request");
        BAP_CODES.put(BAP_CALL_RESPONSE, "Call-Response");
        BAP_CODES.put(BAP_CALLBACK_REQUEST, "Callback-Request");
        BAP_CODES.put(BAP_CALLBACK_RESPONSE, "Callback-Response");
        BAP_CODES.put(BAP_LINK_DROP_QUERY_REQUEST, "Link-Drop-Query-Request");
        BAP_CODES.put(BAP_LINK_DROP_QUERY_RESPONSE, "Link-Drop-Query-Response");
        BAP_CODES.put(BAP_CALL_STATUS_INDICATION, "Call-Status-Indication");
        BAP_CODES.put(BAP_CALL_STATUS_RESPONSE, "Call-Status-Response");
        BAP_RESPONSE_CODES = new Hashtable();
        BAP_RESPONSE_CODES.put("00000000", "Request-Ack");
        BAP_RESPONSE_CODES.put("00000001", "Request-Nak");
        BAP_RESPONSE_CODES.put("00000010", "Request-Rej");
        BAP_RESPONSE_CODES.put("00000011", "Request-Full-Nak");
        BAP_RESPONSE_CODES2 = new String[]{"Request-Ack", "Request-Nak", "Request-Rej", "Request-Full-Nak"};
        LINK_TYPE = new String[]{"ISDN", "X.25", "analog", "switched digital(non-ISDN)", "ISDN data over voice"};
        PHONE_DELTA_SUB_OPTIONS = new String[]{"UNKNOWN", "Unique-Digits", "Subscriber-Number", "Phone-Number-Sub-Address"};
    }
}

