/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPOptionList;
import com.lucent.ra.nms.util.LEDebug;

public class LEPPPIPXCPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList m_ol;
    public static final String[] IPXCP_OPTIONS = new String[]{"01", "IPX-Network-Number", "02", "IPX-Node-Number", "03", "IPX-Compression-Protocol", "04", "IPX-Routing-Protocol", "05", "IPX-Router-Name", "06", "IPX-configuration-Complete"};

    public LEPPPIPXCPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPIPXCPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPIPXCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPIPXCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList lEPPPOptionList) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_ol = lEPPPOptionList;
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_ol = lEPPPOptionList;
    }

    void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHexData();
        if (string == null) {
            return;
        }
        try {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
            this.m_code = string2;
            this.m_id = string3;
            this.m_length = string4;
            if (string.length() > 12) {
                LEPPPOptionList lEPPPOptionList = new LEPPPOptionList(string.substring(12));
                this.setOptionList(lEPPPOptionList);
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return new String(this.getValue());
        }
        StringBuffer stringBuffer = new StringBuffer("\t[IPXCP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        try {
            if (this.m_ol != null) {
                LEPPPOptionList lEPPPOptionList = this.m_ol;
                while (lEPPPOptionList != null) {
                    String string;
                    int n = 0;
                    while (n < IPXCP_OPTIONS.length) {
                        if (IPXCP_OPTIONS[n].equals(lEPPPOptionList.getOption())) break;
                        n += 2;
                    }
                    if (n + 1 < IPXCP_OPTIONS.length) {
                        stringBuffer.append("\n\t ");
                        stringBuffer.append(IPXCP_OPTIONS[n + 1]);
                        stringBuffer.append("[0x");
                        stringBuffer.append(lEPPPOptionList.getOption());
                        stringBuffer.append("], length: (");
                        stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                        stringBuffer.append(" bytes)");
                    }
                    if ((string = lEPPPOptionList.getData()) != null && !string.equals("")) {
                        String string2 = new String(String.valueOf(lEPPPOptionList.getData().substring(0, 2)) + lEPPPOptionList.getData().substring(3, 5)).toUpperCase();
                        n = 0;
                        while (n < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                            if (LEPPPDebugMessage.PROTOCOL_LIST[n].equals(string2)) break;
                            n += 2;
                        }
                        if (n + 1 < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                            stringBuffer.append(LEPPPDebugMessage.PROTOCOL_LIST[n + 1]);
                            stringBuffer.append("[0x");
                            stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                            stringBuffer.append("]");
                        }
                    }
                    stringBuffer.append("\n");
                    lEPPPOptionList = lEPPPOptionList.getNextOptionList();
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

