/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.util.LEDebug;

public class LEPPPPAPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private String m_login;
    private String m_loginlength;
    private String m_loginvalue;
    private String m_password;
    private String m_passlength;
    private String m_passvalue;
    public static final String AUTH_REQ = new String("01");
    public static final String AUTH_ACK = new String("02");
    public static final String AUTH_NAK = new String("03");

    public LEPPPPAPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPPAPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPPAPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_login = string4;
        this.m_loginlength = string5;
        this.m_loginvalue = string6;
        this.m_password = string7;
        this.m_passlength = string8;
        this.m_passvalue = string9;
    }

    public String getCode() {
        return this.m_code;
    }

    protected void setLoginLength(String string) {
        this.m_loginlength = string;
    }

    public String getLoginLength() {
        return this.m_loginlength;
    }

    protected void setLogin(String string) {
        this.m_login = string;
    }

    protected void setLoginValue(String string) {
        this.m_loginvalue = string;
    }

    public String getLoginValue() {
        return this.m_loginvalue;
    }

    protected void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    protected void setPasswordLength(String string) {
        this.m_passlength = string;
    }

    public String getPasswordLength() {
        return this.m_passlength;
    }

    protected void setPasswordValue(String string) {
        this.m_passvalue = string;
    }

    public String getPasswordValue() {
        return this.m_passvalue;
    }

    public String getLoginID() {
        if (this.m_code.equals("01")) {
            return this.m_login;
        }
        return null;
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer("\t[PAP] Packet Info:  Code: ");
        try {
            stringBuffer.append(this.m_code);
            stringBuffer.append(",  ID: ");
            stringBuffer.append(this.m_id);
            stringBuffer.append(", ");
            stringBuffer.append(this.m_length);
            stringBuffer.append(" bytes.");
            if (this.m_code.equals("01")) {
                stringBuffer.append("\n\tLogin ID: ");
                stringBuffer.append(this.m_login);
                stringBuffer.append(" (");
                stringBuffer.append(LEDiagUtil.hex2decStr(this.m_loginlength));
                stringBuffer.append(" bytes), [0x");
                stringBuffer.append(this.m_loginvalue);
                stringBuffer.append("]");
                stringBuffer.append("\n\tPassword: ");
                stringBuffer.append(this.m_password);
                stringBuffer.append(" (");
                stringBuffer.append(LEDiagUtil.hex2decStr(this.m_passlength));
                stringBuffer.append(" bytes), [0x");
                stringBuffer.append(this.m_passvalue);
                stringBuffer.append("]");
            } else {
                stringBuffer.append("\n\tMessage:  ");
                stringBuffer.append(this.m_login);
                stringBuffer.append(" (");
                stringBuffer.append(LEDiagUtil.hex2decStr(this.m_loginlength));
                stringBuffer.append(" bytes), [0x");
                stringBuffer.append(this.m_loginvalue);
                stringBuffer.append("]");
            }
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string;
        String string2;
        String string3 = lEPPPDebugMessage.getHexData();
        if (string3 == null || string3.length() < 12) return;
        try {
            string2 = string3.substring(0, 2);
            String string4 = string3.substring(3, 5);
            string = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string3.substring(6, 11)));
            this.m_code = string2;
            this.m_id = string4;
            this.m_length = string;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            return;
        }
        if (string3.substring(0, 2).equals("01")) {
            try {
                if (string3.length() < 11) return;
                string2 = string3.substring(9, 11);
                int n = Integer.parseInt(string2, 16);
                n = n * 3 - 1;
                string = string3.substring(12, n);
                String string5 = string.substring(3);
                this.setLoginLength(string.substring(0, 2));
                n = LEDiagUtil.hex2dec(string.substring(0, 2));
                this.setLogin(LEDiagUtil.hex2str(string5, n));
                this.setLoginValue(LEDiagUtil.outhex(string.substring(2, n * 3 + 2)));
                string = string5.substring(n * 3);
                this.setPasswordLength(string.substring(0, 2));
                n = LEDiagUtil.hex2dec(this.getPasswordLength());
                if (n <= 0) return;
                this.setPassword(LEDiagUtil.hex2str(string.substring(3), n));
                this.setPasswordValue(LEDiagUtil.outhex(string.substring(2, n * 3 + 2)));
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                LEDebug.getLog().logln(20, lEPPPDebugMessage.getData());
                LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                return;
            }
        } else {
            try {
                string2 = string3.substring(9, 11);
                int n = Integer.parseInt(string2, 16);
                n = n * 3 - 1;
                string = string3.substring(12, n);
                String string6 = string.substring(3);
                n = LEDiagUtil.hex2dec(string.substring(0, 2));
                this.setLogin(LEDiagUtil.hex2str(string6, n));
                this.setLoginLength(string.substring(0, 2));
                this.setLoginValue(LEDiagUtil.outhex(string.substring(2, n * 3 + 2)));
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                return;
            }
        }
    }
}

