/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;

public class LEPVCFormLine
extends Panel
implements LEFormLine {
    static final int MAX_VPI = 255;
    static final int MAX_VCI = 65535;
    LEPortMaster m_pm;
    LETextField m_vpi;
    LETextField m_vci;
    String m_valid;
    LEFormLineListener m_listener;

    public LEPVCFormLine() {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.add(new Label("VPI:", 0));
        this.m_vpi = new LETextField(3);
        this.m_vpi.setNumeric(true);
        this.add(this.m_vpi);
        this.m_vci = new LETextField(5);
        this.m_vci.setNumeric(true);
        this.add(new Label("VCI:", 0));
        this.add(this.m_vci);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.indexOf(".");
            if (n > -1) {
                this.m_vpi.setText(string.substring(0, n));
                this.m_vci.setText(string.substring(n + 1));
                return;
            }
            this.m_vpi.setText("");
            this.m_vci.setText("");
        }
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_vpi.getText());
        stringBuffer.append(".");
        stringBuffer.append(this.m_vci.getText());
        return new String(stringBuffer);
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("VPI is between 0 and ");
            stringBuffer.append(255);
            stringBuffer.append(". VCI is between 0 and ");
            stringBuffer.append(65535);
            stringBuffer.append(".");
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        return this.getValue().equals(object);
    }

    public boolean isValueValid() {
        String string = this.m_vpi.getText();
        String string2 = this.m_vci.getText();
        try {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            if (n < 0 && n > 255) {
                return false;
            }
            if (n2 < 0 && n2 > 65535) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

