/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_RI;
import com.lucent.ra.nms.backend.LEMonitorSetting;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEMonitorFacility
implements LEAMObserver {
    public static final int NO_BOARD = -1;
    public static final String NO_GROUP = LEMonitorFacility_RI.NO_GROUP;
    public static final String NO_START = LEMonitorFacility_RI.NO_START;
    public static final String NO_END = LEMonitorFacility_RI.NO_END;
    public static final int DEFAULT_INTERVAL = 60000;
    Hashtable m_mons = new Hashtable();
    LEPMConnectionFacade m_facade;
    LEMonitorFacility_R m_facility;

    public LEMonitorFacility(LEPMConnectionFacade lEPMConnectionFacade, LEMonitorFacility_R lEMonitorFacility_R, String string) {
        this.m_facade = lEPMConnectionFacade;
        this.m_facility = lEMonitorFacility_R;
        LEStatusFactory.GetFactory().addObserver(string, this);
    }

    public boolean startMonitor(int n, int n2, String string, String string2, String string3, int n3) {
        LEMonitorSetting lEMonitorSetting;
        boolean bl = false;
        String string4 = LEMonitorSetting.BuildKey(n, n2, string2, string3, string);
        LEMonitorFacility lEMonitorFacility = this;
        synchronized (lEMonitorFacility) {
            lEMonitorSetting = (LEMonitorSetting)this.m_mons.get(string4);
            if (lEMonitorSetting == null) {
                lEMonitorSetting = new LEMonitorSetting(n, n2, string, string2, string3, string4);
                this.m_mons.put(string4, lEMonitorSetting);
            }
        }
        try {
            if (this.m_facility != null) {
                bl = this.m_facility.startMonitor(n, n2, string, string2, string3, n3);
            }
            lEMonitorSetting.addInterval(n3);
        }
        catch (RemoteException remoteException) {
            this.m_facade.handleRemoteException(remoteException);
            bl = false;
        }
        return bl;
    }

    public void stopMonitor(int n, int n2, String string, String string2, String string3, int n3) {
        String string4 = LEMonitorSetting.BuildKey(n, n2, string2, string3, string);
        LEMonitorSetting lEMonitorSetting = (LEMonitorSetting)this.m_mons.get(string4);
        if (lEMonitorSetting != null) {
            lEMonitorSetting.removeInterval(n3);
            if (lEMonitorSetting.getIntervalCount() == 0) {
                this.m_mons.remove(string4);
            }
        }
        try {
            if (this.m_facility != null) {
                this.m_facility.stopMonitor(n, n2, string, string2, string3, n3);
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.m_facade.handleRemoteException(remoteException);
        }
    }

    public void reconnect() {
        LEDSSPortMaster lEDSSPortMaster = (LEDSSPortMaster)this.m_facade.getDSS();
        this.m_facility = lEDSSPortMaster != null ? lEDSSPortMaster.getMonitorFacility() : null;
        if (this.m_facility == null) {
            return;
        }
        try {
            Enumeration enumeration = this.m_mons.elements();
            while (enumeration.hasMoreElements()) {
                this.m_facility.startMonitor((LEMonitorSetting)enumeration.nextElement());
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.m_facade.handleRemoteException(remoteException);
            return;
        }
    }

    public void lostConnection() {
        this.m_facility = null;
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        int n;
        if (object instanceof LEStatusMessage && (n = ((LEStatusMessage)object).getStatus()) == 1) {
            this.reconnect();
        }
    }
}

