/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDLCIList;
import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEPort;
import com.lucent.ra.nms.util.LEVector;

public class LESyncPort
extends LEPort {
    public static final String COMPRESSION = Integer.toString(290);
    public static final String DESTINATION = Integer.toString(74);
    public static final String DLCI_LIST = "dlci";
    public static final String IP_DLCI_TAB = Integer.toString(305);
    public static final String IPSEC_ACTIVE_PROFILE = "501";
    public static final String IPSEC_LOG_CONSOLE = "499";
    public static final String IPSEC_LOG_FAILURE = "496";
    public static final String IPSEC_LOG_SUCCESS = "497";
    public static final String IPSEC_LOG_SYSLOG = "498";
    public static final String IPSEC_OUTSRC_PROFILE = "500";
    public static final String IPSEC_PASSIVE_PROFILE = "502";
    public static final String IPSEC_PDA = "503";
    public static final String IPX_DLCI_TAB = Integer.toString(306);
    public static final String GROUP = Integer.toString(129);
    public static final String HANGUP = Integer.toString(332);
    public static final String IDLE_TIMEOUT = Integer.toString(297);
    public static final String INPUT_FILTER = Integer.toString(193);
    public static final String IPX_NETWORK = Integer.toString(189);
    public static final String LOCAL_IP = Integer.toString(177);
    public static final String LMI_TIMER = Integer.toString(319);
    public static final String LMI_TYPE = Integer.toString(318);
    public static final String MODEM_CONTROL = Integer.toString(316);
    public static final String MTU = Integer.toString(295);
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = Integer.toString(15);
    public static final String NETWORK_TYPE = Integer.toString(312);
    public static final String OSPF = Integer.toString(181);
    public static final String OUTPUT_FILTER = Integer.toString(194);
    public static final String PROTOCOL = Integer.toString(289);
    public static final String RIP_COST = "198";
    public static final String RIP = "rip";
    public static final String RIP_V2 = "rip_v2";
    public static final String SPEED = Integer.toString(130);
    public static final String XBAR_ADDR = "72";
    public static final int KEY_COUNT = 44;
    public static final String LMI = "lmi";
    public static final String ANNEXD = "annex-d";
    public static final String NONE = "none";
    public static final String PPP = "ppp";
    public static final String FRAME = "frame";
    public static final String BROAD = "broadcast";
    public static final String LISTEN = "listen";
    public static final String V2 = "v2 enabled";
    public static final String MULTICAST = "multicast";
    public static final String COMPATABILITY = "v1-compatability";
    public static final String RESET = "reset ";
    static String[] s_keys = null;
    boolean m_reboot = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[44];
            int n = 0;
            LESyncPort.s_keys[n++] = COMPRESSION;
            LESyncPort.s_keys[n++] = DESTINATION;
            LESyncPort.s_keys[n++] = DLCI_LIST;
            LESyncPort.s_keys[n++] = GROUP;
            LESyncPort.s_keys[n++] = HANGUP;
            LESyncPort.s_keys[n++] = IDLE_TIMEOUT;
            LESyncPort.s_keys[n++] = INPUT_FILTER;
            LESyncPort.s_keys[n++] = IP_DLCI_TAB;
            LESyncPort.s_keys[n++] = IPSEC_ACTIVE_PROFILE;
            LESyncPort.s_keys[n++] = IPSEC_LOG_FAILURE;
            LESyncPort.s_keys[n++] = IPSEC_LOG_SUCCESS;
            LESyncPort.s_keys[n++] = IPSEC_LOG_SYSLOG;
            LESyncPort.s_keys[n++] = IPSEC_LOG_CONSOLE;
            LESyncPort.s_keys[n++] = IPSEC_OUTSRC_PROFILE;
            LESyncPort.s_keys[n++] = IPSEC_PASSIVE_PROFILE;
            LESyncPort.s_keys[n++] = IPSEC_PDA;
            LESyncPort.s_keys[n++] = IPX_DLCI_TAB;
            LESyncPort.s_keys[n++] = IPX_NETWORK;
            LESyncPort.s_keys[n++] = LMI_TYPE;
            LESyncPort.s_keys[n++] = LMI_TIMER;
            LESyncPort.s_keys[n++] = LOCAL_IP;
            LESyncPort.s_keys[n++] = MODEM_CONTROL;
            LESyncPort.s_keys[n++] = MTU;
            LESyncPort.s_keys[n++] = NAT_TCP_TIMEOUT;
            LESyncPort.s_keys[n++] = NAT_OTHER_TIMEOUT;
            LESyncPort.s_keys[n++] = NAT_FAIL_ACTION;
            LESyncPort.s_keys[n++] = NAT_IN_MAP;
            LESyncPort.s_keys[n++] = NAT_PROXY_IN_MAP;
            LESyncPort.s_keys[n++] = NAT_OUT_MAP;
            LESyncPort.s_keys[n++] = NAT_PROXY_OUT_MAP;
            LESyncPort.s_keys[n++] = NAT_LOG_FAILURE;
            LESyncPort.s_keys[n++] = NAT_LOG_SUCCESS;
            LESyncPort.s_keys[n++] = NAT_LOG_SYSLOG;
            LESyncPort.s_keys[n++] = NAT_LOG_CONSOLE;
            LESyncPort.s_keys[n++] = NETMASK;
            LESyncPort.s_keys[n++] = NETWORK_TYPE;
            LESyncPort.s_keys[n++] = OUTPUT_FILTER;
            LESyncPort.s_keys[n++] = OSPF;
            LESyncPort.s_keys[n++] = PROTOCOL;
            LESyncPort.s_keys[n++] = RIP_COST;
            LESyncPort.s_keys[n++] = RIP;
            LESyncPort.s_keys[n++] = RIP_V2;
            LESyncPort.s_keys[n++] = SPEED;
            LESyncPort.s_keys[n++] = XBAR_ADDR;
        }
        return s_keys;
    }

    public LESyncPort(LEConnectionFacade lEConnectionFacade, String string, String string2) {
        super(lEConnectionFacade, string, string2);
    }

    public Object clone() {
        LESyncPort lESyncPort = new LESyncPort(this.m_facade, this.m_board, this.m_name);
        lESyncPort.copy(this);
        return lESyncPort;
    }

    public boolean requiresReset(String string) {
        return string.equals(PROTOCOL);
    }

    LEConfig createConfig(String string) {
        if (string.equals(IP_DLCI_TAB)) {
            return new LEDLCITable(this.m_facade, this.m_board, this.m_name, "ipdlci");
        }
        if (string.equals(IPX_DLCI_TAB)) {
            return new LEDLCITable(this.m_facade, this.m_board, this.m_name, "ipxdlci");
        }
        return new LEDLCIList(this.m_facade, this.m_name);
    }

    boolean getAllCommands(LEVector lEVector) {
        boolean bl = super.getAllCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            lEVector.addElement(RESET + this.m_name);
            this.m_reboot = false;
        }
        return bl;
    }

    boolean getChangedCommands(LEVector lEVector) {
        boolean bl = super.getChangedCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            lEVector.addElement(RESET + this.m_name);
            this.m_reboot = false;
        }
        return bl;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        String string;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(NETWORK_TYPE)) {
            this.makeTypeCommand(lEVector2, null, (String)this.get(NETWORK_TYPE), null);
        }
        if (bl || lEVector.contains(COMPRESSION)) {
            this.makeSetCommand(lEVector2, this.m_name, COMPRESSION, "compression");
        }
        if ((bl || lEVector.contains(DESTINATION)) && (string = (String)this.get(DESTINATION)) != null && !string.equals("")) {
            this.makeSetCommand(lEVector2, this.m_name, DESTINATION, "destination");
        }
        if (bl || lEVector.contains(GROUP)) {
            this.makeSetCommand(lEVector2, this.m_name, GROUP, "group");
        }
        if (bl || lEVector.contains(HANGUP)) {
            this.makeSetCommand(lEVector2, this.m_name, HANGUP, "hangup");
        }
        if (bl || lEVector.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(lEVector2, this.m_name, IDLE_TIMEOUT, "idletime");
        }
        if (bl || lEVector.contains(INPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (bl || lEVector.contains(IPX_NETWORK)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (bl || lEVector.contains(LMI_TYPE) || lEVector.contains(LMI_TIMER)) {
            string = (String)this.get(LMI_TYPE);
            String string2 = (String)this.get(LMI_TIMER);
            if (string == null || string.equals(NONE)) {
                string = LMI;
                string2 = "0";
            }
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer("set ");
                stringBuffer.append(this.m_name);
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                lEVector2.addElement(new String(stringBuffer));
            }
        }
        if (bl || lEVector.contains(LOCAL_IP)) {
            this.makeSetCommand(lEVector2, this.m_name, LOCAL_IP, "address");
        }
        if (bl || lEVector.contains(MODEM_CONTROL)) {
            this.makeSetCommand(lEVector2, this.m_name, MODEM_CONTROL, "cd");
        }
        if (bl || lEVector.contains(MTU)) {
            this.makeSetCommand(lEVector2, this.m_name, MTU, "mtu");
        }
        if (bl || lEVector.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(lEVector2, this.m_name, NAT_FAIL_ACTION);
        }
        if (bl || lEVector.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_IN_MAP, true, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (bl || lEVector.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (bl || lEVector.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (bl || lEVector.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, this.m_name, NETMASK, "netmask");
        }
        if (bl || lEVector.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (bl || lEVector.contains(OSPF)) {
            this.makeSetCommand(lEVector2, this.m_name, OSPF, "ospf");
        }
        if (bl || lEVector.contains(PROTOCOL)) {
            this.m_reboot = this.makeSetCommand(lEVector2, this.m_name, PROTOCOL, "protocol");
        }
        if (bl || lEVector.contains(RIP) || lEVector.contains(RIP_V2)) {
            string = (String)this.get(RIP);
            if (bl) {
                this.makeRIPCommand(lEVector2, this.m_name, RIP, (String)this.get(RIP));
                this.makeRIPv2Command(lEVector2, this.m_name, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            } else if (lEVector != null && lEVector.contains(RIP) && string != null && !string.equals(V2)) {
                this.makeRIPCommand(lEVector2, this.m_name, RIP, (String)this.get(RIP));
            } else {
                this.makeRIPv2Command(lEVector2, this.m_name, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            }
        }
        if (bl || lEVector.contains(RIP_COST)) {
            this.makeSetCommand(lEVector2, this.m_name, RIP_COST, "rip cost");
        }
        if (bl || lEVector.contains(IPSEC_LOG_FAILURE)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_FAILURE, IPSEC_LOG_FAILURE);
        }
        if (bl || lEVector.contains(IPSEC_LOG_SUCCESS)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_SUCCESS, IPSEC_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(IPSEC_LOG_SYSLOG)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_SYSLOG, IPSEC_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(IPSEC_LOG_CONSOLE)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_CONSOLE, IPSEC_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(IPSEC_OUTSRC_PROFILE)) {
            this.makeIPSecProfileCommand(lEVector2, this.m_name, IPSEC_OUTSRC_PROFILE, IPSEC_OUTSRC_PROFILE);
        }
        if (bl || lEVector.contains(IPSEC_ACTIVE_PROFILE)) {
            this.makeIPSecProfileCommand(lEVector2, this.m_name, IPSEC_ACTIVE_PROFILE, IPSEC_ACTIVE_PROFILE);
        }
        if (bl || lEVector.contains(IPSEC_PDA)) {
            this.makeIPSecPDACommand(lEVector2, this.m_name, IPSEC_PDA, IPSEC_PDA);
        }
        if (bl || lEVector.contains(XBAR_ADDR)) {
            this.makeSetCommand(lEVector2, this.m_name, XBAR_ADDR, "crossbar-ip");
        }
        return lEVector2.size() > n;
    }
}

