/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunw.hotjava.bean.Cookie;
import sunw.hotjava.bean.DisplayOnlyEditor;
import sunw.hotjava.misc.Cookies;
import sunw.hotjava.misc.HttpCookie;

public class CookieJar
implements DisplayOnlyEditor.Displayable {
    private Hashtable jar;
    private HttpCookie removed;
    private HttpCookie added;

    public CookieJar(Cookie[] cookieArray) {
        this.jar = new Hashtable();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                Cookie cookie = cookieArray[n];
                String string = String.valueOf(cookie.attribute) + "=" + cookie.value;
                HttpCookie httpCookie = new HttpCookie(cookie.expires, string, cookie.path, cookie.domain, cookie.isSecure);
                Cookies.recordCookieToJar(httpCookie, this.jar, false);
                ++n;
            }
        }
        this.jar = this.jar;
    }

    CookieJar(Hashtable hashtable) {
        this(hashtable, null, null);
    }

    CookieJar(Hashtable hashtable, HttpCookie httpCookie, HttpCookie httpCookie2) {
        this.jar = hashtable;
        this.removed = httpCookie;
        this.added = httpCookie2;
    }

    void setSystemCookies() {
        Cookies.setCookiesFromBean(this.jar);
    }

    public Cookie[] getCookies() {
        Vector<Object> vector = new Vector<Object>();
        Cookie[] cookieArray = this.jar;
        synchronized (cookieArray) {
            if (this.added != null && this.removed == null) {
                vector.addElement(new Cookie(this.added));
            }
            Enumeration enumeration = this.jar.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector2 = (Vector)enumeration.nextElement();
                int n = 0;
                while (n < vector2.size()) {
                    HttpCookie httpCookie = (HttpCookie)vector2.elementAt(n);
                    if (httpCookie == this.removed) {
                        vector.addElement(this.added);
                    } else {
                        vector.addElement(new Cookie(httpCookie));
                    }
                    ++n;
                }
            }
        }
        cookieArray = new Cookie[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            cookieArray[n] = (Cookie)vector.elementAt(n);
            ++n;
        }
        return cookieArray;
    }

    public boolean isIncrementalChange(CookieJar cookieJar) {
        return this.jar == cookieJar.jar;
    }

    public Cookie entryAdded(CookieJar cookieJar) {
        if (this == cookieJar) {
            return null;
        }
        if (this.added != null) {
            return new Cookie(this.added);
        }
        if (cookieJar.removed != null) {
            return new Cookie(cookieJar.removed);
        }
        return null;
    }

    public Cookie entryRemoved(CookieJar cookieJar) {
        return cookieJar.entryAdded(this);
    }

    public String toDisplayString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.toString()) + ":\n\n");
        Cookie[] cookieArray = this.getCookies();
        int n = 0;
        while (n < cookieArray.length) {
            stringBuffer.append(cookieArray[n].toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

