/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LETemplateDSSFlatFile;
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.PropertyResourceBundle;

public class LWUseFilePage
extends LEWizardDataPage
implements ItemListener,
ActionListener {
    public static final String NO_FILE_FOUND = "The specified file was not found.";
    public static final String NO_LOCATIONS = "No valid locations were found in the file.";
    public static final String BROWSE = "Browse";
    private static final String INSTRUCTION_TAG = "TEMPLATE_INST";
    private static final String HELP_TAG = "Configure_or_Use_File";
    private static final String TITLE_TAG = "TEMPLATE_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    Checkbox m_file_box;
    LETextField m_location;
    Button m_browse;
    PropertyResourceBundle m_resource;

    public LWUseFilePage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_component = new Label("Choose configuration path:");
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        Checkbox checkbox = new Checkbox("Create location using step by step process", true, checkboxGroup);
        checkbox.addItemListener(this);
        this.m_panel.add((Component)checkbox, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_file_box = new Checkbox("Use file", false, checkboxGroup);
        this.m_file_box.addItemListener(this);
        this.m_panel.add((Component)this.m_file_box, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_location = new LETextField(40);
        this.m_location.setLimitLength(false);
        this.m_location.setEnabled(false);
        this.m_panel.add((Component)this.m_location, this.m_gbc);
        this.m_browse = new Button(BROWSE);
        this.m_browse.setActionCommand(BROWSE);
        this.m_browse.addActionListener(this);
        this.m_browse.setEnabled(false);
        this.m_panel.add((Component)this.m_browse, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        if (this.m_file_box.getState()) {
            String string;
            String string2 = this.m_location.getText();
            int n = string2.lastIndexOf(string = System.getProperty("file.separator"));
            if (n < 0) {
                this.m_problem = NO_FILE_FOUND;
                return false;
            }
            String string3 = string2.substring(n + 1);
            String string4 = string2.substring(0, n);
            if (string4 != null && string3 != null) {
                File file = new File(string4, string3);
                if (file.exists()) {
                    this.m_model.set(LEPMWizardModel.BACKUP_DIR, string4);
                    this.m_model.set(LEPMWizardModel.BACKUP_FILE, string3);
                    if (!this.readFile()) {
                        this.m_problem = NO_LOCATIONS;
                        return false;
                    }
                } else {
                    this.m_problem = NO_FILE_FOUND;
                    return false;
                }
            }
        }
        this.m_model.set(LEPMWizardModel.CONNECTED, "on");
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_file_box.getState()) {
            this.m_location.setEnabled(true);
            this.m_browse.setEnabled(true);
            return;
        }
        this.m_location.setEnabled(false);
        this.m_browse.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(BROWSE)) {
            this.browse();
        }
    }

    private void browse() {
        String string = this.m_location.getText();
        String string2 = System.getProperty("file.separator");
        String string3 = new String();
        String string4 = new String();
        int n = string.lastIndexOf(string2);
        if (n > -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
        }
        FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Open File", 0);
        fileDialog.setDirectory(string4);
        fileDialog.setFile(string3);
        fileDialog.show();
        string4 = fileDialog.getDirectory();
        string3 = fileDialog.getFile();
        if (string3 != null) {
            String string5 = LEAppInfo.createFullPath(string4, string3);
            ((TextComponent)this.m_location).setText(string5);
        }
    }

    private boolean readFile() {
        LEVector lEVector = new LEVector();
        LEVector lEVector2 = new LEVector();
        LEConnectionManager lEConnectionManager = (LEConnectionManager)this.m_model.getObject(LEPMWizardModel.CONNECTION_MGR);
        String string = LEAppInfo.createFullPath(this.m_model.get(LEPMWizardModel.BACKUP_DIR), this.m_model.get(LEPMWizardModel.BACKUP_FILE));
        try {
            LETemplateDSSFlatFile lETemplateDSSFlatFile = lEConnectionManager.connectToTemplateFile(string, 0, lEVector2);
            lETemplateDSSFlatFile.connect();
            lEVector = lETemplateDSSFlatFile.getCommands();
            lEVector2 = lETemplateDSSFlatFile.getTemplateKeys();
            if (lEVector.size() == 0 && lEVector2.size() == 0) {
                lETemplateDSSFlatFile.disconnect();
                return false;
            }
            if (lEVector2.size() > 0) {
                this.m_model.putObject(LEPMWizardModel.TEMPLATE_KEYS, lEVector2);
                this.m_model.set(LWDataModel.USE_TEMPLATE, "on");
            } else {
                this.m_model.set(LWDataModel.USE_TEMPLATE, "off");
            }
            if (lEVector.size() > 0) {
                this.m_model.putObject(LEPMWizardModel.COMMANDS, lEVector);
                if (!this.m_model.getModelInfo()) {
                    lETemplateDSSFlatFile.disconnect();
                    return false;
                }
            }
            lETemplateDSSFlatFile.disconnect();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }
}

