/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LEActionDialog;
import com.lucent.ra.nms.ui.LEConfirmClient;
import com.lucent.ra.nms.ui.LEIPPanel;
import com.lucent.ra.nms.ui.LENetmaskPanel;
import com.lucent.ra.nms.ui.LEStatusBar;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;

public class LEIPDataPage
extends LEWizardDataPage
implements LEConfirmClient {
    public static final String IP_DONE = "SetupIPDone";
    static final int MAX_CONNECT_ATTEMPTS = 30;
    static final String INC_IPADDRESS = "The Internet address is incomplete.";
    static final String BAD_IPADDRESS = "The Internet address is invalid.";
    static final String BAD_NETMASK = "The netmask is invalid.";
    static final String INC_NETMASK = "The netmask is incomplete";
    static final String BAD_MACADDRESS = "The MAC address has a bad format.  Use ##:##:## .";
    static final String BAD_PASSWORD_MSG = "You entered a wrong password for this device.";
    static final String UNKNOWN_PROBLEM = "An unknown problem has occurred, please restart the wizard.";
    static final String SUCCESS = "Successful Connection.";
    static final String VENDOR_CODE = "00:c0:05:";
    private static final String INSTRUCTION_TAG = "IPDATA_BASIC_INST";
    private static final String ADV_INSTRUCTION_TAG = "IPDATA_ADVANCED_INST";
    private static final String HELP_TAG = "Internet_Address";
    private static final String TITLE_TAG = "IPDATA_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    Label m_infoText;
    LEIPPanel m_ippanel;
    LENetmaskPanel m_maskpanel;
    boolean m_connected;
    LEActionDialog m_connectDlg;
    LEStatusBar m_status;
    boolean m_canceled = false;
    LETextField m_macaddr;
    Label m_maclabel;
    Label m_livlabel;
    Panel m_macPanel;
    String m_basicInst;
    String m_advInst;
    static LEVector s_template_keys;
    PropertyResourceBundle m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
    Thread m_thread;

    public LEIPDataPage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.m_basicInst = this.m_instructions;
        this.m_advInst = this.m_resource.getString(ADV_INSTRUCTION_TAG);
        this.setHelpTag(HELP_TAG);
        this.m_infoText = null;
        this.m_connected = false;
        if (this.m_model.get(LEPMWizardModel.IPADDRESS) == null) {
            this.m_model.set(LEPMWizardModel.IPADDRESS, "");
        }
        if (this.m_model.get(LEPMWizardModel.NETMASK) == null) {
            this.m_model.set(LEPMWizardModel.NETMASK, "255.255.255.0");
        }
        if (this.m_model.get(LEPMWizardModel.MAC_ADDRESS) == null) {
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, "");
        }
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_model.get(LEPMWizardModel.WIZARD_LEVEL);
        String string = new String("Enter the Internet (IP) address: ");
        this.m_infoText = new Label(string);
        this.m_component = this.m_infoText;
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_ippanel = new LEIPPanel(this.m_model.get(LEPMWizardModel.IPADDRESS));
        this.m_component = this.m_ippanel;
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 20;
        string = new String("Enter the netmask:");
        this.m_component = new Label(string);
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_gbc.insets.top = 0;
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_maskpanel = new LENetmaskPanel(this.m_model.get(LEPMWizardModel.NETMASK));
        this.m_component = this.m_maskpanel;
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 20;
        return this.m_panel;
    }

    public Panel getPanel() {
        Panel panel = this.m_panel;
        String string = this.m_model.get(LEPMWizardModel.WIZARD_LEVEL);
        if (this.m_panel == null) {
            this.m_panel = panel = this.createPanel();
            panel.setLayout(this.m_gbl);
        }
        if (string.equals("Advanced")) {
            if (this.m_macPanel == null) {
                this.m_macPanel = this.createMacPanel();
                this.m_panel.add((Component)this.m_macPanel, this.m_gbc);
            }
            this.m_instructions = this.m_advInst;
        } else {
            if (this.m_macPanel != null) {
                this.m_panel.remove(this.m_macPanel);
                this.m_macPanel = null;
            }
            this.m_instructions = this.m_basicInst;
        }
        return panel;
    }

    public void setInstructions(String string) {
        this.m_instructions = this.m_basicInst = string;
    }

    public boolean processPanelData() {
        Object object;
        this.m_problem = null;
        this.m_canceled = false;
        if (this.m_ippanel.getAddress().equals("0.0.0.0")) {
            this.m_problem = INC_IPADDRESS;
            return false;
        }
        if (this.m_maskpanel.getNetmask().equals("0.0.0.0")) {
            this.m_problem = INC_NETMASK;
            return false;
        }
        if (!this.m_model.get(LEPMWizardModel.IPADDRESS).equals("0.0.0.0") && !this.m_ippanel.getAddress().equals(this.m_model.get(LEPMWizardModel.IPADDRESS))) {
            this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            object = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
            if (object != null) {
                ((LEPortMaster)object).disconnect();
            }
            this.m_model.removeObject(LEPMWizardModel.PORTMASTER);
            this.m_connected = false;
        }
        if (this.m_connected) {
            this.m_model.set(LEPMWizardModel.CONNECTED, "on");
            return true;
        }
        this.m_model.set(LEPMWizardModel.IPADDRESS, this.m_ippanel.getAddress());
        this.m_model.set(LEPMWizardModel.NETMASK, this.m_maskpanel.getNetmask());
        object = this.m_model.get(LEPMWizardModel.WIZARD_LEVEL);
        if (((String)object).equals("Advanced")) {
            String string = this.m_macaddr.getText();
            if (!this.processMacAddress(string)) {
                this.m_problem = BAD_MACADDRESS;
                return false;
            }
        } else {
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, "");
        }
        this.m_model.set(LEPMWizardModel.CONNECTED, "on");
        return true;
    }

    public void confirmAction(String string, Object object) {
    }

    public void cancelAction(Object object) {
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("ether0 address");
            s_template_keys.add("ether0 netmask");
        }
        return s_template_keys;
    }

    private Panel createMacPanel() {
        Panel panel = new Panel(new GridLayout(2, 1, 0, 0));
        this.m_maclabel = new Label("Optionally, enter the MAC address of your PortMaster");
        panel.add(this.m_maclabel);
        Panel panel2 = new Panel(new FlowLayout(0, 0, 0));
        this.m_livlabel = new Label(VENDOR_CODE);
        panel2.add(this.m_livlabel);
        this.m_macaddr = new LETextField(8);
        panel2.add(this.m_macaddr);
        panel.add(panel2);
        return panel;
    }

    private boolean processMacAddress(String string) {
        if (!string.equals("")) {
            char c;
            int n;
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":-");
            int n2 = stringTokenizer.countTokens();
            if (n2 == 3) {
                string2 = string.replace('-', ':');
            } else if (n2 == 1 && string.length() == 6) {
                char[] cArray = string.toCharArray();
                StringBuffer stringBuffer = new StringBuffer();
                n = 0;
                while (n < 6) {
                    c = cArray[n];
                    if (Character.isDigit(c)) {
                        stringBuffer.append(c);
                    } else if (Character.isLetter(c)) {
                        c = Character.toLowerCase(c);
                        stringBuffer.append(c);
                    } else {
                        return false;
                    }
                    if (n == 1 || n == 3) {
                        stringBuffer.append(':');
                    }
                    ++n;
                }
                string2 = stringBuffer.toString();
            } else {
                return false;
            }
            int n3 = string2.length();
            n = Character.getNumericValue('g');
            char[] cArray = string2.toCharArray();
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                c = cArray[n4];
                if (c != ':' && !Character.isDigit(c) && (n5 = Character.getNumericValue(c)) >= n) {
                    return false;
                }
                ++n4;
            }
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, VENDOR_CODE + string2);
        } else {
            this.m_model.set(LEPMWizardModel.MAC_ADDRESS, "");
        }
        return true;
    }
}

