/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.util.PropertyResourceBundle;

public class LEIdleTimeoutPage
extends LEWizardDataPage {
    public static final String BAD_TIME = "Enter a number between 0 and 255.";
    public static final String NO_TIME = "You need to enter a time.";
    private static final String INSTRUCTION_TAG = "IDLETIMEOUT_INST";
    private static final String HELP_TAG = "Idle_Timeout";
    private static final String TITLE_TAG = "IDLETIMEOUT_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    LETextField m_idle;
    Checkbox m_minutes;
    Checkbox m_seconds;
    static LEVector s_template_keys;
    PropertyResourceBundle m_resource;

    public LEIdleTimeoutPage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_component = new Label("Enter an idle timeout for the location");
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_idle = new LETextField(3);
        ((TextComponent)this.m_idle).setText(this.m_model.get(LEPMWizardModel.IDLE_TIMEOUT));
        this.m_idle.setNumeric(true);
        this.m_panel.add((Component)this.m_idle, this.m_gbc);
        Panel panel = new Panel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_minutes = new Checkbox("Minutes", checkboxGroup, true);
        this.m_seconds = new Checkbox("Seconds", checkboxGroup, false);
        panel.add(this.m_minutes);
        panel.add(this.m_seconds);
        this.m_panel.add((Component)panel, this.m_gbc);
        if (this.m_model.get(LEPMWizardModel.TIMEOUT_SIZE).equals("seconds")) {
            this.m_seconds.setState(true);
        }
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        String string = this.m_idle.getText();
        if (string == null) {
            this.m_problem = NO_TIME;
            return false;
        }
        int n = Integer.parseInt(string);
        if (n > 255) {
            this.m_problem = BAD_TIME;
            return false;
        }
        this.m_model.set(LEPMWizardModel.IDLE_TIMEOUT, string);
        if (this.m_minutes.getState()) {
            this.m_model.set(LEPMWizardModel.TIMEOUT_SIZE, "minutes");
        } else {
            this.m_model.set(LEPMWizardModel.TIMEOUT_SIZE, "seconds");
        }
        return true;
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("idle");
        }
        return s_template_keys;
    }
}

