/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEByteArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class LETFTPAckPacket
extends LETFTPPacket {
    public static final int MAX_PACKET_SIZE = 4;
    private short m_blockNum;
    private byte[] m_data;

    public LETFTPAckPacket(short s) {
        int n = 0;
        this.m_data = new byte[4];
        this.m_blockNum = s;
        LEByteArray.CopyShort((short)4, this.m_data, n);
        LEByteArray.CopyShort(this.m_blockNum, this.m_data, n += 2);
        n += 2;
    }

    public LETFTPAckPacket(DatagramPacket datagramPacket) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            dataInputStream.skipBytes(2);
            this.m_blockNum = dataInputStream.readShort();
            return;
        }
        catch (IOException iOException) {
            LETFTPServer.GetServer().printMsg("Problem reading from input data stream");
            return;
        }
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public int getSize() {
        return 4;
    }

    public short getBlockNum() {
        return this.m_blockNum;
    }

    public void printPacket() {
        LETFTPServer.GetServer().printMsg("Ack packet", false);
        LETFTPServer.GetServer().printMsg(" Block number: " + this.m_blockNum, false);
    }
}

