/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEImageView;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEAboutPanel
extends Panel
implements ItemListener {
    public static final String VERBOSE = "Verbose";
    public static final String DEBUG = "Debug";
    public static final String ERRORS = "Errors Only";
    public static final String FATAL = "Fatal Errors Only";
    public static final String NONE = "No Debugging";
    static String[] s_dbgs = new String[]{"Verbose", "Debug", "Errors Only", "Fatal Errors Only", "No Debugging"};
    Choice m_debug;

    public LEAboutPanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.add("North", this.buildTopPanel());
        this.add("Center", this.buildMainPanel());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.m_debug.getSelectedItem();
        if (string.equals(VERBOSE)) {
            LEDebug.getLog().setLogLevel(40);
            return;
        }
        if (string.equals(DEBUG)) {
            LEDebug.getLog().setLogLevel(30);
            return;
        }
        if (string.equals(ERRORS)) {
            LEDebug.getLog().setLogLevel(20);
            return;
        }
        if (string.equals(FATAL)) {
            LEDebug.getLog().setLogLevel(10);
            return;
        }
        if (string.equals(NONE)) {
            LEDebug.getLog().setLogLevel(0);
        }
    }

    Component buildTopPanel() {
        LEBorderPanel lEBorderPanel = new LEBorderPanel(3);
        LEBorderPanel lEBorderPanel2 = new LEBorderPanel(2);
        lEBorderPanel.setLayout(new BorderLayout(0, 0));
        lEBorderPanel2.setLayout(new BorderLayout(0, 0));
        LEImageView lEImageView = new LEImageView(LEAppInfo.getImage(), 4);
        lEImageView.setBackground(Color.white);
        lEBorderPanel2.add("Center", lEImageView);
        lEBorderPanel.add("Center", lEBorderPanel2);
        return lEBorderPanel;
    }

    Component buildMainPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        int n = LEAppInfo.getLargeFontSize();
        Font font = new Font("TimesRoman", 1, n);
        Label label = new Label(LEAppInfo.getAppTitle(), 1);
        label.setFont(font);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel2.add("North", label);
        label = new Label(LEAppInfo.getCopyright(), 1);
        panel2.add("South", label);
        panel.add("North", panel2);
        panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        Component[][] componentArray = new Component[5][2];
        componentArray[0][0] = new Label("Build Date:");
        componentArray[1][0] = new Label("Debug Level:");
        componentArray[2][0] = new Label("Debug Log:");
        componentArray[3][0] = new Label("Platform:");
        componentArray[4][0] = new Label("Java:");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[2][0].setFont(LEFont.getBoldFont());
        componentArray[3][0].setFont(LEFont.getBoldFont());
        componentArray[4][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = new Label(LEAppInfo.GetBuildDate(), 0);
        this.m_debug = new Choice();
        this.m_debug.addItemListener(this);
        int n2 = 0;
        while (n2 < s_dbgs.length) {
            this.m_debug.addItem(s_dbgs[n2]);
            ++n2;
        }
        componentArray[1][1] = this.m_debug;
        int n3 = LEDebug.getLog().getLogLevel();
        if (n3 >= 40) {
            this.m_debug.select(VERBOSE);
        } else if (n3 >= 30) {
            this.m_debug.select(DEBUG);
        } else if (n3 >= 20) {
            this.m_debug.select(ERRORS);
        } else if (n3 >= 0) {
            this.m_debug.select(FATAL);
        } else {
            this.m_debug.select(NONE);
        }
        String string = LEAppInfo.getUserAppDirPath("debuglog.txt");
        componentArray[2][1] = new Label(string, 0);
        componentArray[3][1] = new Label(LEAppInfo.getPlatform(), 0);
        componentArray[4][1] = new Label(LEAppInfo.getJavaInfo(), 0);
        LECompGrid lECompGrid = new LECompGrid(componentArray, 0, false);
        panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(lECompGrid);
        panel.add("Center", panel2);
        return panel;
    }
}

