/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.netboot.LEBootPARPTableHandler;
import com.lucent.ra.nms.netboot.LEBootPDatabaseMgr;
import com.lucent.ra.nms.netboot.LEBootPServer;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.ui.LEAboutDialog;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LESplitterPanel;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEProperties;
import com.lucent.ra.nms.util.LEResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import oracle.help.Book;
import oracle.help.Help;

public class NBNetbootPanel
extends Frame
implements ActionListener,
WindowListener,
LEObserver {
    public static final String ACTION_ABOUT = "about";
    public static final String ACTION_STOP_TFTP = "stop_tftp";
    public static final String ACTION_START_TFTP = "start_tftp";
    public static final String ACTION_CONFIG_TFTP = "config_tftp";
    public static final String ACTION_STOP_BOOTP = "stop_bootp";
    public static final String ACTION_START_BOOTP = "start_bootp";
    public static final String ACTION_BOOTP_DATABASE = "bootp_database";
    public static final String ACTION_EXIT = "exit";
    public static final String ACTION_HELP_CONTENTS = "help_contents";
    public static final String ACTION_HELP_SEARCH = "help_search";
    public static final String PROPERTIES_FILE = "netbootprops.cfg";
    static final String PROP_MAIN_X = "main_x";
    static final String PROP_MAIN_Y = "main_y";
    static final String PROP_MAIN_W = "main_w";
    static final String PROP_MAIN_H = "main_h";
    static final String PROP_TFTP_PANEL_H = "tftp_panel_h";
    static final String PROP_BOOTP_PANEL_H = "bootp_panel_h";
    static final String PROP_TFTP_SERVER_STATE = "tftp_server_state";
    static final String PROP_BOOTP_SERVER_STATE = "bootp_server_state";
    static final String SERVER_START = "start";
    static final String SERVER_STOP = "stop";
    static NBNetbootPanel s_panel;
    static Image s_main32;
    static Image s_main16;
    MenuBar m_menubar;
    Menu m_helpMenu;
    MenuItem m_tftpStart;
    MenuItem m_tftpStop;
    MenuItem m_bootpStart;
    MenuItem m_bootpStop;
    Label m_tftpStatus;
    Label m_bootpStatus;
    LEBorderPanel m_tftpPanel;
    LEBorderPanel m_bootpPanel;
    NBBootpMultilist m_bootpMlist;
    InetAddress m_broadcastAddress;
    LEBootPARPTableHandler m_arpTableHandler;
    Rectangle m_bounds;
    int m_tftpPanelHeight;
    Book m_book;
    Help m_help;
    static /* synthetic */ Class class$Netboot;

    public static void Display() {
        if (s_panel == null) {
            new NBNetbootPanel();
        }
    }

    private NBNetbootPanel() {
        super(LEAppInfo.getAppTitle());
        LEUiUtils.SetBaseFrame(this);
        LEColor.CheckColorFlags();
        this.m_arpTableHandler = null;
        LEProperties.SetPropertyFile(LEAppInfo.getUserAppDirPath(PROPERTIES_FILE));
        this.loadProperties();
        s_panel = this;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(LEColor.getBackground());
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        lESplitterPanel.addColumn(0);
        if (this.m_tftpPanelHeight == 0) {
            lESplitterPanel.addComponent((Component)this.createTFTPPanel(), 50.0);
        } else {
            lESplitterPanel.addComponent((Component)this.createTFTPPanel(), this.m_tftpPanelHeight);
        }
        lESplitterPanel.addComponent((Component)this.createBootPPanel(), 0);
        this.add("Center", lESplitterPanel);
        ((Component)this).setVisible(true);
        this.m_tftpStop.setEnabled(false);
        this.m_tftpStart.setEnabled(true);
        String string = LEProperties.GetProperty(PROP_TFTP_SERVER_STATE);
        if (string != null && string.equals(SERVER_START)) {
            this.startTFTPServer();
        }
        this.m_bootpStop.setEnabled(false);
        this.m_bootpStart.setEnabled(true);
        string = LEProperties.GetProperty(PROP_BOOTP_SERVER_STATE);
        try {
            this.m_broadcastAddress = InetAddress.getByName("255.255.255.255");
        }
        catch (UnknownHostException unknownHostException) {
            LEDebug.getLog().logln(30, "Cannot find broadcast address");
        }
        if (string != null && string.equals(SERVER_START)) {
            this.startBootPServer();
        }
        LEBootPDatabaseMgr.GetManager().addObserver(this);
        try {
            this.m_book = Help.createBook((Class)(class$Netboot != null ? class$Netboot : (class$Netboot = NBNetbootPanel.class$("Netboot"))), (String)".", (String)"Netboot", (String)"NetbootServer Help");
            if (this.m_book != null) {
                this.m_help = new Help();
                this.m_help.addBook(this.m_book);
                return;
            }
        }
        catch (Throwable throwable) {
            LEDebug.getLog().logln(20, throwable);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
    }

    private Panel createTFTPPanel() {
        this.m_tftpPanel = new LEBorderPanel(2);
        this.m_tftpPanel.setLayout(new BorderLayout(0, 0));
        this.m_tftpPanel.setBackground(LEColor.getBackground());
        Component[][] componentArray = new Component[1][2];
        Label label = new Label("TFTP Server Status: ");
        label.setFont(LEFont.getBoldFont());
        componentArray[0][0] = label;
        this.m_tftpStatus = new Label("Stopped");
        componentArray[0][1] = this.m_tftpStatus;
        LECompGrid lECompGrid = new LECompGrid(componentArray, 2);
        this.m_tftpPanel.add("North", this.createStatusPanel(lECompGrid));
        NBTftpMultilist nBTftpMultilist = new NBTftpMultilist();
        LEScrollPanel lEScrollPanel = new LEScrollPanel(nBTftpMultilist);
        this.m_tftpPanel.add("Center", lEScrollPanel);
        return this.m_tftpPanel;
    }

    private Panel createBootPPanel() {
        this.m_bootpPanel = new LEBorderPanel(2);
        this.m_bootpPanel.setLayout(new BorderLayout(0, 0));
        this.m_bootpPanel.setBackground(LEColor.getBackground());
        Component[][] componentArray = new Component[1][2];
        Label label = new Label("BootP Server Status:");
        label.setFont(LEFont.getBoldFont());
        componentArray[0][0] = label;
        this.m_bootpStatus = new Label("Stopped");
        componentArray[0][1] = this.m_bootpStatus;
        LECompGrid lECompGrid = new LECompGrid(componentArray, 2);
        lECompGrid.setBackground(LEColor.getBackground());
        this.m_bootpPanel.add("North", this.createStatusPanel(lECompGrid));
        this.m_bootpMlist = new NBBootpMultilist();
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_bootpMlist);
        this.m_bootpPanel.add("Center", lEScrollPanel);
        return this.m_bootpPanel;
    }

    public void addNotify() {
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.m_bounds != null) {
            n = this.m_bounds.x;
            n2 = this.m_bounds.y;
            n3 = this.m_bounds.width;
            n4 = this.m_bounds.height;
        }
        if (n3 == 0 || n4 == 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n3 = dimension.width - 40;
            n4 = dimension.height - 60;
        }
        ((Component)this).setLocation(n, n2);
        ((Component)this).setSize(n3, n4);
        try {
            s_main32 = LEResource.GetImage("lucent_32.gif");
            s_main16 = LEResource.GetImage("lucent_16.gif");
            if (s_main32 != null) {
                this.setIconImage(s_main32);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_ABOUT)) {
            LEAboutDialog.Show(this);
            return;
        }
        if (string.equals(ACTION_STOP_TFTP)) {
            this.stopTFTPServer();
            return;
        }
        if (string.equals(ACTION_START_TFTP)) {
            this.startTFTPServer();
            return;
        }
        if (string.equals(ACTION_CONFIG_TFTP)) {
            new NBTFTPDialog((Frame)this, LETFTPServer.GetServer());
            return;
        }
        if (string.equals(ACTION_EXIT)) {
            this.goodbye();
            return;
        }
        if (string.equals(ACTION_HELP_CONTENTS)) {
            if (this.m_help != null) {
                this.m_help.showContents();
                return;
            }
        } else if (string.equals(ACTION_HELP_SEARCH)) {
            if (this.m_help != null) {
                this.m_help.showSearch();
                return;
            }
        } else {
            if (string.equals(ACTION_STOP_BOOTP)) {
                this.stopBootPServer();
                return;
            }
            if (string.equals(ACTION_START_BOOTP)) {
                this.startBootPServer();
                return;
            }
            if (string.equals(ACTION_BOOTP_DATABASE)) {
                NBBootpDatabasePanel.Display();
                return;
            }
            LEDebug.getLog().logln(20, "Unknown LEConsole Action: " + string);
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        if (this.m_bootpStop.isEnabled()) {
            this.stopBootPServer();
            this.startBootPServer();
        }
    }

    MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Exit");
        menuItem.setActionCommand(ACTION_EXIT);
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuBar.add(menu);
        menu = new Menu("TFTP Server");
        this.m_tftpStart = new MenuItem("Start Server");
        this.m_tftpStart.setActionCommand(ACTION_START_TFTP);
        this.m_tftpStart.addActionListener(this);
        menu.add(this.m_tftpStart);
        this.m_tftpStop = new MenuItem("Stop Server");
        this.m_tftpStop.setActionCommand(ACTION_STOP_TFTP);
        this.m_tftpStop.addActionListener(this);
        menu.add(this.m_tftpStop);
        menuItem = new MenuItem("Properties...");
        menuItem.setActionCommand(ACTION_CONFIG_TFTP);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("BootP Server");
        this.m_bootpStart = new MenuItem("Start Server");
        this.m_bootpStart.setActionCommand(ACTION_START_BOOTP);
        this.m_bootpStart.addActionListener(this);
        menu.add(this.m_bootpStart);
        this.m_bootpStop = new MenuItem("Stop Server");
        this.m_bootpStop.setActionCommand(ACTION_STOP_BOOTP);
        this.m_bootpStop.addActionListener(this);
        menu.add(this.m_bootpStop);
        menuItem = new MenuItem("Database...");
        menuItem.setActionCommand(ACTION_BOOTP_DATABASE);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = this.m_helpMenu = new Menu("Help");
        menuItem = new MenuItem("Help Contents...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CONTENTS);
        menuItem.addActionListener(this);
        menu.addSeparator();
        menuItem = new MenuItem("About " + LEAppInfo.getAppName() + "...");
        menuItem.setActionCommand(ACTION_ABOUT);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    void loadProperties() {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string = LEProperties.GetProperty(PROP_MAIN_X);
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_Y)) != null) {
                n2 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_W)) != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_H)) != null) {
                n4 = Integer.parseInt(string);
            }
            this.m_bounds = new Rectangle(n, n2, n3, n4);
            string = LEProperties.GetProperty(PROP_TFTP_PANEL_H);
            if (string != null) {
                this.m_tftpPanelHeight = Integer.parseInt(string);
            }
            LETFTPServer.GetServer().loadProperties();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void saveProperties() {
        Rectangle rectangle = this.getBounds();
        LEProperties.SetProperty(PROP_MAIN_X, Integer.toString(rectangle.x));
        LEProperties.SetProperty(PROP_MAIN_Y, Integer.toString(rectangle.y));
        LEProperties.SetProperty(PROP_MAIN_W, Integer.toString(rectangle.width));
        LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height));
        LETFTPServer.GetServer().saveProperties();
        Dimension dimension = this.m_tftpPanel.getSize();
        if (dimension.height < 0) {
            LEProperties.SetProperty(PROP_TFTP_PANEL_H, "0");
        } else {
            LEProperties.SetProperty(PROP_TFTP_PANEL_H, Integer.toString(dimension.height));
        }
        dimension = this.m_bootpPanel.getSize();
        if (dimension.height < 0) {
            LEProperties.SetProperty(PROP_BOOTP_PANEL_H, "0");
        } else {
            LEProperties.SetProperty(PROP_BOOTP_PANEL_H, Integer.toString(dimension.height));
        }
        LEProperties.SaveProperties();
    }

    private Panel createStatusPanel(Panel panel) {
        Panel panel2 = new Panel();
        panel2.setBackground(LEColor.getBackground());
        panel2.setLayout(new BorderLayout(5, 5));
        panel2.add("Center", panel);
        return panel2;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this) {
            this.goodbye();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void goodbye() {
        this.saveProperties();
        LETFTPServer.GetServer().stopServer();
        LEBootPDatabaseMgr.GetManager().save();
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    private void stopTFTPServer() {
        this.m_tftpStop.setEnabled(false);
        this.m_tftpStart.setEnabled(true);
        this.m_tftpStatus.setText("Stopped");
        LETFTPServer.GetServer().stopServer();
        LEProperties.SetProperty(PROP_TFTP_SERVER_STATE, SERVER_STOP);
    }

    private void startTFTPServer() {
        LETFTPServer.GetServer().startServer();
        if (LETFTPServer.GetServer().isServerRunning()) {
            this.m_tftpStop.setEnabled(true);
            this.m_tftpStart.setEnabled(false);
            this.m_tftpStatus.setText("Running");
            LEProperties.SetProperty(PROP_TFTP_SERVER_STATE, SERVER_START);
            return;
        }
        new LEErrorDialog(LEUiUtils.getFrame(this), "Could not start TFTP server; " + LETFTPServer.GetServer().getErrorMessage());
    }

    private void stopBootPServer() {
        this.m_bootpStop.setEnabled(false);
        this.m_bootpStart.setEnabled(true);
        this.m_bootpStatus.setText("Stopped");
        if (this.m_arpTableHandler != null) {
            this.m_arpTableHandler.disconnect();
        } else {
            LEBootPServer.GetServer().stopServer();
        }
        LEProperties.SetProperty(PROP_BOOTP_SERVER_STATE, SERVER_STOP);
    }

    private void startBootPServer() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            Hashtable hashtable = LEBootPDatabaseMgr.GetManager().getDatabase();
            this.m_arpTableHandler = new LEBootPARPTableHandler(hashtable, string, this.m_broadcastAddress);
            if (LEBootPServer.GetServer().isServerRunning()) {
                this.m_bootpMlist.setObserver(this.m_arpTableHandler);
                this.m_bootpStop.setEnabled(true);
                this.m_bootpStart.setEnabled(false);
                this.m_bootpStatus.setText("Running");
                LEProperties.SetProperty(PROP_BOOTP_SERVER_STATE, SERVER_START);
                return;
            }
            new LEErrorDialog(LEUiUtils.getFrame(this), "Could not start BootP server; " + LEBootPServer.GetServer().getErrorMessage());
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

