/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;

public class NBTFTPDialog
extends Dialog
implements ActionListener,
WindowListener {
    TextField m_timeout;
    TextField m_retries;
    TextField m_dir;
    Button m_ButtonOk;
    Button m_CancelButton;
    Frame m_parent;
    LETFTPServer m_server;
    public static final String OKAY = "Okay";
    public static final String CANCEL = "Cancel";

    public NBTFTPDialog(Frame frame, LETFTPServer lETFTPServer) {
        super(frame, "TFTP Properties", true);
        this.m_parent = frame;
        this.m_server = lETFTPServer;
        this.setLayout(new BorderLayout(0, 0));
        this.add("South", this.layoutButtonPanel());
        Component[][] componentArray = new Component[3][3];
        componentArray[0][0] = new Label("Timeout (seconds):");
        this.m_timeout = new TextField(2);
        componentArray[0][1] = this.m_timeout;
        ((TextComponent)this.m_timeout).setText(Integer.toString(this.m_server.getTimeoutInterval()));
        componentArray[1][0] = new Label("Max Retries:");
        this.m_retries = new TextField(2);
        componentArray[1][1] = this.m_retries;
        ((TextComponent)this.m_retries).setText(Integer.toString(this.m_server.getMaxRetries()));
        componentArray[2][0] = new Label("Base Directory:");
        this.m_dir = new TextField(40);
        componentArray[2][1] = this.m_dir;
        ((TextComponent)this.m_dir).setText(this.m_server.getBaseDir());
        LECompGrid lECompGrid = new LECompGrid(componentArray, 2);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.add(lECompGrid);
        this.add("North", panel);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setVisible(true);
    }

    Panel layoutButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 5, 5));
        this.m_ButtonOk = new Button("OK");
        this.m_ButtonOk.setActionCommand(OKAY);
        this.m_ButtonOk.addActionListener(this);
        panel2.add(this.m_ButtonOk);
        this.m_CancelButton = new Button(CANCEL);
        this.m_CancelButton.setActionCommand(CANCEL);
        this.m_CancelButton.addActionListener(this);
        panel2.add(this.m_CancelButton);
        panel.add(panel2);
        return panel;
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.m_parent.getSize();
        Point point = this.m_parent.getLocationOnScreen();
        ((Component)this).setBounds(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OKAY)) {
            int n = Integer.parseInt(this.m_timeout.getText());
            int n2 = Integer.parseInt(this.m_retries.getText());
            String string2 = this.m_dir.getText();
            boolean bl = false;
            if (n != this.m_server.getTimeoutInterval()) {
                bl = true;
                if (n < 1 || n > 30) {
                    new LEErrorDialog(LEUiUtils.getFrame(this), "Timeout must be between " + Integer.toString(1) + " and " + Integer.toString(30));
                    return;
                }
            }
            if (n2 != this.m_server.getMaxRetries()) {
                bl = true;
                if (n2 < 0 || n2 > 10) {
                    new LEErrorDialog(LEUiUtils.getFrame(this), "Max Retries must be between " + Integer.toString(0) + " and " + Integer.toString(10));
                    return;
                }
            }
            if (!string2.equals(this.m_server.getBaseDir())) {
                bl = true;
                File file = new File(string2);
                if (!file.isDirectory()) {
                    new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(file.getAbsolutePath()) + " is not a valid directory!");
                    return;
                }
            }
            if (bl) {
                this.m_server.setTimeoutInterval(n);
                this.m_server.setMaxRetries(n2);
                this.m_server.setBaseDir(string2);
                this.m_server.saveProperties();
            }
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

