/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LEBootPPacket;
import com.lucent.ra.nms.netboot.LEBootPPacketHandler;
import com.lucent.ra.nms.netboot.LEBootPServer;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEOctets;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LEBootPARPTableHandler
extends LEBootPPacketHandler {
    private LEOctets m_serverIPAddress;
    private InetAddress m_broadcastIPAddress;
    private Hashtable m_arpTable;

    public LEBootPARPTableHandler(Hashtable hashtable, String string, InetAddress inetAddress) throws SecurityException, SocketException {
        this.m_arpTable = hashtable;
        this.m_serverIPAddress = new LEOctets(string);
        this.m_broadcastIPAddress = inetAddress;
    }

    public LEBootPARPTableHandler(BufferedReader bufferedReader, String string, InetAddress inetAddress) throws SecurityException, SocketException {
        this.m_serverIPAddress = new LEOctets(string);
        this.m_broadcastIPAddress = inetAddress;
        this.createARPTable(bufferedReader);
    }

    public void receivedLEBootPPacket(LEBootPPacket lEBootPPacket) {
        String string = lEBootPPacket.getClientIPAddress().toString();
        if (string.equals("0.0.0.0") && this.m_arpTable != null) {
            byte[] byArray = lEBootPPacket.getClientHardwareAddress();
            String string2 = this.convertHardwareAddress(byArray, lEBootPPacket.getHardwareAddressLength());
            LEBootPServer.GetServer().printMsg("BootP packet from MAC address " + string2);
            if (this.m_arpTable.containsKey(string2)) {
                String string3 = (String)this.m_arpTable.get(string2);
                LEOctets lEOctets = new LEOctets(string3);
                lEBootPPacket.setReply();
                lEBootPPacket.setYourIPAddress(lEOctets);
                lEBootPPacket.setServerIPAddress(this.m_serverIPAddress);
                LEBootPServer.GetServer().printMsg("Found IP address " + string3);
                this.sendBootPPacket(lEBootPPacket);
                String[] stringArray = new String[]{string2, string3};
                this.notifyObservers(stringArray);
            }
        }
    }

    public void sendBootPPacket(LEBootPPacket lEBootPPacket) {
        try {
            LEBootPServer.GetServer().sendPacket(lEBootPPacket, this.m_broadcastIPAddress);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void updateARPTable(Hashtable hashtable) {
        this.m_arpTable = hashtable;
    }

    public Hashtable appendARPTable(Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.m_arpTable.containsKey(string)) {
                String string2 = (String)this.m_arpTable.get(string);
                if (string2.equals((String)hashtable.get(string))) continue;
                hashtable2.put(string, string2);
                this.m_arpTable.remove(string);
                this.m_arpTable.put(string, hashtable.get(string));
                continue;
            }
            this.m_arpTable.put(string, hashtable.get(string));
        }
        return hashtable2;
    }

    private String convertHardwareAddress(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(":");
            }
            int n3 = byArray[n2] & 0xF0;
            char c = Character.forDigit(n3 /= 16, 16);
            stringBuffer.append(c);
            n3 = byArray[n2] & 0xF;
            c = Character.forDigit(n3, 16);
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void createARPTable(BufferedReader bufferedReader) {
        this.m_arpTable = new Hashtable();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreElements()) continue;
                String string3 = stringTokenizer.nextToken();
                this.m_arpTable.put(string3, string2);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

