/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilters;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import COM.livingston.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class PMDumpFilter
extends CLUtil {
    private static final String TOC_FLAG = "-toc";
    private static final String FILTER_FLAG = "-filter";
    LEDebugLog m_log = LEDebug.getLog();
    LEFilters m_filters;
    LEVector m_names;
    LEVector m_selected = new LEVector();

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("pmdumpfilter");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMDumpFilter();
        ((PMDumpFilter)object).processArgs(stringArray);
        System.exit(0);
    }

    public void processArgs(String[] stringArray) {
        super.processArgs(stringArray);
        if (stringArray.length < 2) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
        }
        this.dumpFilters();
    }

    public void dumpFilters() {
        this.connectToPortMaster();
        String string = LEAppInfo.getFlag("-f");
        this.getFilters();
        if (LEAppInfo.getFlag(FILTER_FLAG) != null) {
            this.parseFilterSelection();
        }
        LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string, 1);
        int n = this.m_names.size();
        LEVector lEVector = new LEVector();
        if (LEAppInfo.getFlag(TOC_FLAG) != null) {
            System.out.println("");
            System.out.println("Filter Table of Contents");
            System.out.println("");
            int n2 = 0;
            while (n2 < n) {
                System.out.println((String)this.m_names.elementAt(n2));
                ++n2;
            }
            System.out.println("");
            return;
        }
        try {
            lEDSSFlatFile.connect();
            if (this.m_selected.size() > 0) {
                int n3 = this.m_selected.size();
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = (String)this.m_selected.elementAt(n4);
                    int n5 = 0;
                    while (n5 < n) {
                        LEFilter lEFilter;
                        lEVector.removeAllElements();
                        String string3 = (String)this.m_names.elementAt(n5);
                        if (string3.equals(string2) && (lEFilter = (LEFilter)this.m_filters.get(string3)) instanceof LEFilter && lEFilter.getCommands(lEVector)) {
                            lEDSSFlatFile.writeConfig(lEVector);
                        }
                        ++n5;
                    }
                    ++n4;
                }
            } else if (this.m_filters.getCommands(lEVector)) {
                lEDSSFlatFile.writeConfig(lEVector);
            } else {
                System.out.println("Error in dumping filters.");
            }
            lEDSSFlatFile.disconnect();
            return;
        }
        catch (Exception exception) {
            System.out.println("Error while dumping filters " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-f <file_name>] [-toc] [-filter \"filters\"] ");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-f <file_name>] : specifies a filename to save the output.");
        System.out.println("[-toc] : specifies to print the table of contents.");
        System.out.println("[-filter \"filters\"] : specifies the filters to write out.");
        System.out.println("The filters are specified as a comma separated list (\"filter1,filter2\")");
        System.out.println("If the -filter flag is not specified, then all filters are written out.");
    }

    private void getFilters() {
        this.m_filters = (LEFilters)this.m_pm.get("filter");
        if (this.m_filters instanceof LEFilters) {
            this.m_names = this.m_filters.getKeys();
        }
    }

    private void parseFilterSelection() {
        String string = LEAppInfo.getFlag(FILTER_FLAG);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.m_selected.add(string2);
        }
    }
}

