/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;

public abstract class CLUtil {
    static final String HELP_FLAG = "-help";
    static final String BUILD_FLAG = "-version";
    LEPortMaster m_pm;

    void printAppInfo() {
        System.out.print(LEAppInfo.getAppName());
        System.out.print(" version: " + LEAppInfo.getAppVersion());
        System.out.println("  build date: " + LEAppInfo.GetBuildDate());
    }

    void printUsage() {
        System.out.println("");
        System.out.print("usage: " + LEAppInfo.getAppName() + " <host> <password> [-u <username>] [-version] [-help] ");
    }

    void printHelpInfo() {
        this.printUsage();
        System.out.println("");
        System.out.println("<hostname> : specifies the PortMaster.");
        System.out.println("<password> : specifies the administrator password for the PortMaster.");
        System.out.println("[-u <username>] : specifies a username other than !root.");
        System.out.println("[-version] : prints out the version number and build date.");
        System.out.println("[-help] : prints out this help message.");
    }

    void processArgs(String[] args) {
        if (args.length > 1) {
            String host = LEAppInfo.getFlag("-h");
            String password = LEAppInfo.getFlag("-p");
            if (host == null && password == null) {
                String first_arg = args[0];
                if (!first_arg.startsWith("-")) {
                    LEAppInfo.setFlag("-h", args[0]);
                    LEAppInfo.setFlag("-p", args[1]);
                }
            } else {
                if (host != null && password != null) {
                    return;
                }
                System.out.print("The host and password arguments must either ");
                System.out.print("have both the -h and -p flags or not have ");
                System.out.println("either of them.");
                System.exit(0);
            }
        }
    }

    void checkArgs() {
        if (LEAppInfo.getFlag(BUILD_FLAG) != null) {
            this.printAppInfo();
        } else if (LEAppInfo.getFlag(HELP_FLAG) != null) {
            this.printHelpInfo();
        } else {
            this.printUsage();
        }
    }

    String getHost() {
        return LEAppInfo.getFlag("-h");
    }

    String getPassword() {
        return LEAppInfo.getFlag("-p");
    }

    String getUsername() {
        String user = LEAppInfo.getFlag("-u");
        if (user == null) {
            user = new String("!root");
        }
        return user;
    }

    void connectToPortMaster() {
        try {
            this.m_pm = new LEPortMaster(this.getHost(), this.getUsername(), this.getPassword());
        }
        catch (Exception e) {
            System.out.println("Connect failed: " + e.getMessage());
            LEDebug.getLog().logln(20, e);
        }
        if (this.m_pm == null) {
            System.out.println("Could not connect to " + this.getHost());
            this.disconnect();
        }
    }

    void disconnect() {
        if (this.m_pm != null) {
            this.m_pm.disconnect();
        }
        System.exit(0);
    }
}

