/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMManager;
import COM.livingston.backend.LEAlarmFactory;
import COM.livingston.backend.LECmdFailedFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.backend.LEDSSPMOpFailureException;
import COM.livingston.backend.LEDebugFactory;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.backend.LEPMListen;
import COM.livingston.backend.LEPortIOFactory;
import COM.livingston.backend.LESendBuf;
import COM.livingston.backend.LESendResponse;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LETokenizer;
import COM.livingston.util.LEVector;
import COM.livingston.util.MD5;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;

public class LEDSSPortMaster
extends LEObservable
implements LEObserver {
    public static final byte NC_INIT = 2;
    public static final byte NC_DISC = 3;
    public static final byte NC_COMMAND = 4;
    public static final byte NC_DOWNLOAD = 5;
    public static final byte NC_DOWNDATA = 6;
    public static final byte NC_RENAME = 7;
    public static final byte NC_STATUS = 8;
    public static final byte NC_REPLY = 9;
    public static final byte NC_RAW_WRITE = 10;
    public static final byte NC_IOSTAT = 11;
    public static final byte NC_UPLOAD = 12;
    public static final byte NC_UPDATA = 13;
    public static final byte NC_CDATA = 14;
    public static final byte NC_RESET = 15;
    public static final byte NC_NETSTATUS = 16;
    public static final byte NC_TABLE = 17;
    public static final byte NC_CHALLENGE = 18;
    public static final byte NC_MD5_PASS = 19;
    public static final byte NC_USER_PASS = 20;
    public static final byte NC_BK = 21;
    public static final byte NC_TOC = 22;
    public static final byte NC_MONITOR = 23;
    public static final byte NC_DEBUG = 24;
    public static final byte NC_DELTA = 25;
    public static final byte NC_MONMESSAGE = 26;
    public static final byte NC_DBGMESSAGE = 27;
    public static final byte NC_DELTAMSG = 28;
    public static final byte NC_ALARMS = 29;
    public static final byte NC_ALARMMSG = 30;
    public static final byte NC_ENTITY = 31;
    public static final byte NC_ENTITYMSG = 32;
    public static final byte NC_NEWCOMMAND = 33;
    public static final byte NC_NEWCMDMSG = 34;
    public static final byte NC_SUCCESS = 115;
    public static final byte NC_FAIL = 102;
    public static final byte NC_ID = 101;
    public static final int CONTROL_PORT = 1643;
    public static final String REQ_TIMEOUT = "Request timedout";
    public static final String UNEXPLAINED = "Unexplained error";
    protected static final String TEST_COMMAND = "version";
    protected static final String NC_MORE = "-- Press Return for More -- ";
    protected static FileWriter s_dbgFile;
    protected static PrintWriter s_pw;
    protected static int TIMEOUT_MILLIS;
    protected String m_hostname;
    protected String m_username;
    protected String m_password;
    protected boolean m_oneTimePass;
    protected Socket m_pmfd;
    protected LEPMListen m_listener;
    protected OutputStream m_outStream;
    protected LESendBuf m_sbOut;
    protected boolean m_newCommand = false;
    protected boolean m_rebooting = false;
    protected LEVector m_threads = new LEVector();
    protected LEVector m_sbInQ;

    public LEDSSPortMaster(String string, String string2, String string3) throws IOException, LEDSSException {
        this.initialize(string, string2, string3);
        this.connectUser();
    }

    public LEDSSPortMaster(String string, String string2, boolean bl) throws IOException, LEDSSException {
        this.initialize(string, null, string2);
        this.m_oneTimePass = bl;
        if (this.m_oneTimePass) {
            this.connectOTP();
            return;
        }
        this.connect();
    }

    public LEDSSPortMaster(String string, String string2) throws IOException, LEDSSException {
        this.initialize(string, null, string2);
        this.connect();
    }

    public LEDSSPortMaster() {
        this.initialize();
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public boolean isConnected() {
        if (this.m_rebooting) {
            return false;
        }
        return this.m_pmfd != null;
    }

    public LEPMCommand execute(String string) {
        return this.execute(string, TIMEOUT_MILLIS);
    }

    public LEPMCommand execute(String string, int n) {
        LEPMCommand lEPMCommand = new LEPMCommand(string);
        int n2 = 0;
        if (string != null) {
            n2 = string.length();
        }
        if (n2 == 0) {
            lEPMCommand.setStatus(false);
            return lEPMCommand;
        }
        LEDebug.getLog().logln(40, "Executing: " + string);
        if (LEPMCommand.IsReboot(string)) {
            return this.reboot(lEPMCommand);
        }
        return this.execute(lEPMCommand, n);
    }

    public long debug(int n, int n2) throws LEDSSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        stringBuffer.append(" 1");
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)24, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killDebug(long l) throws LEDSSException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)24, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long delta(int n, int n2) throws LEDSSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        String string = new String(stringBuffer);
        try {
            LESendResponse lESendResponse = this.send((byte)25, (short)string.length(), string, false);
            if (!lESendResponse.successful()) {
                throw this.getLEDSSException(lESendResponse);
            }
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killDelta(long l) throws LEDSSException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)25, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long alarm(int n) throws LEDSSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(" 1");
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)29, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void clearAlarm(long l) throws LEDSSException {
        String string = new String(String.valueOf(Long.toString(l)) + " 2");
        LESendResponse lESendResponse = this.send((byte)29, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public void killAlarm(long l) throws LEDSSException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)29, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long monitor(int n, int n2) throws LEDSSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)23, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killMonitor(long l) throws LEDSSException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)23, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public void connectUser() throws IOException, LEDSSException {
        this.preConnect();
        try {
            if (this.m_username.equals("!root")) {
                this.connect();
                return;
            }
            byte[] byArray = new byte[this.m_password.length() + 65];
            byte[] byArray2 = this.m_username.getBytes();
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray2 = this.m_password.getBytes();
            System.arraycopy(byArray2, 0, byArray, 64, byArray2.length);
            LESendResponse lESendResponse = this.send((byte)20, (short)byArray.length, byArray, false);
            if (lESendResponse.successful()) {
                this.postConnect();
                return;
            }
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        catch (UnknownHostException unknownHostException) {
            String string = "Unknown host: " + this.m_hostname;
            this.disconnect();
            throw new UnknownHostException(string);
        }
        catch (LEDSSPMOpFailureException lEDSSPMOpFailureException) {
            String string = lEDSSPMOpFailureException.getMessage();
            this.disconnect();
            throw new LEDSSPMAuthFailureException(string);
        }
    }

    public void connectOTP() throws IOException, LEDSSException {
        this.preConnect();
        LESendResponse lESendResponse = this.send((byte)2, (short)this.m_password.length(), this.m_password, false);
        if (!lESendResponse.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    public void connect() throws IOException, LEDSSException {
        this.preConnect();
        byte[] byArray = new byte[]{0};
        LESendResponse lESendResponse = this.send((byte)18, (short)1, byArray, false);
        if (!lESendResponse.successful()) {
            this.connectOTP();
            return;
        }
        MD5 mD5 = new MD5();
        LETokenizer lETokenizer = lESendResponse.getStreamTok();
        lETokenizer.getNextRawBytes(1);
        byte[] byArray2 = lETokenizer.getNextRawBytes(16);
        mD5.update(this.m_password);
        mD5.update(byArray2);
        mD5.update("Command> ");
        byArray2 = mD5.digest();
        lESendResponse = this.send((byte)19, (short)16, byArray2, false);
        if (!lESendResponse.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    public void disconnect() {
        this.disconnect(2);
    }

    public boolean reconnect() {
        if (this.isConnected()) {
            return true;
        }
        try {
            if (this.m_oneTimePass) {
                this.connectOTP();
            } else if (this.m_username != null) {
                this.connectUser();
            } else {
                this.connect();
            }
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return this.isConnected();
    }

    LEPMCommand reboot(LEPMCommand lEPMCommand) {
        LEDebug.getLog().logln(40, "** REBOOTING **");
        this.m_rebooting = true;
        boolean bl = false;
        lEPMCommand = this.execute(lEPMCommand);
        if (!lEPMCommand.getStatus()) {
            this.m_rebooting = false;
            return lEPMCommand;
        }
        this.disconnect(4);
        if (!this.waitAndReconnect() && !this.waitAndReconnect()) {
            bl = true;
        }
        if (bl) {
            LEStatusMessage lEStatusMessage = new LEStatusMessage(2);
            LEAMManager.Process(this.m_hostname, "STATUS", lEStatusMessage);
        }
        return lEPMCommand;
    }

    boolean waitAndReconnect() {
        boolean bl = false;
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
            bl = this.reconnect();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    void disconnect(int n) {
        try {
            if (this.m_pmfd != null) {
                if (this.m_listener != null) {
                    this.m_listener.shutdown();
                }
                this.m_listener = null;
                LEStatusMessage lEStatusMessage = new LEStatusMessage(n);
                LEAMManager.Process(this.m_hostname, "STATUS", lEStatusMessage);
                this.m_outStream = null;
                this.m_pmfd = null;
                this.m_rebooting = false;
                return;
            }
        }
        catch (Exception exception) {
            this.m_pmfd = null;
        }
    }

    public synchronized void update(LEObservable lEObservable, Object object) {
        this.m_sbInQ.addElement(object);
        this.notifyAll();
        if (object instanceof IOException) {
            this.disconnect();
            Exception exception = (Exception)object;
            LEStatusMessage lEStatusMessage = new LEStatusMessage(3, exception);
            LEAMManager.Process(this.m_hostname, "STATUS", lEStatusMessage);
            return;
        }
        if (object instanceof Exception) {
            this.disconnect();
            Exception exception = (Exception)object;
            LEDSSException lEDSSException = new LEDSSException(exception.getMessage());
            LEStatusMessage lEStatusMessage = new LEStatusMessage(3, lEDSSException);
            LEAMManager.Process(this.m_hostname, "STATUS", lEStatusMessage);
        }
    }

    public synchronized void finalize() {
        this.disconnect();
    }

    public boolean supportsEntities() {
        return this.m_newCommand;
    }

    protected void postConnect() throws LEDSSException {
        this.testNewCommand();
        LEStatusMessage lEStatusMessage = new LEStatusMessage(1);
        LEAMManager.Process(this.m_hostname, "STATUS", lEStatusMessage);
    }

    protected void testNewCommand() {
        try {
            LESendResponse lESendResponse = this.send((byte)33, (short)TEST_COMMAND.length(), TEST_COMMAND, true);
            if (lESendResponse.successful()) {
                this.recv(true);
                this.m_newCommand = true;
            } else {
                this.m_newCommand = false;
            }
            this.done();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected LEPMCommand execute(LEPMCommand lEPMCommand) {
        return this.execute(lEPMCommand, TIMEOUT_MILLIS);
    }

    protected LEPMCommand execute(LEPMCommand lEPMCommand, int n) {
        LESendResponse lESendResponse;
        boolean bl = false;
        String string = lEPMCommand.getCommand();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_newCommand) {
            lESendResponse = this.send((byte)33, (short)string.length(), string, true, n);
            if (lESendResponse.successful()) {
                while (!bl && lESendResponse.m_opCode != 9) {
                    String string2 = new String(lESendResponse.m_data, 0, (int)lESendResponse.m_sendLength);
                    int n2 = string2.indexOf(NC_MORE);
                    if (n2 > -1) {
                        string2 = string2.substring(0, n2);
                    }
                    stringBuffer.append(string2);
                    lESendResponse = this.recv(true, n);
                    if (lESendResponse.successful()) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
            this.done();
        } else {
            lESendResponse = this.send((byte)4, (short)string.length(), string, false, n);
            if (!lESendResponse.successful()) {
                bl = true;
            }
        }
        if (lESendResponse.timedout()) {
            lEPMCommand.setResult("Connection lost");
        } else if (lESendResponse.getException() != null) {
            lEPMCommand.setResult("Connection lost");
        } else {
            lEPMCommand.setResult(new String(stringBuffer));
        }
        if (bl) {
            lEPMCommand.setStatus(false);
            LEAMManager.Process(this.m_hostname, "CMD_FAILED", lEPMCommand);
        }
        return lEPMCommand;
    }

    public LESendResponse send(byte by, short s, String string, boolean bl) {
        return this.send(by, s, string, bl, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte by, short s, String string, boolean bl, int n) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[s + 1];
        System.arraycopy(byArray, 0, byArray2, 0, s);
        short s2 = s;
        s = (short)(s2 + 1);
        byArray2[s2] = 0;
        return this.send(by, s, byArray2, bl, n);
    }

    public LESendResponse send(byte by, short s, byte[] byArray, boolean bl) {
        return this.send(by, s, byArray, bl, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte by, short s, byte[] byArray, boolean bl, int n) {
        this.send(by, s, byArray);
        return this.recv(bl, n);
    }

    public synchronized void send(byte by, short s, byte[] byArray) {
        Thread thread = Thread.currentThread();
        this.m_threads.addElement(thread);
        while (thread != (Thread)this.m_threads.firstElement()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        this.m_sbInQ.removeAllElements();
        this.m_sbOut.reset();
        this.m_sbOut.m_idByte = (byte)101;
        this.m_sbOut.m_opCode = by;
        this.m_sbOut.m_sendLength = s;
        System.arraycopy(byArray, 0, this.m_sbOut.m_data, 0, s);
        try {
            this.m_outStream.write(this.m_sbOut.getBytes(), 0, s + 4);
            this.m_outStream.flush();
            this.dumpLogV("Sent: " + LEDSSPortMaster.GetOpCodeString(this.m_sbOut.m_opCode));
            LEDSSPortMaster.dumpSRMsg("Sent: " + LEDSSPortMaster.GetOpCodeString(this.m_sbOut.m_opCode));
            LEDSSPortMaster.dumpSRMsg(this.m_sbOut.toString());
            LEDSSPortMaster.dumpSRMsg("End send");
            LEDSSPortMaster.dumpSRMsg("");
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.update(this, exception);
            return;
        }
    }

    public LESendResponse recv(boolean bl) {
        return this.recv(bl, TIMEOUT_MILLIS);
    }

    public synchronized LESendResponse recv(boolean bl, long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        boolean bl2 = false;
        while (!bl2 && this.m_sbInQ.size() == 0) {
            l3 = System.currentTimeMillis() - l2;
            try {
                this.wait(l - l3);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            if (System.currentTimeMillis() - l2 < l) continue;
            bl2 = true;
        }
        LESendResponse lESendResponse = null;
        if (this.m_sbInQ.size() > 0) {
            Object object = this.m_sbInQ.removeElementAt(0);
            if (object instanceof LESendResponse) {
                lESendResponse = (LESendResponse)object;
            } else if (object instanceof Exception) {
                lESendResponse = new LESendResponse((Exception)object);
            }
        } else {
            lESendResponse = new LESendResponse();
            lESendResponse.setTimeout(true);
        }
        lESendResponse.checkSuccess();
        if (lESendResponse.successful()) {
            this.dumpLogV("Received: " + LEDSSPortMaster.GetOpCodeString(lESendResponse.m_opCode));
            LEDSSPortMaster.dumpSRMsg("Received: " + LEDSSPortMaster.GetOpCodeString(lESendResponse.m_opCode));
            LEDSSPortMaster.dumpSRMsg(lESendResponse.toString());
            LEDSSPortMaster.dumpSRMsg("End Receive");
            LEDSSPortMaster.dumpSRMsg("");
        } else if (lESendResponse.timedout()) {
            this.dumpLogV("Received: TIMEOUT");
            LEDSSPortMaster.dumpSRMsg("Received: TIMEOUT");
            this.disconnect();
        } else if (lESendResponse.getException() != null) {
            this.dumpLogV("Received: EXCEPTION " + lESendResponse.getException().toString());
            LEDSSPortMaster.dumpSRMsg("Received: EXCEPTION " + lESendResponse.getException().toString());
        }
        if (!bl) {
            this.done();
        }
        return lESendResponse;
    }

    public synchronized void done() {
        Thread thread = Thread.currentThread();
        if (this.m_threads.size() == 0) {
            this.dumpLogV("Done called on empty queue: " + thread.getName() + ", " + this.m_threads.toString());
            return;
        }
        if (thread.equals(this.m_threads.firstElement())) {
            this.m_threads.removeElementAt(0);
        } else {
            this.dumpLogV("Done called by wrong thread: " + thread.getName() + ", " + this.m_threads.toString());
        }
        this.notifyAll();
    }

    private void preConnect() throws IOException {
        if (this.m_pmfd == null) {
            try {
                this.m_pmfd = new Socket(this.m_hostname, 1643);
            }
            catch (UnknownHostException unknownHostException) {
                String string = "Unknown host: " + this.m_hostname;
                this.disconnect();
                throw new UnknownHostException(string);
            }
            this.m_listener = new LEPMListen(new DataInputStream(this.m_pmfd.getInputStream()), this.m_hostname);
            this.m_listener.addObserver(this);
            this.m_listener.start();
            this.m_outStream = this.m_pmfd.getOutputStream();
        }
    }

    protected static String GetOpCodeString(int n) {
        String string;
        switch (n) {
            case 2: {
                string = "NC_INIT";
                break;
            }
            case 3: {
                string = "NC_DISC";
                break;
            }
            case 4: {
                string = "NC_COMMAND";
                break;
            }
            case 5: {
                string = "NC_DOWNLOAD";
                break;
            }
            case 6: {
                string = "NC_DOWNDATA";
                break;
            }
            case 7: {
                string = "NC_RENAME";
                break;
            }
            case 8: {
                string = "NC_STATUS";
                break;
            }
            case 9: {
                string = "NC_REPLY";
                break;
            }
            case 10: {
                string = "NC_RAW_WRITE";
                break;
            }
            case 11: {
                string = "NC_IOSTAT";
                break;
            }
            case 12: {
                string = "NC_UPLOAD";
                break;
            }
            case 13: {
                string = "NC_UPDATA";
                break;
            }
            case 14: {
                string = "NC_CDATA";
                break;
            }
            case 15: {
                string = "NC_RESET";
                break;
            }
            case 16: {
                string = "NC_NETSTATUS";
                break;
            }
            case 17: {
                string = "NC_TABLE";
                break;
            }
            case 18: {
                string = "NC_CHALLENGE";
                break;
            }
            case 19: {
                string = "NC_MD5_PASS";
                break;
            }
            case 20: {
                string = "NC_USER_PASS";
                break;
            }
            case 21: {
                string = "NC_BK";
                break;
            }
            case 22: {
                string = "NC_TOC";
                break;
            }
            case 23: {
                string = "NC_MONITOR";
                break;
            }
            case 25: {
                string = "NC_DELTA";
                break;
            }
            case 29: {
                string = "NC_ALARMS";
                break;
            }
            case 30: {
                string = "NC_ALARMMSG";
                break;
            }
            case 24: {
                string = "NC_DEBUG";
                break;
            }
            case 26: {
                string = "NC_MONMESSAGE";
                break;
            }
            case 27: {
                string = "NC_DBGMESSAGE";
                break;
            }
            case 28: {
                string = "NC_DELTAMSG";
                break;
            }
            case 31: {
                string = "NC_ENTITY";
                break;
            }
            case 32: {
                string = "NC_ENTITYMSG";
                break;
            }
            case 33: {
                string = "NC_NEWCOMMAND";
                break;
            }
            case 34: {
                string = "NC_NEWCMDMSG";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    protected void dumpLogV(String string) {
        LEDebug.getLog().logln(40, string);
    }

    protected void dumpLog(int n, String string) {
        LEDebug.getLog().logln(n, string);
    }

    public static void dumpSRMsg(String string) {
        if (s_pw != null && LEDebug.getLog().shouldLog(30)) {
            try {
                s_pw.println(string);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    protected synchronized void initialize() {
        this.m_sbOut = new LESendBuf();
        this.m_sbOut.setSize(2048);
        this.m_sbInQ = new LEVector(100);
        if (s_dbgFile == null) {
            try {
                String string = LEAppInfo.getUserAppDirPath("sendrecv.txt");
                File file = new File(string);
                s_dbgFile = new FileWriter(file);
                s_pw = new PrintWriter((Writer)s_dbgFile, true);
            }
            catch (Exception exception) {
                s_dbgFile = null;
                s_pw = null;
            }
        }
        LEAlarmFactory.Register();
        LECmdFailedFactory.Register();
        LEDebugFactory.Register();
        LEDeltaFactory.Register();
        LEMonitorFactory.Register();
        LEPortIOFactory.Register();
        LEStatusFactory.Register();
    }

    protected synchronized void initialize(String string, String string2, String string3) {
        this.initialize();
        this.m_hostname = string;
        this.m_username = string2;
        this.m_password = string3;
    }

    LEDSSException getLEDSSException(LESendResponse lESendResponse) {
        if (lESendResponse.timedout()) {
            return new LEDSSPMOpFailureException(REQ_TIMEOUT);
        }
        Exception exception = lESendResponse.getException();
        if (exception != null) {
            return new LEDSSPMOpFailureException(exception.getMessage());
        }
        return new LEDSSPMOpFailureException(UNEXPLAINED);
    }

    static {
        TIMEOUT_MILLIS = 15000;
    }
}

